/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.lcms.masters.entity.InterimOrder;
import org.egov.lcms.masters.repository.InterimOrderRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class InterimOrderService {
    private final InterimOrderRepository interimOrderRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public InterimOrderService(InterimOrderRepository interimOrderRepository) {
        this.interimOrderRepository = interimOrderRepository;
    }

    @Transactional
    public InterimOrder create(InterimOrder interimOrder) {
        return (InterimOrder)((Object)this.interimOrderRepository.save((Object)interimOrder));
    }

    @Transactional
    public InterimOrder update(InterimOrder interimOrder) {
        return (InterimOrder)((Object)this.interimOrderRepository.save((Object)interimOrder));
    }

    public List<InterimOrder> findAll() {
        return this.interimOrderRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"interimOrderType"}));
    }

    public InterimOrder findByCode(String code) {
        return this.interimOrderRepository.findByCode(code);
    }

    public InterimOrder findOne(Long id) {
        return (InterimOrder)((Object)this.interimOrderRepository.findOne(id));
    }

    public List<InterimOrder> search(InterimOrder interimOrder) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(InterimOrder.class);
        Root interimorder = createQuery.from(InterimOrder.class);
        createQuery.select((Selection)interimorder);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType InterimOrder2 = m.entity(InterimOrder.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (interimOrder.getInterimOrderType() == null && interimOrder.getCode() == null && interimOrder.getActive() == null) {
            resultList = this.findAll();
        } else {
            if (interimOrder.getInterimOrderType() != null) {
                String interimOrderType = "%" + interimOrder.getInterimOrderType().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)interimorder.get("interimOrderType")));
                predicates.add(cb.like(cb.lower((Expression)interimorder.get(InterimOrder2.getDeclaredSingularAttribute("interimOrderType", String.class))), interimOrderType));
            }
            if (interimOrder.getCode() != null) {
                String code = "%" + interimOrder.getCode().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)interimorder.get("code")));
                predicates.add(cb.like(cb.lower((Expression)interimorder.get(InterimOrder2.getDeclaredSingularAttribute("code", String.class))), code));
            }
            if (interimOrder.getActive() != null) {
                if (interimOrder.getActive().booleanValue()) {
                    predicates.add(cb.equal((Expression)interimorder.get(InterimOrder2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)true));
                } else {
                    predicates.add(cb.equal((Expression)interimorder.get(InterimOrder2.getDeclaredSingularAttribute("active", Boolean.class)), (Object)false));
                }
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }
}

