/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.egov.lcms.masters.entity.CourtTypeMaster;
import org.egov.lcms.masters.repository.CourtTypeMasterRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CourtTypeMasterService {
    private final CourtTypeMasterRepository courtTypeMasterRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public CourtTypeMasterService(CourtTypeMasterRepository courtTypeMasterRepository) {
        this.courtTypeMasterRepository = courtTypeMasterRepository;
    }

    @Transactional
    public CourtTypeMaster create(CourtTypeMaster courtTypeMaster) {
        return (CourtTypeMaster)((Object)this.courtTypeMasterRepository.save((Object)courtTypeMaster));
    }

    public List<CourtTypeMaster> getCourtTypeList() {
        return this.courtTypeMasterRepository.findAll();
    }

    @Transactional
    public CourtTypeMaster update(CourtTypeMaster courtTypeMaster) {
        return (CourtTypeMaster)((Object)this.courtTypeMasterRepository.save((Object)courtTypeMaster));
    }

    public List<CourtTypeMaster> findAll() {
        return this.courtTypeMasterRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"courtType"}));
    }

    public CourtTypeMaster findByCode(String code) {
        return this.courtTypeMasterRepository.findByCode(code);
    }

    public CourtTypeMaster findOne(Long id) {
        return (CourtTypeMaster)((Object)this.courtTypeMasterRepository.findOne(id));
    }

    public List<CourtTypeMaster> getActiveCourtTypes() {
        return this.courtTypeMasterRepository.findByActiveTrueOrderByCourtTypeAsc();
    }

    public List<CourtTypeMaster> search(CourtTypeMaster courtTypeMaster) {
        List resultList;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery createQuery = cb.createQuery(CourtTypeMaster.class);
        Root courttypeMasterObj = createQuery.from(CourtTypeMaster.class);
        createQuery.select((Selection)courttypeMasterObj);
        Metamodel m = this.entityManager.getMetamodel();
        EntityType CourttypeMaster = m.entity(CourtTypeMaster.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (courtTypeMaster.getCode() == null && courtTypeMaster.getCourtType() == null && courtTypeMaster.getActive() == null) {
            resultList = this.findAll();
        } else {
            if (courtTypeMaster.getCode() != null) {
                String code = "%" + courtTypeMaster.getCode().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)courttypeMasterObj.get("code")));
                predicates.add(cb.like(cb.lower((Expression)courttypeMasterObj.get(CourttypeMaster.getDeclaredSingularAttribute("code", String.class))), code));
            }
            if (courtTypeMaster.getCourtType() != null) {
                String courtType = "%" + courtTypeMaster.getCourtType().toLowerCase() + "%";
                predicates.add(cb.isNotNull((Expression)courttypeMasterObj.get("courtType")));
                predicates.add(cb.like(cb.lower((Expression)courttypeMasterObj.get(CourttypeMaster.getDeclaredSingularAttribute("courtType", String.class))), courtType));
            }
            if (courtTypeMaster.getActive() != null) {
                if (courtTypeMaster.getActive().booleanValue()) {
                    predicates.add(cb.equal((Expression)courttypeMasterObj.get(CourttypeMaster.getDeclaredSingularAttribute("active", Boolean.class)), (Object)true));
                } else {
                    predicates.add(cb.equal((Expression)courttypeMasterObj.get(CourttypeMaster.getDeclaredSingularAttribute("active", Boolean.class)), (Object)false));
                }
            }
            createQuery.where(predicates.toArray(new Predicate[0]));
            TypedQuery query = this.entityManager.createQuery(createQuery);
            resultList = query.getResultList();
        }
        return resultList;
    }
}

