/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.lcms.masters.entity.CourtTypeMaster;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="eglc_petitiontype_master")
@Unique(id="id", tableName="eglc_petitiontype_master", columnName={"code"}, fields={"code"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGLC_PETITIONTYPE_MASTER", sequenceName="SEQ_EGLC_PETITIONTYPE_MASTER", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class PetitionTypeMaster
extends AbstractAuditable {
    private static final long serialVersionUID = 796823780349590496L;
    public static final String SEQ_PETITIONTYPE = "SEQ_EGLC_PETITIONTYPE_MASTER";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_PETITIONTYPE_MASTER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @ManyToOne
    @JoinColumn(name="courttype")
    @NotNull
    @Audited
    private CourtTypeMaster courtType;
    @NotNull
    @Length(min=1, max=25)
    @Audited
    private String code;
    @NotNull
    @Length(min=1, max=128)
    @Audited
    private String petitionType;
    @Min(value=1L)
    @Max(value=1000L)
    private Long orderNumber;
    @NotNull
    @Audited
    private Boolean active;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public CourtTypeMaster getCourtType() {
        return this.courtType;
    }

    public void setCourtType(CourtTypeMaster courtType) {
        this.courtType = courtType;
    }

    public String getPetitionType() {
        return this.petitionType;
    }

    public void setPetitionType(String petitionType) {
        this.petitionType = petitionType;
    }

    public Long getOrderNumber() {
        return this.orderNumber;
    }

    public void setOrderNumber(Long orderNumber) {
        this.orderNumber = orderNumber;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }
}

