/*
 * Decompiled with CFR 0.152.
 */
package org.egov.lcms.masters.entity;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.egov.commons.Bank;
import org.egov.commons.Bankbranch;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eglc_advocate_master")
@Unique(id="id", tableName="eglc_advocate_master", columnName={"name", "mobilenumber", "pannumber"}, fields={"name", "mobileNumber", "panNumber"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EGLC_ADVOCATE_MASTER", sequenceName="SEQ_EGLC_ADVOCATE_MASTER", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class AdvocateMaster
extends AbstractAuditable {
    private static final long serialVersionUID = 796823780349590496L;
    public static final String SEQ_ADVOCATE_MASTER = "SEQ_EGLC_ADVOCATE_MASTER";
    @Id
    @GeneratedValue(generator="SEQ_EGLC_ADVOCATE_MASTER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Audited
    @Length(max=20)
    private String salutation;
    @NotNull
    @Length(min=3, max=100)
    @Audited
    private String name;
    @Length(min=3, max=128)
    @Audited
    private String address;
    @Audited
    @Length(max=20)
    @SafeHtml
    private String contactPhone;
    @Audited
    @Length(max=20)
    private String specilization;
    @Audited
    @Length(max=10)
    @SafeHtml
    @Pattern(regexp="^((\\+)?(\\d{2}[-]))?(\\d{10}){1}?$")
    private String mobileNumber;
    @Audited
    @Email(regexp="^[\\w\\.-]+@([\\w\\-]+\\.)+[a-zA-Z]{2,4}$")
    @SafeHtml
    private String email;
    @NotNull
    @Min(value=1L)
    @Audited
    private double monthlyRenumeration;
    @NotNull
    @Audited
    private Boolean isRetaineradvocate;
    @Audited
    private String firmName;
    @NotNull
    @Length(max=20)
    @Audited
    private String panNumber;
    @Audited
    @NotNull
    private Boolean isActive;
    @Audited
    @NotNull
    private boolean isSenioradvocate;
    @Audited
    private String paymentmode;
    @Length(max=20)
    @Audited
    private String bankaccount;
    @Length(max=20)
    @Audited
    private String ifsccode;
    @Length(max=20)
    @Audited
    private String tinumber;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="bankname")
    @NotAudited
    private Bank bankName;
    @Audited
    private double fee;
    @Length(max=256)
    @Audited
    private String remarks;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="bankbranch")
    @NotAudited
    private Bankbranch bankBranch;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public String getSalutation() {
        return this.salutation;
    }

    public void setSalutation(String salutation) {
        this.salutation = salutation;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSpecilization() {
        return this.specilization;
    }

    public void setSpecilization(String specilization) {
        this.specilization = specilization;
    }

    public String getFirmName() {
        return this.firmName;
    }

    public void setFirmName(String firmName) {
        this.firmName = firmName;
    }

    public String getPanNumber() {
        return this.panNumber;
    }

    public void setPanNumber(String panNumber) {
        this.panNumber = panNumber;
    }

    public Bank getBankName() {
        return this.bankName;
    }

    public void setBankName(Bank bankName) {
        this.bankName = bankName;
    }

    public double getFee() {
        return this.fee;
    }

    public void setFee(double fee) {
        this.fee = fee;
    }

    public Bankbranch getBankBranch() {
        return this.bankBranch;
    }

    public void setBankBranch(Bankbranch bankBranch) {
        this.bankBranch = bankBranch;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBankaccount() {
        return this.bankaccount;
    }

    public void setBankaccount(String bankaccount) {
        this.bankaccount = bankaccount;
    }

    public String getIfsccode() {
        return this.ifsccode;
    }

    public void setIfsccode(String ifsccode) {
        this.ifsccode = ifsccode;
    }

    public String getTinumber() {
        return this.tinumber;
    }

    public void setTinumber(String tinumber) {
        this.tinumber = tinumber;
    }

    public void setSenioradvocate(boolean isSenioradvocate) {
        this.isSenioradvocate = isSenioradvocate;
    }

    public Boolean getIsRetaineradvocate() {
        return this.isRetaineradvocate;
    }

    public void setIsRetaineradvocate(Boolean isRetaineradvocate) {
        this.isRetaineradvocate = isRetaineradvocate;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    public boolean getIsSenioradvocate() {
        return this.isSenioradvocate;
    }

    public void setIsSenioradvocate(boolean isSenioradvocate) {
        this.isSenioradvocate = isSenioradvocate;
    }

    public String getPaymentmode() {
        return this.paymentmode;
    }

    public void setPaymentmode(String paymentmode) {
        this.paymentmode = paymentmode;
    }

    public double getMonthlyRenumeration() {
        return this.monthlyRenumeration;
    }

    public void setMonthlyRenumeration(double monthlyRenumeration) {
        this.monthlyRenumeration = monthlyRenumeration;
    }
}

