/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.commons;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Pattern;
import org.egov.commons.CChartOfAccounts;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="eg_designation")
@Unique(fields={"name", "code"}, enableDfltMsg=true)
@SequenceGenerator(name="SEQ_EG_DESIGNATION", sequenceName="SEQ_EG_DESIGNATION", allocationSize=1)
@NamedQuery(name="getDesignationForListOfDesgNames", query="from Designation where trim(upper(name)) in(:param_0)")
public class Designation
extends AbstractAuditable {
    public static final String SEQ_DESIGNATION = "SEQ_EG_DESIGNATION";
    private static final long serialVersionUID = -3775503109625394145L;
    @Id
    @GeneratedValue(generator="SEQ_EG_DESIGNATION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    @Pattern(regexp="[A-Za-z-_ ]+", message="Name should contain letters with space and (-,_)")
    private String name;
    @NotBlank
    @SafeHtml
    private String code;
    @SafeHtml
    private String description;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="chartofaccounts")
    private CChartOfAccounts chartOfAccounts;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="egeis_desig_rolemapping", joinColumns={@JoinColumn(name="designationid")}, inverseJoinColumns={@JoinColumn(name="roleid")})
    private Set<Role> roles = new HashSet<Role>();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CChartOfAccounts getChartOfAccounts() {
        return this.chartOfAccounts;
    }

    public void setChartOfAccounts(CChartOfAccounts chartOfAccounts) {
        this.chartOfAccounts = chartOfAccounts;
    }
}

