/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.security.spring.event.listeners;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.egov.infstr.security.spring.event.EventType;
import org.egov.infstr.security.spring.event.actions.ApplicationSecurityEventAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.access.event.AuthorizationFailureEvent;
import org.springframework.security.access.event.AuthorizedEvent;
import org.springframework.security.authentication.event.AuthenticationFailureBadCredentialsEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.web.session.HttpSessionDestroyedEvent;

public class ApplicationSecurityEventListenerAdaptor
implements ApplicationListener<ApplicationEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationSecurityEventListenerAdaptor.class);
    private Map<EventType, List<ApplicationSecurityEventAction<ApplicationEvent>>> applicationSecurityEventActions;

    public void setApplicationSecurityEventActions(Map<EventType, List<ApplicationSecurityEventAction<ApplicationEvent>>> applicationSecurityEventActions) {
        this.applicationSecurityEventActions = applicationSecurityEventActions;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof AuthorizedEvent) {
            AuthorizedEvent authorizedEvent = (AuthorizedEvent)event;
            LOG.debug("User {} authorized to access {}", (Object)authorizedEvent.getAuthentication().getName());
            this.doAction((ApplicationEvent)authorizedEvent, EventType.AuthorizedEvent);
        } else if (event instanceof AuthorizationFailureEvent) {
            AuthorizationFailureEvent authorizationFailureEvent = (AuthorizationFailureEvent)event;
            LOG.debug("Authorization failed for User : {}", (Object)authorizationFailureEvent.getAuthentication().getName());
            this.doAction((ApplicationEvent)authorizationFailureEvent, EventType.AuthorizationFailureEvent);
        } else if (event instanceof AuthenticationFailureBadCredentialsEvent) {
            AuthenticationFailureBadCredentialsEvent badCredentialsEvent = (AuthenticationFailureBadCredentialsEvent)event;
            LOG.debug("User {} has entered bad credentials", (Object)badCredentialsEvent.getAuthentication().getName());
            this.doAction((ApplicationEvent)badCredentialsEvent, EventType.AuthenticationFailureBadCredentialsEvent);
        } else if (event instanceof InteractiveAuthenticationSuccessEvent) {
            InteractiveAuthenticationSuccessEvent authenticationSuccessEvent = (InteractiveAuthenticationSuccessEvent)event;
            LOG.debug("User {} authenticated successfully.", (Object)authenticationSuccessEvent.getAuthentication().getName());
            this.doAction((ApplicationEvent)authenticationSuccessEvent, EventType.InteractiveAuthenticationSuccessEvent);
        } else if (event instanceof HttpSessionDestroyedEvent) {
            HttpSessionDestroyedEvent httpSessionDestroyedEvent = (HttpSessionDestroyedEvent)event;
            LOG.debug("User has logged out or Http Session expired, Session ID : {} at {}", (Object)httpSessionDestroyedEvent.getSession().getId(), (Object)new Date(httpSessionDestroyedEvent.getTimestamp()));
            this.doAction((ApplicationEvent)httpSessionDestroyedEvent, EventType.HttpSessionDestroyedEvent);
        }
    }

    private void doAction(ApplicationEvent event, EventType eventType) {
        if (this.applicationSecurityEventActions.containsKey((Object)eventType)) {
            for (ApplicationSecurityEventAction<ApplicationEvent> applicationAction : this.applicationSecurityEventActions.get((Object)eventType)) {
                applicationAction.doAction(event);
            }
        }
    }
}

