/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infstr.security.spring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.egov.infra.admin.master.entity.Action;
import org.egov.infra.admin.master.service.ActionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.stereotype.Component;

@Component
public class EGovFilterInvocationDefinitionSource
implements FilterInvocationSecurityMetadataSource {
    private List<String> excludePatterns = new ArrayList<String>();
    @Autowired
    private ActionService actionService;

    public void setExcludePatterns(List<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public Collection<ConfigAttribute> getAttributes(Object object) {
        FilterInvocation invocation = (FilterInvocation)object;
        String contextRoot = invocation.getHttpRequest().getContextPath().replace("/", "");
        return this.lookupAttributes(contextRoot, invocation.getRequestUrl());
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return Collections.unmodifiableCollection(new ArrayList());
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    private Collection<ConfigAttribute> lookupAttributes(String contextRoot, String url) {
        if (url.startsWith("/login") || url.startsWith("/public") || this.isPatternExcluded(url).booleanValue()) {
            return Collections.emptyList();
        }
        Action action = this.actionService.getActionByUrlAndContextRoot(url, contextRoot);
        if (action != null) {
            ArrayList<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
            action.getRoles().forEach(role -> configAttributes.add((ConfigAttribute)new SecurityConfig(role.getName())));
            return configAttributes;
        }
        return Collections.emptyList();
    }

    private Boolean isPatternExcluded(String pattern) {
        return this.excludePatterns.parallelStream().anyMatch(excludePattern -> pattern.startsWith(excludePattern.trim()));
    }
}

