/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.workflow.inbox;

import java.util.List;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.inbox.InboxRenderService;
import org.egov.infstr.services.PersistenceService;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class DefaultInboxRenderServiceImpl<T extends StateAware>
implements InboxRenderService<T> {
    private final Class<T> stateAwareType;
    private final PersistenceService<T, Long> stateAwarePersistenceService;

    public DefaultInboxRenderServiceImpl(PersistenceService<T, Long> stateAwarePersistenceService) {
        this.stateAwarePersistenceService = stateAwarePersistenceService;
        this.stateAwareType = stateAwarePersistenceService.getType();
    }

    @Override
    public List<T> getAssignedWorkflowItems(Long userId, List<Long> owners) {
        return this.stateAwarePersistenceService.getSession().createCriteria(this.stateAwareType).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).add((Criterion)Restrictions.eq((String)"state.type", (Object)this.stateAwareType.getSimpleName())).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.ne((String)"state.status", (Object)((Object)State.StateStatus.ENDED))).add(Restrictions.not((Criterion)Restrictions.conjunction().add((Criterion)Restrictions.eq((String)"state.status", (Object)((Object)State.StateStatus.STARTED))).add((Criterion)Restrictions.eq((String)"state.createdBy.id", (Object)userId)))).addOrder(Order.desc((String)"state.createdDate")).list();
    }

    @Override
    public List<T> getDraftWorkflowItems(Long userId, List<Long> owners) {
        return this.stateAwarePersistenceService.getSession().createCriteria(this.stateAwareType).setFetchMode("state", FetchMode.JOIN).createAlias("state", "state").setFlushMode(FlushMode.MANUAL).setReadOnly(true).setCacheable(true).add((Criterion)Restrictions.eq((String)"state.type", (Object)this.stateAwareType.getSimpleName())).add(Restrictions.in((String)"state.ownerPosition.id", owners)).add((Criterion)Restrictions.eq((String)"state.createdBy.id", (Object)userId)).add((Criterion)Restrictions.eq((String)"state.status", (Object)((Object)State.StateStatus.STARTED))).addOrder(Order.asc((String)"state.createdDate")).list();
    }
}

