/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

public class WebUtils {
    private WebUtils() {
    }

    public static String extractRequestedDomainName(HttpServletRequest httpRequest) {
        String requestURL = httpRequest.getRequestURL().toString();
        return WebUtils.extractRequestedDomainName(requestURL);
    }

    public static String extractRequestedDomainName(String requestURL) {
        int domainNameStartIndex;
        int domainNameEndIndex = requestURL.indexOf(47, domainNameStartIndex = requestURL.indexOf("://") + 3);
        String domainName = requestURL.substring(domainNameStartIndex, domainNameEndIndex > 0 ? domainNameEndIndex : requestURL.length());
        if (domainName.contains(":")) {
            domainName = domainName.split(":")[0];
        }
        return domainName;
    }

    public static String extractRequestDomainURL(HttpServletRequest httpRequest, boolean withContext) {
        StringBuilder url = new StringBuilder(httpRequest.getRequestURL());
        String uri = httpRequest.getRequestURI();
        return withContext ? url.substring(0, url.length() - uri.length() + httpRequest.getContextPath().length()) + "/" : url.substring(0, url.length() - uri.length());
    }

    public static String extractQueryParamsFromUrl(String url) {
        return url.substring(url.indexOf(63) + 1, url.length());
    }

    public static String extractURLWithoutQueryParams(String url) {
        return url.substring(0, url.indexOf(63));
    }

    public static String currentContextPath(ServletRequest request) {
        return request.getServletContext().getContextPath().toUpperCase().replace("/", "");
    }

    public static ResponseEntity<InputStreamResource> reportToResponseEntity(ReportRequest reportRequest, ReportOutput reportOutput) {
        MediaType mediaType = MediaType.TEXT_PLAIN;
        if (reportRequest.getReportFormat().equals((Object)ReportFormat.PDF)) {
            mediaType = MediaType.parseMediaType((String)"application/pdf");
        } else if (reportRequest.getReportFormat().equals((Object)ReportFormat.XLS)) {
            mediaType = MediaType.parseMediaType((String)"application/vnd.ms-excel");
        }
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(mediaType).cacheControl(CacheControl.noCache())).contentLength((long)reportOutput.getReportOutputData().length).header("content-disposition", new String[]{"inline;filename=" + reportRequest.reportOutputFileName()})).body((Object)new InputStreamResource((InputStream)new ByteArrayInputStream(reportOutput.getReportOutputData())));
    }

    public static void setUserLocale(User user, HttpServletRequest request, HttpServletResponse response) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
        localeResolver.setLocale(request, response, user.locale());
    }
}

