/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.security.audit.service;

import java.util.Date;
import java.util.Optional;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.security.audit.entity.LoginAttempt;
import org.egov.infra.security.audit.repository.LoginAttemptRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class LoginAttemptService {
    private final LoginAttemptRepository loginAttemptRepository;
    @Autowired
    private UserService userService;

    @Autowired
    public LoginAttemptService(LoginAttemptRepository loginAttemptRepository) {
        this.loginAttemptRepository = loginAttemptRepository;
    }

    public Optional<LoginAttempt> updateFailedAttempt(String username) {
        User user = this.userService.getUserByUsername(username);
        if (user != null) {
            LoginAttempt loginAttempt = this.getLoginAttempt(username);
            if (loginAttempt == null) {
                loginAttempt = new LoginAttempt();
                loginAttempt.setUsername(username);
                loginAttempt.setFailedAttempts(1);
            } else {
                loginAttempt.setFailedAttempts(loginAttempt.getFailedAttempts() + 1);
            }
            loginAttempt.setLastModifiedOn(new Date());
            if (loginAttempt.getFailedAttempts() >= 5) {
                user.setAccountLocked(true);
                this.userService.updateUser(user);
            }
            return Optional.of(this.loginAttemptRepository.save(loginAttempt));
        }
        return Optional.empty();
    }

    public void resetFailedAttempt(String username) {
        LoginAttempt loginAttempt = this.getLoginAttempt(username);
        if (loginAttempt != null) {
            loginAttempt.setFailedAttempts(0);
            loginAttempt.setLastModifiedOn(new Date());
            this.loginAttemptRepository.save(loginAttempt);
            User user = this.userService.getUserByUsername(username);
            user.setAccountLocked(false);
            this.userService.updateUser(user);
        }
    }

    @Transactional(readOnly=true)
    public LoginAttempt getLoginAttempt(String username) {
        return this.loginAttemptRepository.findByUsername(username);
    }
}

