/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.reporting.util;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.ServletActionContext;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.NumberUtil;
import org.egov.infra.web.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportUtil.class);
    private static final String TENANT_REPORT_FILE_PATH = "/reports/templates/%s/%s";
    private static final String TENANT_COMMON_REPORT_FILE_LOCATION = "common";

    private ReportUtil() {
    }

    public static InputStream getImageAsStream(String imageName) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("/egi/resources/global/images/" + imageName);
    }

    public static String getCityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public static InputStream getTemplateAsStream(String templateName) {
        InputStream fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(TENANT_REPORT_FILE_PATH, ApplicationThreadLocals.getTenantID(), templateName));
        if (fileInputStream == null) {
            fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format(TENANT_REPORT_FILE_PATH, TENANT_COMMON_REPORT_FILE_LOCATION, templateName));
        }
        if (fileInputStream == null) {
            fileInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(String.format("/reports/templates/%s", templateName));
        }
        if (fileInputStream == null) {
            String errMsg = "File [" + templateName + "] could not be loaded from CLASSPATH!";
            LOGGER.error(errMsg);
            throw new ApplicationRuntimeException(errMsg);
        }
        return fileInputStream;
    }

    public static Properties loadReportConfig() {
        Properties reportProps = null;
        try {
            InputStream configStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("/config/reports.properties");
            if (configStream != null) {
                reportProps = new Properties();
                reportProps.load(configStream);
            }
            return reportProps;
        }
        catch (IOException e) {
            LOGGER.warn("Exception while loading report configuration file [{}]", (Object)"/config/reports.properties", (Object)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static Object fetchFromDBSql(Connection connection, String sqlQuery) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Date getDate(int year, int month, int date) {
        return DateUtils.getDate(year, month, date);
    }

    public static Date today() {
        return DateUtils.today();
    }

    public static Date now() {
        return DateUtils.now();
    }

    public static Date tomorrow() {
        return DateUtils.tomorrow();
    }

    public static Date add(Date inputDate, int addType, int addAmount) {
        return DateUtils.add(inputDate, addType, addAmount);
    }

    public static String amountInWords(BigDecimal amount) {
        return NumberUtil.amountInWords(amount);
    }

    public static String formatNumber(BigDecimal number, int fractionDigits, boolean useGrouping) {
        return NumberUtil.formatNumber(number, fractionDigits, useGrouping);
    }

    public static String logoBasePath() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL(request, false);
        return url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo"));
    }

    public static String cancelledWatermarkAbsolutePath() {
        HttpServletRequest request = ServletActionContext.getRequest();
        String url = WebUtils.extractRequestDomainURL(request, false);
        return url.concat("/egi").concat("/resources/global/images/cancelled_watermark.png");
    }
}

