/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.messaging.sms;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.egov.infra.config.core.GlobalSettings;
import org.egov.infra.messaging.MessagePriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class SMSService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SMSService.class);
    private static final String SMS_PRIORITY_PARAM_VALUE = "sms.%s.priority.param.value";
    @Autowired
    private Environment environment;
    @Value(value="${sms.enabled}")
    private boolean smsEnabled;
    @Value(value="${sms.priority.enabled}")
    private boolean smsPriorityEnabled;
    @Value(value="${sms.priority.param.name}")
    private String smsPriorityParamName;
    @Value(value="${sms.provider.url}")
    private String smsProviderURL;
    @Value(value="${sms.sender.req.param.name}")
    private String senderReqParamName;
    @Value(value="${sms.sender}")
    private String sender;
    @Value(value="${sms.sender.username.req.param.name}")
    private String senderUserNameReqParamName;
    @Value(value="${sms.sender.username}")
    private String senderUserName;
    @Value(value="${sms.sender.password.req.param.name}")
    private String senderPasswordReqParamName;
    @Value(value="${sms.sender.password}")
    private String senderPassword;
    @Value(value="${sms.destination.mobile.req.param.name}")
    private String mobileNumberReqParamName;
    @Value(value="${sms.message.req.param.name}")
    private String messageReqParamName;
    @Value(value="#{'${sms.extra.req.params}'.split('&')}")
    private List<String> extraRequestParams;
    @Value(value="#{'${sms.error.codes}'.split(',')}")
    private List<String> smsErrorCodes;

    public boolean sendSMS(String mobileNumber, String message) {
        return this.sendSMS(mobileNumber, message, MessagePriority.MEDIUM);
    }

    public boolean sendSMS(String mobileNumber, String message, MessagePriority priority) {
        if (this.smsEnabled) {
            try {
                CloseableHttpClient client = HttpClientBuilder.create().build();
                HttpPost post = new HttpPost(this.smsProviderURL);
                ArrayList<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.senderUserNameReqParamName, this.senderUserName));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.senderPasswordReqParamName, this.senderPassword));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.senderReqParamName, this.sender));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.mobileNumberReqParamName, GlobalSettings.countryCode() + mobileNumber));
                urlParameters.add((NameValuePair)new BasicNameValuePair(this.messageReqParamName, message));
                this.setAdditionalParameters(urlParameters, priority);
                post.setEntity((HttpEntity)new UrlEncodedFormEntity(urlParameters, GlobalSettings.encoding()));
                HttpResponse response = client.execute((HttpUriRequest)post);
                String responseCode = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)GlobalSettings.encoding());
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("SMS sending completed with response code [{}] - [{}]", (Object)responseCode, (Object)this.environment.getProperty(responseCode, "No Message"));
                }
                return this.smsErrorCodes.parallelStream().noneMatch(responseCode::startsWith);
            }
            catch (IOException | UnsupportedOperationException e) {
                LOGGER.error("Error occurred while sending SMS [%s]", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private void setAdditionalParameters(List<NameValuePair> urlParameters, MessagePriority priority) {
        if (!this.extraRequestParams.isEmpty()) {
            for (String extraParm : this.extraRequestParams) {
                String[] paramNameValue = extraParm.split("=");
                urlParameters.add((NameValuePair)new BasicNameValuePair(paramNameValue[0], paramNameValue[1]));
            }
        }
        if (this.smsPriorityEnabled) {
            urlParameters.add((NameValuePair)new BasicNameValuePair(this.smsPriorityParamName, this.environment.getProperty(String.format(SMS_PRIORITY_PARAM_VALUE, priority.toString()))));
        }
    }
}

