/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.filestore.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="localDiskFileStoreService")
public class LocalDiskFileStoreService
implements FileStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDiskFileStoreService.class);
    private String fileStoreBaseDir;

    @Autowired
    public LocalDiskFileStoreService(@Value(value="${filestore.base.dir}") String fileStoreBaseDir) {
        this.fileStoreBaseDir = fileStoreBaseDir.isEmpty() ? FileUtils.getUserDirectoryPath() + File.separator + "egovfilestore" : fileStoreBaseDir;
    }

    @Override
    public FileStoreMapper store(File sourceFile, String fileName, String mimeType, String moduleName) {
        return this.store(sourceFile, fileName, mimeType, moduleName, true);
    }

    @Override
    public FileStoreMapper store(InputStream sourceFileStream, String fileName, String mimeType, String moduleName) {
        return this.store(sourceFileStream, fileName, mimeType, moduleName, true);
    }

    @Override
    public FileStoreMapper store(File file, String fileName, String mimeType, String moduleName, boolean deleteFile) {
        try {
            FileStoreMapper fileMapper = new FileStoreMapper(UUID.randomUUID().toString(), StringUtils.defaultString((String)fileName, (String)file.getName()));
            Path newFilePath = this.createNewFilePath(fileMapper, moduleName);
            Files.copy(file.toPath(), newFilePath, new CopyOption[0]);
            fileMapper.setContentType(mimeType);
            if (deleteFile && file.delete()) {
                LOG.info("File store source file deleted");
            }
            return fileMapper;
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException(String.format("Error occurred while storing files at %s/%s/%s", this.fileStoreBaseDir, ApplicationThreadLocals.getCityCode(), moduleName), e);
        }
    }

    @Override
    public FileStoreMapper store(InputStream fileStream, String fileName, String mimeType, String moduleName, boolean closeStream) {
        try {
            FileStoreMapper fileMapper = new FileStoreMapper(UUID.randomUUID().toString(), fileName);
            Path newFilePath = this.createNewFilePath(fileMapper, moduleName);
            Files.copy(fileStream, newFilePath, new CopyOption[0]);
            fileMapper.setContentType(mimeType);
            if (closeStream) {
                fileStream.close();
            }
            return fileMapper;
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException(String.format("Error occurred while storing files at %s/%s/%s", this.fileStoreBaseDir, ApplicationThreadLocals.getCityCode(), moduleName), e);
        }
    }

    @Override
    public File fetch(FileStoreMapper fileMapper, String moduleName) {
        return this.fetch(fileMapper.getFileStoreId(), moduleName);
    }

    @Override
    public Set<File> fetchAll(Set<FileStoreMapper> fileMappers, String moduleName) {
        return fileMappers.stream().map(fileMapper -> this.fetch(fileMapper.getFileStoreId(), moduleName)).collect(Collectors.toSet());
    }

    @Override
    public File fetch(String fileStoreId, String moduleName) {
        Path fileDirPath = this.getFileDirectoryPath(moduleName);
        if (!fileDirPath.toFile().exists()) {
            throw new ApplicationRuntimeException(String.format("File Store does not exist at Path : %s/%s/%s", this.fileStoreBaseDir, ApplicationThreadLocals.getCityCode(), moduleName));
        }
        return this.getFilePath(fileDirPath, fileStoreId).toFile();
    }

    @Override
    public void delete(String fileStoreId, String moduleName) {
        Path fileDirPath = this.getFileDirectoryPath(moduleName);
        if (!fileDirPath.toFile().exists()) {
            Path filePath = this.getFilePath(fileDirPath, fileStoreId);
            try {
                Files.deleteIfExists(filePath);
            }
            catch (IOException e) {
                throw new ApplicationRuntimeException(String.format("Could not remove document %s", filePath.getFileName()), e);
            }
        }
    }

    private Path createNewFilePath(FileStoreMapper fileMapper, String moduleName) throws IOException {
        Path fileDirPath = this.getFileDirectoryPath(moduleName);
        if (!fileDirPath.toFile().exists()) {
            LOG.info("File Store Directory {}/{}/{} not found, creating one", new Object[]{this.fileStoreBaseDir, ApplicationThreadLocals.getCityCode(), moduleName});
            Files.createDirectories(fileDirPath, new FileAttribute[0]);
            LOG.info("Created File Store Directory {}/{}/{}", new Object[]{this.fileStoreBaseDir, ApplicationThreadLocals.getCityCode(), moduleName});
        }
        return this.getFilePath(fileDirPath, fileMapper.getFileStoreId());
    }

    private Path getFileDirectoryPath(String moduleName) {
        return Paths.get(this.fileStoreBaseDir + File.separator + ApplicationThreadLocals.getCityCode() + File.separator + moduleName, new String[0]);
    }

    private Path getFilePath(Path fileDirPath, String fileStoreId) {
        return Paths.get(fileDirPath + File.separator + fileStoreId, new String[0]);
    }
}

