/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.persistence.migration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

@Configuration
public class DBMigrationConfiguration {
    @Value(value="${dev.mode}")
    private boolean devMode;
    @Value(value="${db.migration.enabled}")
    private boolean dbMigrationEnabled;
    @Value(value="${db.flyway.validateon.migrate}")
    private boolean validateOnMigrate;
    @Value(value="${db.flyway.migration.repair}")
    private boolean repairMigration;
    @Value(value="${statewide.migration.required}")
    private boolean statewideMigrationRequired;
    @Value(value="${db.flyway.main.migration.file.path}")
    private String mainMigrationFilePath;
    @Value(value="${db.flyway.sample.migration.file.path}")
    private String sampleMigrationFilePath;
    @Value(value="${db.flyway.tenant.migration.file.path}")
    private String tenantMigrationFilePath;
    @Value(value="${db.flyway.statewide.migration.file.path}")
    private String statewideMigrationFilePath;
    @Value(value="${statewide.schema.name}")
    private String statewideSchemaName;
    @Autowired
    private ConfigurableEnvironment environment;

    @Bean
    @DependsOn(value={"dataSource"})
    public Flyway flyway(DataSource dataSource, @Qualifier(value="cities") List<String> cities) {
        if (this.dbMigrationEnabled) {
            cities.stream().forEach(schema -> {
                if (this.devMode) {
                    this.migrateDatabase(dataSource, (String)schema, this.mainMigrationFilePath, this.sampleMigrationFilePath, String.format(this.tenantMigrationFilePath, schema));
                } else {
                    this.migrateDatabase(dataSource, (String)schema, this.mainMigrationFilePath, String.format(this.tenantMigrationFilePath, schema));
                }
            });
            if (this.statewideMigrationRequired && !this.devMode) {
                this.migrateDatabase(dataSource, this.statewideSchemaName, this.mainMigrationFilePath, this.statewideMigrationFilePath);
            } else if (!this.devMode) {
                this.migrateDatabase(dataSource, this.statewideSchemaName, this.mainMigrationFilePath);
            }
        }
        return new Flyway();
    }

    private void migrateDatabase(DataSource dataSource, String schema, String ... locations) {
        Flyway flyway = new Flyway();
        flyway.setBaselineOnMigrate(true);
        flyway.setValidateOnMigrate(this.validateOnMigrate);
        flyway.setOutOfOrder(true);
        flyway.setLocations(locations);
        flyway.setDataSource(dataSource);
        flyway.setSchemas(new String[]{schema});
        if (this.repairMigration) {
            flyway.repair();
        }
        flyway.migrate();
    }

    @Bean(name={"tenants"}, autowire=Autowire.BY_NAME)
    public List<String> tenants() {
        ArrayList<String> tenants = new ArrayList<String>();
        this.environment.getPropertySources().iterator().forEachRemaining(propertySource -> {
            if (propertySource instanceof MapPropertySource) {
                ((Map)((MapPropertySource)propertySource).getSource()).forEach((key, value) -> {
                    if (key.startsWith("tenant.")) {
                        tenants.add(value.toString());
                    }
                });
            }
        });
        return tenants;
    }
}

