/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.config.cache;

import java.util.List;
import javax.annotation.Resource;
import org.egov.infra.config.cache.resolver.MultiTenantCacheResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
@EnableCaching(proxyTargetClass=true)
@DependsOn(value={"applicationConfiguration"})
public class CacheConfiguration
extends CachingConfigurerSupport {
    @Autowired
    private RedisTemplate redisTemplate;
    private List<String> cities;

    @Bean
    public CacheResolver cacheResolver() {
        return new MultiTenantCacheResolver(this.cacheManager());
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return (object, method, args) -> {
            StringBuilder sb = new StringBuilder();
            sb.append(object.getClass().getSimpleName());
            sb.append(method.getName());
            for (Object obj : args) {
                sb.append(obj);
            }
            return sb.toString();
        };
    }

    @Bean
    public CacheManager cacheManager() {
        RedisCacheManager redisCacheManager = new RedisCacheManager((RedisOperations)this.redisTemplate);
        redisCacheManager.setTransactionAware(true);
        redisCacheManager.setCacheNames(this.cities);
        redisCacheManager.setUsePrefix(true);
        redisCacheManager.setDefaultExpiration(3600L);
        return redisCacheManager;
    }

    @Resource(name="cities")
    public void setCities(List<String> cities) {
        this.cities = cities;
    }
}

