/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.validation.ValidationException;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.repository.BoundaryRepository;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.StringUtils;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BoundaryService {
    private static final Logger LOG = LoggerFactory.getLogger(BoundaryService.class);
    private static final String GIS_SHAPE_FILE_LOCATION = "gis/%s/wards.shp";
    private final BoundaryRepository boundaryRepository;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    @Autowired
    public BoundaryService(BoundaryRepository boundaryRepository) {
        this.boundaryRepository = boundaryRepository;
    }

    @Transactional
    public Boundary createBoundary(Boundary boundary) {
        boundary.setHistory(false);
        boundary.setMaterializedPath(this.getMaterializedPath(null, boundary.getParent()));
        return (Boundary)this.boundaryRepository.save(boundary);
    }

    @Transactional
    public void updateBoundary(Boundary boundary) {
        boundary.setHistory(false);
        boundary.setMaterializedPath(this.getMaterializedPath(boundary, boundary.getParent()));
        this.boundaryRepository.save(boundary);
    }

    public Boundary getBoundaryById(Long id) {
        return (Boundary)this.boundaryRepository.findOne(id);
    }

    public List<Boundary> getAllBoundariesOrderByBoundaryNumAsc(BoundaryType boundaryType) {
        return this.boundaryRepository.findByBoundaryTypeOrderByBoundaryNumAsc(boundaryType);
    }

    public List<Boundary> getAllBoundariesByBoundaryTypeId(Long boundaryTypeId) {
        return this.boundaryRepository.findBoundariesByBoundaryType(boundaryTypeId);
    }

    public List<Boundary> getPageOfBoundaries(Long boundaryTypeId) {
        return this.boundaryRepository.findBoundariesByBoundaryType(boundaryTypeId);
    }

    public Boundary getBoundaryByTypeAndNo(BoundaryType boundaryType, Long boundaryNum) {
        return this.boundaryRepository.findBoundarieByBoundaryTypeAndBoundaryNum(boundaryType, boundaryNum);
    }

    public List<Boundary> getParentBoundariesByBoundaryId(Long boundaryId) {
        List<Boundary> boundaryList = new ArrayList<Boundary>();
        Boundary bndry = this.getBoundaryById(boundaryId);
        if (bndry != null) {
            boundaryList.add(bndry);
            if (bndry.getParent() != null) {
                boundaryList = this.getParentBoundariesByBoundaryId(bndry.getParent().getId());
            }
        }
        return boundaryList;
    }

    public List<Boundary> getActiveBoundariesByBoundaryTypeId(Long boundaryTypeId) {
        return this.boundaryRepository.findActiveBoundariesByBoundaryTypeId(boundaryTypeId);
    }

    public List<Boundary> getTopLevelBoundaryByHierarchyType(HierarchyType hierarchyType) {
        return this.boundaryRepository.findActiveBoundariesByHierarchyTypeAndLevelAndAsOnDate(hierarchyType, 1L, new Date());
    }

    public List<Boundary> getActiveChildBoundariesByBoundaryId(Long boundaryId) {
        return this.boundaryRepository.findActiveChildBoundariesByBoundaryIdAndAsOnDate(boundaryId, new Date());
    }

    public List<Boundary> getChildBoundariesByBoundaryId(Long boundaryId) {
        return this.boundaryRepository.findChildBoundariesByBoundaryIdAndAsOnDate(boundaryId, new Date());
    }

    public Boundary getActiveBoundaryByBndryNumAndTypeAndHierarchyTypeCode(Long bndryNum, String boundaryType, String hierarchyTypeCode) {
        return this.boundaryRepository.findActiveBoundaryByBndryNumAndTypeAndHierarchyTypeCodeAndAsOnDate(bndryNum, boundaryType, hierarchyTypeCode, new Date());
    }

    public List<Boundary> getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(String boundaryTypeName, String hierarchyTypeName) {
        return this.boundaryRepository.findActiveBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName);
    }

    public List<Boundary> getBoundariesByBndryTypeNameAndHierarchyTypeName(String boundaryTypeName, String hierarchyTypeName) {
        return this.boundaryRepository.findBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName);
    }

    public Boundary getBoundaryByBndryTypeNameAndHierarchyTypeName(String boundaryTypeName, String hierarchyTypeName) {
        return this.boundaryRepository.findBoundaryByBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName);
    }

    public List<Boundary> getBondariesByNameAndTypeOrderByBoundaryNumAsc(String boundaryName, Long boundaryTypeId) {
        return this.boundaryRepository.findByNameAndBoundaryTypeOrderByBoundaryNumAsc(boundaryName, boundaryTypeId);
    }

    public Boolean validateBoundary(BoundaryType boundaryType) {
        return Optional.ofNullable(this.boundaryRepository.findByBoundaryTypeNameAndHierarchyTypeNameAndLevel(boundaryType.getName(), boundaryType.getHierarchyType().getName(), 1L)).isPresent();
    }

    public List<Boundary> getBondariesByNameAndBndryTypeAndHierarchyType(String boundaryTypeName, String hierarchyTypeName, String name) {
        return this.boundaryRepository.findActiveBoundariesByNameAndBndryTypeNameAndHierarchyTypeName(boundaryTypeName, hierarchyTypeName, name);
    }

    public List<Map<String, Object>> getBoundaryDataByNameLike(String name) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        this.crossHierarchyService.getChildBoundaryNameAndBndryTypeAndHierarchyType("Locality", "Location", "Administration", '%' + name + '%').stream().forEach(location -> {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("id", location.getId());
            res.put("name", location.getChild().getName() + " - " + location.getParent().getName());
            list.add(res);
        });
        return list;
    }

    public List<Boundary> findActiveChildrenWithParent(Long parentBoundaryId) {
        return this.boundaryRepository.findActiveChildrenWithParent(parentBoundaryId);
    }

    public List<Boundary> findActiveBoundariesForMpath(Set<String> mpath) {
        return this.boundaryRepository.findActiveBoundariesForMpath(mpath);
    }

    public String getMaterializedPath(Boundary child, Boundary parent) {
        String mpath = "";
        int childSize = 0;
        if (null == parent) {
            mpath = String.valueOf(this.boundaryRepository.findAllParents().size() + 1);
        } else {
            childSize = this.boundaryRepository.findActiveImmediateChildrenWithOutParent(parent.getId()).size();
        }
        if (mpath.isEmpty()) {
            if (null != child) {
                mpath = parent != null && !child.getMaterializedPath().equalsIgnoreCase(parent.getMaterializedPath() + "." + childSize) ? parent.getMaterializedPath() + "." + ++childSize : child.getMaterializedPath();
            } else if (parent != null) {
                mpath = parent.getMaterializedPath() + "." + ++childSize;
            }
        }
        return mpath;
    }

    public Boundary getBoundaryByGisCoordinates(Double latitude, Double longitude) {
        return this.getBoundary(latitude, longitude).orElseThrow(() -> new ValidationException("gis.location.info.not.found"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Boundary> getBoundary(Double latitude, Double longitude) {
        try {
            if (latitude == null) return Optional.empty();
            if (longitude == null) return Optional.empty();
            HashMap<String, URL> map = new HashMap<String, URL>();
            map.put("url", Thread.currentThread().getContextClassLoader().getResource(String.format(GIS_SHAPE_FILE_LOCATION, ApplicationThreadLocals.getTenantID())));
            DataStore dataStore = DataStoreFinder.getDataStore(map);
            FeatureCollection collection = dataStore.getFeatureSource(dataStore.getTypeNames()[0]).getFeatures();
            Iterator iterator = collection.iterator();
            Point point = JTSFactoryFinder.getGeometryFactory(null).createPoint(new Coordinate(longitude.doubleValue(), latitude.doubleValue()));
            try {
                SimpleFeature feature;
                Geometry geom;
                do {
                    if (!iterator.hasNext()) return Optional.empty();
                } while (!(geom = (Geometry)(feature = (SimpleFeature)iterator.next()).getDefaultGeometry()).contains((Geometry)point));
                Optional<Boundary> optional = this.getBoundaryByNumberAndType((Long)feature.getAttribute("bndrynum"), (String)feature.getAttribute("bndrytype"));
                return optional;
            }
            finally {
                collection.close(iterator);
            }
        }
        catch (Exception e) {
            LOG.error("Error occurred while fetching boundary from GIS data", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<Boundary> getBoundaryByNumberAndType(Long boundaryNum, String boundaryTypeName) {
        if (boundaryNum != null && StringUtils.isNotBlank((String)boundaryTypeName)) {
            BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(boundaryTypeName, "ADMINISTRATION");
            Boundary boundary = this.getBoundaryByTypeAndNo(boundaryType, boundaryNum);
            if (boundary == null) {
                BoundaryType cityBoundaryType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName("City", "ADMINISTRATION");
                return Optional.ofNullable(this.getAllBoundariesByBoundaryTypeId(cityBoundaryType.getId()).get(0));
            }
            return Optional.of(boundary);
        }
        return Optional.empty();
    }
}

