/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.annotations.Expose;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.infra.persistence.validator.annotation.DateFormat;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;
import org.springframework.format.annotation.DateTimeFormat;

@Entity
@CompositeUnique(fields={"boundaryNum", "boundaryType"}, enableDfltMsg=true)
@Table(name="EG_BOUNDARY")
@NamedQuery(name="Boundary.findBoundariesByBoundaryType", query="select b from Boundary b where b.boundaryType.id = :boundaryTypeId")
@SequenceGenerator(name="seq_eg_boundary", sequenceName="seq_eg_boundary", allocationSize=1)
public class Boundary
extends AbstractAuditable {
    public static final String SEQ_BOUNDARY = "seq_eg_boundary";
    private static final long serialVersionUID = 3054956514161912026L;
    @Expose
    @Id
    @GeneratedValue(generator="seq_eg_boundary", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(max=512)
    @SafeHtml
    @NotBlank
    private String name;
    private Long boundaryNum;
    @ManyToOne
    @JoinColumn(name="boundaryType", updatable=false)
    private BoundaryType boundaryType;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent")
    @Fetch(value=FetchMode.SELECT)
    private Boundary parent;
    @OneToMany(cascade={CascadeType.REMOVE})
    @JoinColumn(name="parent")
    @Fetch(value=FetchMode.SUBSELECT)
    @JsonIgnore
    private Set<Boundary> children = new HashSet<Boundary>();
    @DateFormat
    @DateTimeFormat(pattern="dd-MM-yyyy")
    private Date fromDate;
    private Date toDate;
    private boolean isHistory;
    private Long bndryId;
    @SafeHtml
    private String localName;
    private Float longitude;
    private Float latitude;
    @Length(max=32)
    private String materializedPath;
    @Transient
    private City city = new City();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String boundaryNameLocal) {
        this.localName = boundaryNameLocal;
    }

    public Boundary getParent() {
        return this.parent;
    }

    public void setParent(Boundary parent) {
        this.parent = parent;
    }

    public Set<Boundary> getChildren() {
        return this.children;
    }

    public void setChildren(Set<Boundary> boundaries) {
        this.children = boundaries;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public BoundaryType getBoundaryType() {
        return this.boundaryType;
    }

    public void setBoundaryType(BoundaryType boundaryType) {
        this.boundaryType = boundaryType;
    }

    public Long getBoundaryNum() {
        return this.boundaryNum;
    }

    public void setBoundaryNum(Long number) {
        this.boundaryNum = number;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public boolean isHistory() {
        return this.isHistory;
    }

    public void setHistory(boolean isHistory) {
        this.isHistory = isHistory;
    }

    public Long getBndryId() {
        return this.bndryId;
    }

    public void setBndryId(Long bndryId) {
        this.bndryId = bndryId;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public void setLongitude(Float longitude) {
        this.longitude = longitude;
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public void setLatitude(Float latitude) {
        this.latitude = latitude;
    }

    public String getMaterializedPath() {
        return this.materializedPath;
    }

    public void setMaterializedPath(String materializedPath) {
        this.materializedPath = materializedPath;
    }

    public City getCity() {
        return this.city;
    }

    public void setCity(City city) {
        this.city = city;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boundaryNum == null ? 0 : this.boundaryNum.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Boundary other = (Boundary)obj;
        if (this.boundaryNum == null ? other.boundaryNum != null : !this.boundaryNum.equals(other.boundaryNum)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }
}

