/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.admin.master.service;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.egov.builder.entities.DepartmentBuilder;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.repository.DepartmentRepository;
import org.egov.infra.admin.master.service.DepartmentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.springframework.data.domain.Sort;

public class DepartmentServiceTest {
    @Mock
    DepartmentRepository departmentRepository;
    DepartmentService departmentService;
    Department department;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.departmentService = new DepartmentService(this.departmentRepository);
        this.department = new DepartmentBuilder().withName("test").withCode("test").build();
    }

    @Test
    public void shouldCreateDepartment() {
        this.departmentService.createDepartment(this.department);
        ((DepartmentRepository)Mockito.verify((Object)this.departmentRepository)).save((Object)this.department);
    }

    @Test
    public void shouldGetDepartmentByName() {
        Mockito.when((Object)this.departmentService.getDepartmentByName(Matchers.anyString())).thenReturn((Object)this.department);
        Department expectedDepartment = this.departmentService.getDepartmentByName("test");
        ((DepartmentRepository)Mockito.verify((Object)this.departmentRepository)).findByNameUpperCase("test".toUpperCase());
        Assert.assertTrue((boolean)this.department.equals((Object)expectedDepartment));
    }

    @Test
    public void shouldGetDepartmentByCode() {
        Mockito.when((Object)this.departmentService.getDepartmentByCode(Matchers.anyString())).thenReturn((Object)this.department);
        Department expectedDepartment = this.departmentService.getDepartmentByCode("test");
        ((DepartmentRepository)Mockito.verify((Object)this.departmentRepository)).findByCode("test");
        Assert.assertTrue((boolean)this.department.equals((Object)expectedDepartment));
    }

    @Test
    public void shouldGetDepartmentById() {
        this.department.setId(Long.valueOf(1L));
        Mockito.when((Object)this.departmentService.getDepartmentById(Long.valueOf(Matchers.anyLong()))).thenReturn((Object)this.department);
        Department expectedDepartment = this.departmentService.getDepartmentById(Long.valueOf(1L));
        ((DepartmentRepository)Mockito.verify((Object)this.departmentRepository)).findOne((Serializable)Long.valueOf(1L));
        Assert.assertEquals((Object)expectedDepartment, (Object)this.department);
    }

    @Test
    public void shouldGetAllDepartments() {
        Department department1 = new DepartmentBuilder().withName("test1").withCode("test1").build();
        Department department2 = new DepartmentBuilder().withName("test2").withCode("test2").build();
        Mockito.when((Object)this.departmentService.getAllDepartments()).thenReturn(Arrays.asList(department1, department2));
        List list = this.departmentService.getAllDepartments();
        ((DepartmentRepository)Mockito.verify((Object)this.departmentRepository)).findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
        Assert.assertEquals((long)list.size(), (long)2L);
    }
}

