/*
 * Decompiled with CFR 0.152.
 */
package org.egov.builder.entities;

import org.egov.infra.admin.master.entity.Department;

public class DepartmentBuilder {
    private final Department department = new Department();
    private static long count;

    public DepartmentBuilder withName(String departmentName) {
        this.department.setName(departmentName);
        return this;
    }

    public DepartmentBuilder withCode(String code) {
        this.department.setCode(code);
        return this;
    }

    public DepartmentBuilder withDefaults() {
        this.withId(count);
        if (null == this.department.getName()) {
            this.withName("test-department-" + count);
        }
        if (null == this.department.getCode()) {
            this.withCode("test-" + count);
        }
        return this;
    }

    public DepartmentBuilder withId(Long id) {
        this.department.setId(id);
        return this;
    }

    public DepartmentBuilder withDbDefaults() {
        if (null == this.department.getName()) {
            this.withName("test-department-" + count);
        }
        if (null == this.department.getCode()) {
            this.withCode("test-" + count);
        }
        return this;
    }

    public Department build() {
        return this.department;
    }
}

