/*
 * Decompiled with CFR 0.152.
 */
package org.egov.builder.entities;

import java.util.Date;
import org.egov.builder.entities.BoundaryTypeBuilder;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;

public class BoundaryBuilder {
    private final Boundary boundary = new Boundary();
    private static long count;

    public BoundaryBuilder() {
        ++count;
    }

    public BoundaryBuilder withUpdatedTime(Date updatedTime) {
        this.boundary.setLastModifiedDate(updatedTime);
        return this;
    }

    public BoundaryBuilder withId(Long id) {
        this.boundary.setId(id);
        return this;
    }

    public BoundaryBuilder withBoundaryType(BoundaryType boundaryType) {
        this.boundary.setBoundaryType(boundaryType);
        return this;
    }

    public BoundaryBuilder withParent(Boundary parent) {
        this.boundary.setParent(parent);
        return this;
    }

    public BoundaryBuilder withName(String name) {
        this.boundary.setName(name);
        return this;
    }

    public BoundaryBuilder withBoundaryNum(Long boundaryNum) {
        this.boundary.setBoundaryNum(boundaryNum);
        return this;
    }

    public BoundaryBuilder withFromDate(Date fromDate) {
        this.boundary.setFromDate(fromDate);
        return this;
    }

    public BoundaryBuilder withToDate(Date toDate) {
        this.boundary.setToDate(toDate);
        return this;
    }

    public BoundaryBuilder withIsHistory(boolean isHistory) {
        this.boundary.setHistory(isHistory);
        return this;
    }

    public BoundaryBuilder withBndryId(Long bndryId) {
        this.boundary.setBndryId(bndryId);
        return this;
    }

    public BoundaryBuilder withBndryNameLocal(String bndryNameLocal) {
        this.boundary.setLocalName(bndryNameLocal);
        return this;
    }

    public BoundaryBuilder withLng(Float lng) {
        this.boundary.setLongitude(lng);
        return this;
    }

    public BoundaryBuilder withLat(Float lat) {
        this.boundary.setLatitude(lat);
        return this;
    }

    public BoundaryBuilder withMaterializedPath(String materializedPath) {
        this.boundary.setMaterializedPath(materializedPath);
        return this;
    }

    public BoundaryBuilder withDefaults() {
        this.withId(count);
        if (null == this.boundary.getLastModifiedDate()) {
            this.withUpdatedTime(new Date());
        }
        if (null == this.boundary.getBoundaryType()) {
            this.withBoundaryType(new BoundaryTypeBuilder().withDefaults().build());
        }
        if (null == this.boundary.getName()) {
            this.withName("test-boundary-" + count);
        }
        if (null == this.boundary.getBoundaryNum()) {
            this.withBoundaryNum(count);
        }
        if (null == this.boundary.getFromDate()) {
            this.withFromDate(new Date());
        }
        if (null == this.boundary.getToDate()) {
            this.withToDate(new Date());
        }
        if (this.boundary.isHistory()) {
            this.withIsHistory(false);
        }
        if (null == this.boundary.getBndryId()) {
            this.withBndryId(count);
        }
        if (null == this.boundary.getLocalName()) {
            this.withBndryNameLocal("test-local");
        }
        if (null == this.boundary.getLongitude()) {
            this.withLng(Float.valueOf(123232.0f));
        }
        if (null == this.boundary.getLatitude()) {
            this.withLat(Float.valueOf(1423423.0f));
        }
        if (null == this.boundary.getMaterializedPath()) {
            this.withMaterializedPath("1");
        }
        return this;
    }

    public BoundaryBuilder withDbDefaults() {
        if (null == this.boundary.getLastModifiedDate()) {
            this.withUpdatedTime(new Date());
        }
        if (null == this.boundary.getBoundaryType()) {
            this.withBoundaryType(new BoundaryTypeBuilder().withDbDefaults().build());
        }
        if (null == this.boundary.getName()) {
            this.withName("test-boundary-" + count);
        }
        if (null == this.boundary.getBoundaryNum()) {
            this.withBoundaryNum(count);
        }
        if (null == this.boundary.getFromDate()) {
            this.withFromDate(new Date());
        }
        if (null == this.boundary.getToDate()) {
            this.withToDate(new Date());
        }
        if (this.boundary.isHistory()) {
            this.withIsHistory(false);
        }
        if (null == this.boundary.getBndryId()) {
            this.withBndryId(count);
        }
        if (null == this.boundary.getLocalName()) {
            this.withBndryNameLocal("test-local");
        }
        if (null == this.boundary.getLongitude()) {
            this.withLng(Float.valueOf(123232.0f));
        }
        if (null == this.boundary.getLatitude()) {
            this.withLat(Float.valueOf(1423423.0f));
        }
        if (null == this.boundary.getMaterializedPath()) {
            this.withMaterializedPath("1");
        }
        return this;
    }

    public Boundary build() {
        return this.boundary;
    }
}

