/*
 * Decompiled with CFR 0.152.
 */
package org.egov.demand.utils;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.egov.collection.handler.BillCollectXmlHandler;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.models.BillPayeeDetails;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;

public class DemandUtils {
    public static final Logger LOGGER = Logger.getLogger(DemandUtils.class);

    public String generateBillXML(EgBill bill, String displayMsg) {
        String xmlData = "";
        BillCollectXmlHandler handler = new BillCollectXmlHandler();
        try {
            if (bill != null && displayMsg != null) {
                LOGGER.info((Object)(" before preparing Bill XML xmlData===" + xmlData));
                xmlData = handler.toXML((Object)this.prepareBillInfoXml(bill, displayMsg));
                LOGGER.info((Object)("xmlData===" + xmlData));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception in postBillCollectionDetails", (Throwable)ex);
        }
        return xmlData;
    }

    public BillInfoImpl prepareBillInfoXml(EgBill bill, String displayMsg) {
        ArrayList<BillPayeeDetails> billPayeeDetList = new ArrayList<BillPayeeDetails>();
        BillDetails billDetails = null;
        BillAccountDetails billAccDetails = null;
        ArrayList<String> collModesList = new ArrayList<String>();
        BillPayeeDetails billPayeeDet = null;
        BillInfoImpl billInfoImpl = null;
        try {
            if (bill != null) {
                if (bill.getCollModesNotAllowed() != null) {
                    String[] collModes = bill.getCollModesNotAllowed().split(",");
                    for (String coll : collModes) {
                        collModesList.add(coll);
                    }
                }
                billInfoImpl = new BillInfoImpl(bill.getServiceCode(), bill.getFundCode(), bill.getFunctionaryCode(), bill.getFundSourceCode(), bill.getDepartmentCode(), displayMsg, bill.getCitizenName(), bill.getPartPaymentAllowed(), bill.getOverrideAccountHeadsAllowed(), collModesList, BillInfo.COLLECTIONTYPE.F);
                billPayeeDet = new BillPayeeDetails(bill.getCitizenName(), bill.getCitizenAddress(), bill.getEmailId());
                billDetails = new BillDetails(bill.getId().toString(), bill.getCreateDate(), bill.getConsumerId(), bill.getConsumerType(), bill.getBoundaryNum().toString(), bill.getBoundaryType(), bill.getDescription(), bill.getTotalAmount(), bill.getMinAmtPayable());
                billPayeeDetList.add(billPayeeDet);
                billInfoImpl.setPayees(billPayeeDetList);
                billInfoImpl.setCallbackForApportioning(bill.getCallBackForApportion());
                boolean isActualDemand = false;
                for (EgBillDetails egBillDet : bill.getEgBillDetails()) {
                    isActualDemand = egBillDet.getAdditionalFlag() == 1;
                    billAccDetails = new BillAccountDetails(egBillDet.getGlcode(), egBillDet.getOrderNo(), egBillDet.getCrAmount(), egBillDet.getDrAmount(), egBillDet.getFunctionCode(), egBillDet.getDescription(), Boolean.valueOf(isActualDemand), egBillDet.getPurpose() != null ? BillAccountDetails.PURPOSE.valueOf((String)egBillDet.getPurpose()) : BillAccountDetails.PURPOSE.OTHERS);
                    billDetails.addBillAccountDetails(billAccDetails);
                }
                billPayeeDet.addBillDetails(billDetails);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception in prepareBillInfoXml method", (Throwable)ex);
        }
        return billInfoImpl;
    }
}

