/*
 * Decompiled with CFR 0.152.
 */
package org.egov.dashboard.web.controller;

import java.util.List;
import org.egov.infra.elasticsearch.entity.bean.ApplicationIndexRequest;
import org.egov.infra.elasticsearch.entity.bean.ApplicationIndexResponse;
import org.egov.infra.elasticsearch.entity.bean.ApplicationInfo;
import org.egov.infra.elasticsearch.service.es.ApplicationDocumentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/portal", "/portal"})
public class PortalDashboardController {
    @Autowired
    private ApplicationDocumentService applicationDocumentService;

    @RequestMapping(value={"/applicationdetails"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApplicationIndexResponse getApplicationDetails(ApplicationIndexRequest applicationIndexRequest) {
        return this.applicationDocumentService.findAllApplications(applicationIndexRequest);
    }

    @RequestMapping(value={"/serviceGroupWiseApplicationdetails"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApplicationIndexResponse getServiceGroupWiseApplicationDetails(ApplicationIndexRequest applicationIndexRequest) {
        return this.applicationDocumentService.findServiceGroupWiseApplications(applicationIndexRequest);
    }

    @RequestMapping(value={"/servicewisedetails"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApplicationIndexResponse getServiceWiseDetails(ApplicationIndexRequest applicationIndexRequest) {
        return this.applicationDocumentService.findServiceWiseDetails(applicationIndexRequest);
    }

    @RequestMapping(value={"/sourceWiseApplicationDetails"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApplicationIndexResponse getSourceWiseApplicationDetails(ApplicationIndexRequest applicationIndexRequest) {
        return this.applicationDocumentService.findSourceWiseApplicationDetails(applicationIndexRequest);
    }

    @RequestMapping(value={"/applications"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ApplicationInfo> getApplications(ApplicationIndexRequest applicationIndexRequest) {
        return this.applicationDocumentService.getApplicationInfo(applicationIndexRequest);
    }
}

