/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.entity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.OnlinePayment;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptDetailInfo;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.integration.pgi.DefaultPaymentResponse;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.Bank;
import org.egov.commons.Bankaccount;
import org.egov.commons.Bankbranch;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.Fundsource;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.entity.BankAccountServiceMap;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.entity.Location;
import org.egov.infra.admin.master.entity.User;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentAccountCodes;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentOtherDetails;
import org.egov.model.instrument.InstrumentType;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.hibernate.Session;

public class CollectionObjectFactory {
    private final Session session;
    private PersistenceService service;
    public static final String MODULE_NAME_TESTRECEIPTHEADER = "TestReceiptHeader";
    public static final String MODULE_NAME_TESTINSTRUMENTSTATUS = "TestInstrumentStatus";
    public static final String MODULE_NAME_TESTCHALLANHEADER = "TestChallanHeader";

    public CollectionObjectFactory() {
        this.session = null;
    }

    public CollectionObjectFactory(Session session) {
        this.session = session;
    }

    public CollectionObjectFactory(Session session, PersistenceService service) {
        this.session = session;
        this.service = service;
    }

    public int getRandomNumber() {
        Random ran = new Random();
        return ran.nextInt();
    }

    public int getRandomNumber(int max) {
        Random ran = new Random();
        return ran.nextInt(max);
    }

    public ServiceDetails createUnsavedServiceDetails() {
        ServiceDetails service = new ServiceDetails();
        String serviceName = "!testSrvc#" + this.getRandomNumber(9999);
        service.setName(serviceName);
        service.setServiceUrl("testServiceURL");
        service.setServiceType("B");
        service.setCode("testCode");
        service.setVoucherCreation(Boolean.TRUE);
        service.setIsVoucherApproved(Boolean.TRUE);
        service.addBankAccountServiceMap(this.createBankAccountServiceMap(service));
        return service;
    }

    public BankAccountServiceMap createBankAccountServiceMap(ServiceDetails serviceDetails) {
        BankAccountServiceMap bankServ = new BankAccountServiceMap();
        bankServ.setServiceDetails(serviceDetails);
        bankServ.setBankAccountId(this.createBankAccount("$" + serviceDetails.getCode() + "%"));
        bankServ.setDeptId(this.createDept("testDeptName", "testDeptCode"));
        bankServ.setLastModifiedBy(this.createUser("egovernments"));
        bankServ.setLastModifiedDate(new Date());
        bankServ.setCreatedBy(this.createUser("egovernments"));
        bankServ.setCreatedDate(new Date());
        return bankServ;
    }

    public Bankaccount createBankAccount(String glCode) {
        Bankaccount bankaccount = new Bankaccount();
        bankaccount.setAccountnumber("123456789");
        bankaccount.setAccounttype("NATIONALISED BANKS");
        bankaccount.setIsactive(Boolean.valueOf(true));
        bankaccount.setFund(this.createFund("testFund"));
        bankaccount.setChartofaccounts(this.createCOA(this.getRandomNumber(99999999) + ""));
        bankaccount.setBankbranch(this.createBankBranch());
        this.session.saveOrUpdate((Object)bankaccount);
        return bankaccount;
    }

    public Bankbranch createBankBranch() {
        Bankbranch bankbranch = new Bankbranch();
        bankbranch.setBranchcode("10101");
        bankbranch.setBranchname("test  branch");
        bankbranch.setBranchaddress1("test branch address");
        bankbranch.setBranchcity("branch city");
        bankbranch.setIsactive(Boolean.valueOf(true));
        bankbranch.setBank(this.createBank());
        bankbranch.setCreated(new Date());
        bankbranch.setModifiedby(BigDecimal.valueOf(this.createUser("egovernments").getId()));
        bankbranch.setLastmodified(new Date());
        this.session.saveOrUpdate((Object)bankbranch);
        return bankbranch;
    }

    public Bank createBank() {
        Bank bank = new Bank();
        bank.setCode("TEST" + this.getRandomNumber());
        bank.setName("Test Bank" + this.getRandomNumber());
        bank.setIsactive(Boolean.valueOf(true));
        bank.setCreated(new Date());
        bank.setLastmodified(new Date());
        bank.setModifiedby(BigDecimal.valueOf(this.createUser("egovernments").getId()));
        this.session.saveOrUpdate((Object)bank);
        return bank;
    }

    public ServiceDetails createServiceDetails() throws NumberFormatException {
        ServiceDetails service = this.createUnsavedServiceDetails();
        this.session.saveOrUpdate((Object)service);
        return service;
    }

    public ServiceDetails createServiceDetails(String code) {
        ServiceDetails service = new ServiceDetails();
        service.setName("testServiceName");
        service.setServiceUrl("testServiceURL");
        service.setServiceType("B");
        service.setCode(code);
        service.addBankAccountServiceMap(this.createBankAccountServiceMap(service));
        this.session.saveOrUpdate((Object)service);
        return service;
    }

    public ReceiptHeader createReceiptHeader(String receiptnumber) throws NumberFormatException {
        return this.createReceiptHeader(receiptnumber, 'B', "123456", "testCode", this.createUser("egovernments"), null);
    }

    public ReceiptHeader createUnsavedReceiptHeader(String receiptnumber, char receiptType, String refNum, String statusCode, User user, EgwStatus status) throws NumberFormatException {
        ReceiptHeader receiptHeader = new ReceiptHeader();
        receiptHeader.setReceipttype(receiptType);
        if (receiptnumber != null) {
            receiptHeader.setReceiptnumber(receiptnumber + this.getRandomNumber());
        }
        receiptHeader.setReferencenumber(refNum);
        receiptHeader.setConsumerCode("10-10-111-20");
        receiptHeader.setService(this.createServiceDetails());
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setLastModifiedDate(new Date());
        receiptHeader.setCreatedBy(user);
        receiptHeader.setLastModifiedBy(user);
        receiptHeader.setIsReconciled(Boolean.valueOf(false));
        receiptHeader.setManualreceiptnumber("292929");
        if (status == null) {
            receiptHeader.setStatus(this.createEgwStatus(statusCode, "ReceiptHeader"));
        } else {
            receiptHeader.setStatus(status);
        }
        receiptHeader.setPaidBy("Test Payee");
        receiptHeader.setReceiptMisc(this.createUnSavedReceiptMisc(receiptHeader));
        receiptHeader.addReceiptDetail(this.createUnsavedReceiptDetail(this.createCOA("1100201"), BigDecimal.valueOf(100.0), BigDecimal.ZERO, this.createFunction("Test Function"), 1L, "testGLCodeDescription", receiptHeader, true));
        return receiptHeader;
    }

    public ReceiptHeader createReceiptHeader(String receiptnumber, char receiptType, String refNum, String statusCode, User user, EgwStatus status) throws NumberFormatException {
        ReceiptHeader receiptHeader = this.createUnsavedReceiptHeader(receiptnumber, receiptType, refNum, statusCode, user, status);
        this.session.saveOrUpdate((Object)receiptHeader);
        return receiptHeader;
    }

    private Position createUnsavedPosition() {
        Position pos = new Position();
        pos.setName("TestPos");
        return pos;
    }

    public Position createPosition() {
        Position pos = this.createUnsavedPosition();
        this.session.saveOrUpdate((Object)pos);
        return pos;
    }

    public ReceiptHeader createReceiptHeaderWithInstrument(String receiptNum, char receiptType, String statusCode, String refNum, InstrumentType instrumentType, String instrumentNum, Double instrumentAmount, Date instrumentDate, String instrumentStatusCode, String glCode, String functionName, String userName) throws NumberFormatException {
        return this.createReceiptHeaderWithInstrument(receiptNum, receiptType, statusCode, refNum, instrumentType, instrumentNum, instrumentAmount, instrumentDate, instrumentStatusCode, glCode, functionName, userName, "testCounter");
    }

    public ReceiptHeader createReceiptHeaderWithInstrument(String receiptNum, char receiptType, String statusCode, String refNum, InstrumentType instrumentType, String instrumentNum, Double instrumentAmount, Date instrumentDate, String instrumentStatusCode, String glCode, String functionName, String userName, String counterName) throws NumberFormatException {
        User user = this.createUser(userName);
        Location counter = this.createCounter(counterName);
        return this.createReceiptHeaderWithInstrument(receiptNum, receiptType, statusCode, refNum, instrumentType, instrumentNum, instrumentAmount, instrumentDate, instrumentStatusCode, glCode, functionName, user, counter);
    }

    public ReceiptHeader createReceiptHeaderWithInstrument(String receiptNum, char receiptType, String statusCode, String refNum, InstrumentType instrumentType, String instrumentNum, Double instrumentAmount, Date instrumentDate, String instrumentStatusCode, String glCode, String functionName, User user, Location counter) throws NumberFormatException {
        PersonalInformation emp = this.createPersonalInformation(user, this.createDept("testDepartment"));
        CChartOfAccounts coaObj = this.createCOA(glCode);
        CFunction functionObj = this.createFunction(functionName);
        ReceiptHeader receiptHeader = this.createUnsavedReceiptHeader(receiptNum, receiptType, refNum, statusCode, user, null);
        receiptHeader.setReceiptMisc(this.createUnSavedReceiptMisc(receiptHeader));
        receiptHeader.addInstrument(this.createInstrumentHeader(instrumentType, instrumentNum, instrumentAmount, instrumentDate, instrumentStatusCode, user));
        receiptHeader.setLocation(counter);
        ReceiptVoucher receiptVoucher = new ReceiptVoucher();
        receiptVoucher.setReceiptHeader(receiptHeader);
        receiptHeader.addReceiptVoucher(receiptVoucher);
        this.session.saveOrUpdate((Object)receiptHeader);
        return receiptHeader;
    }

    public ReceiptHeader createUnsavedReceiptHeader() throws NumberFormatException {
        ReceiptHeader receiptHeader = new ReceiptHeader();
        receiptHeader.setReceipttype('A');
        receiptHeader.setService(this.createServiceDetails());
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setIsReconciled(Boolean.valueOf(false));
        receiptHeader.setStatus(this.createEgwStatus(("testCodeRH" + this.getRandomNumber()).substring(0, 10), MODULE_NAME_TESTRECEIPTHEADER));
        receiptHeader.setReceiptnumber("testReceiptNumber" + this.getRandomNumber());
        receiptHeader.setPaidBy("Test Payee");
        receiptHeader.setOverrideAccountHeads(Boolean.valueOf(true));
        receiptHeader.setPartPaymentAllowed(Boolean.valueOf(true));
        receiptHeader.setCallbackForApportioning(Boolean.valueOf(false));
        receiptHeader.setConsumerCode("testConsumerCode");
        receiptHeader.setReceiptMisc(this.createUnSavedReceiptMisc(receiptHeader));
        receiptHeader.addReceiptDetail(this.createUnsavedReceiptDetail(this.createCOA("1100201"), BigDecimal.valueOf(100.0), BigDecimal.ZERO, this.createFunction("Test Function"), 1L, "testGLCodeDescription", receiptHeader, true));
        return receiptHeader;
    }

    public ReceiptHeader createUnsavedPendingReceiptHeader() throws NumberFormatException {
        ReceiptHeader receiptHeader = new ReceiptHeader();
        receiptHeader.setReceipttype('A');
        receiptHeader.setService(this.createServiceDetails());
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setIsReconciled(Boolean.valueOf(false));
        receiptHeader.setStatus(this.createEgwStatus(("testCodeRH" + this.getRandomNumber()).substring(0, 10), MODULE_NAME_TESTRECEIPTHEADER));
        receiptHeader.setPaidBy("Test Payee");
        receiptHeader.setOverrideAccountHeads(Boolean.valueOf(true));
        receiptHeader.setPartPaymentAllowed(Boolean.valueOf(true));
        receiptHeader.setConsumerCode("testConsumerCode");
        receiptHeader.setReceiptMisc(this.createUnSavedReceiptMisc(receiptHeader));
        receiptHeader.addReceiptDetail(this.createUnsavedReceiptDetail(this.createCOA("1100201"), BigDecimal.valueOf(100.0), BigDecimal.ZERO, this.createFunction("Test Function"), 1L, "testGLCodeDescription", receiptHeader, true));
        return receiptHeader;
    }

    public CFunction createFunction(String name) {
        CFunction function = new CFunction();
        function.setName(name);
        function.setCode(name + this.getRandomNumber());
        function.setIsActive(Boolean.valueOf(true));
        function.setIsNotLeaf(Boolean.valueOf(false));
        function.setType(name);
        this.session.saveOrUpdate((Object)function);
        return function;
    }

    public CFunction createFunction(String name, String code) {
        CFunction function = new CFunction();
        function.setName(name);
        function.setCode(code);
        function.setIsActive(Boolean.valueOf(true));
        function.setIsNotLeaf(Boolean.valueOf(false));
        function.setType(name);
        this.session.saveOrUpdate((Object)function);
        return function;
    }

    public CChartOfAccounts createCOA(String glCode) {
        CChartOfAccounts account = new CChartOfAccounts();
        User user = this.createUser("testUser");
        Date date = new Date();
        account.setGlcode(glCode + this.getRandomNumber(9999));
        account.setName("testAccountName" + glCode);
        account.setIsActiveForPosting(Boolean.valueOf(true));
        account.setCreatedBy(user);
        account.setModifiedBy(user);
        account.setCreatedDate(date);
        account.setModifiedDate(date);
        account.setType(Character.valueOf('I'));
        this.session.saveOrUpdate((Object)account);
        return account;
    }

    public EgwStatus createUnsavedEgwStatus(String code, String moduleType) {
        EgwStatus status = new EgwStatus();
        status.setModuletype(moduleType);
        status.setLastmodifieddate(new Date());
        status.setCode(code);
        status.setDescription(code);
        return status;
    }

    public EgwStatus createEgwStatus(String code, String moduleType) {
        EgwStatus status = this.createUnsavedEgwStatus(code, moduleType);
        this.session.saveOrUpdate((Object)status);
        return status;
    }

    public Location createCounter(String counterName) {
        Location counter = new Location();
        counter.setActive(true);
        counter.setName(counterName);
        counter.setDescription("testCounterDesc");
        this.session.saveOrUpdate((Object)counter);
        return counter;
    }

    public User createUser(String userName) {
        User user = new User();
        user.setName(userName + this.getRandomNumber());
        user.setPassword("testpassword");
        user.setActive(true);
        this.session.saveOrUpdate((Object)user);
        return user;
    }

    public InstrumentType createUnsavedInstrumentType(String type) {
        InstrumentType instrType = new InstrumentType();
        User user = this.createUser("egovernments");
        Date date = new Date();
        instrType.setType(type + this.getRandomNumber());
        instrType.setCreatedBy(user);
        instrType.setCreatedDate(date);
        instrType.setModifiedBy(user);
        instrType.setModifiedDate(date);
        return instrType;
    }

    public InstrumentType createInstrumentType(String type) {
        InstrumentType instrType = this.createUnsavedInstrumentType(type);
        this.session.saveOrUpdate((Object)instrType);
        return instrType;
    }

    public InstrumentType createUnsavedRegularInstrumentType(String type) {
        InstrumentType instrType = new InstrumentType();
        User user = this.createUser("egovernments");
        Date date = new Date();
        instrType.setType(type);
        instrType.setCreatedBy(user);
        instrType.setCreatedDate(date);
        instrType.setModifiedBy(user);
        instrType.setModifiedDate(date);
        return instrType;
    }

    public InstrumentType createRegularInstrumentType(String type) {
        InstrumentType instrType = this.createUnsavedRegularInstrumentType(type);
        this.session.saveOrUpdate((Object)instrType);
        return instrType;
    }

    public InstrumentHeader createUnsavedInstrumentHeader(InstrumentType instrumentType, EgwStatus status) {
        InstrumentHeader instrHdr = new InstrumentHeader();
        instrHdr.setInstrumentAmount(BigDecimal.valueOf(1000L));
        instrHdr.setStatusId(status);
        instrHdr.setInstrumentType(instrumentType);
        User user = this.createUser("testUser");
        instrHdr.setCreatedBy(user);
        instrHdr.setCreatedDate(new Date());
        instrHdr.setCreatedDate(new Date());
        instrHdr.setModifiedBy(user);
        instrHdr.setModifiedDate(new Date());
        return instrHdr;
    }

    public InstrumentHeader createUnsavedInstrumentHeader(String instrumentType, String status) {
        InstrumentHeader instrHdr = new InstrumentHeader();
        instrHdr.setInstrumentAmount(BigDecimal.valueOf(1000L));
        instrHdr.setStatusId(this.createEgwStatus(status, "ReceiptHeader"));
        instrHdr.setInstrumentType(this.createUnsavedInstrumentType(instrumentType));
        User user = this.createUser("testUser");
        instrHdr.setCreatedBy(user);
        instrHdr.setCreatedDate(new Date());
        instrHdr.setCreatedDate(new Date());
        instrHdr.setModifiedBy(user);
        instrHdr.setModifiedDate(new Date());
        return instrHdr;
    }

    public InstrumentHeader createInstrumentHeader(InstrumentType instrumentType, EgwStatus status) {
        InstrumentHeader instrHdr = new InstrumentHeader();
        instrHdr.setInstrumentAmount(BigDecimal.valueOf(1000L));
        instrHdr.setStatusId(status);
        instrHdr.setInstrumentType(instrumentType);
        User user = this.createUser("testUser");
        instrHdr.setCreatedBy(user);
        instrHdr.setCreatedDate(new Date());
        instrHdr.setCreatedDate(new Date());
        instrHdr.setModifiedBy(user);
        instrHdr.setModifiedDate(new Date());
        this.session.saveOrUpdate((Object)instrHdr);
        return instrHdr;
    }

    public InstrumentHeader createBankInstrumentHeader() throws NumberFormatException {
        InstrumentHeader instrHdr = new InstrumentHeader();
        instrHdr.setInstrumentAmount(BigDecimal.valueOf(1000L));
        instrHdr.setStatusId(this.createEgwStatus("testStatus", MODULE_NAME_TESTRECEIPTHEADER));
        instrHdr.setInstrumentType((InstrumentType)this.service.find("from InstrumentType where type=?", new Object[]{"bankchallan"}));
        instrHdr.setBankAccountId(this.createBankAccount("testGLCode"));
        instrHdr.setBankId(instrHdr.getBankAccountId().getBankbranch().getBank());
        instrHdr.setBankBranchName(instrHdr.getBankAccountId().getBankbranch().getBranchname());
        instrHdr.setTransactionNumber("123456");
        instrHdr.setIsPayCheque("0");
        instrHdr.setTransactionDate(new Date());
        User user = this.createUser("testUser");
        instrHdr.setCreatedBy(user);
        instrHdr.setCreatedDate(new Date());
        instrHdr.setCreatedDate(new Date());
        instrHdr.setModifiedBy(user);
        instrHdr.setModifiedDate(new Date());
        this.session.saveOrUpdate((Object)instrHdr);
        return instrHdr;
    }

    public InstrumentHeader createUnsavedInstrumentHeader(InstrumentType instrumentType, String instrumentNum, Double instrumentAmount, Date instrumentDate, String statusCode, User user) {
        InstrumentHeader instrHdr = new InstrumentHeader();
        instrHdr.setInstrumentNumber(instrumentNum);
        instrHdr.setInstrumentType(instrumentType);
        instrHdr.setInstrumentAmount(BigDecimal.valueOf(instrumentAmount));
        instrHdr.setInstrumentDate(instrumentDate);
        instrHdr.setStatusId(this.createEgwStatus(statusCode, "ReceiptHeader"));
        instrHdr.setCreatedDate(new Date());
        instrHdr.setModifiedDate(new Date());
        instrHdr.setCreatedBy(user);
        instrHdr.setModifiedBy(user);
        return instrHdr;
    }

    public InstrumentHeader createInstrumentHeaderWithBankDetails(InstrumentType instrumentType, String instrumentNum, Double instrumentAmount, Date instrumentDate, EgwStatus status, Bank bank, String branchName, String isPayCheck) {
        InstrumentHeader instrHdr = this.createUnsavedInstrumentHeaderWithBankDetails(instrumentType, instrumentNum, instrumentAmount, instrumentDate, status, bank, branchName, isPayCheck);
        this.session.saveOrUpdate((Object)instrHdr);
        return instrHdr;
    }

    public InstrumentHeader createUnsavedInstrumentHeaderWithBankDetails(InstrumentType instrumentType, String instrumentNum, Double instrumentAmount, Date instrumentDate, EgwStatus status, Bank bank, String branchName, String isPayCheck) {
        InstrumentHeader instrHdr = new InstrumentHeader();
        instrHdr.setInstrumentNumber(instrumentNum);
        instrHdr.setInstrumentType(instrumentType);
        instrHdr.setInstrumentAmount(BigDecimal.valueOf(instrumentAmount));
        instrHdr.setStatusId(status);
        instrHdr.setBankId(bank);
        instrHdr.setBankBranchName(branchName);
        instrHdr.setIsPayCheque(isPayCheck);
        instrHdr.setInstrumentDate(instrumentDate);
        User user = this.createUser("testUserInstrumentHdr");
        instrHdr.setCreatedBy(user);
        instrHdr.setModifiedBy(user);
        instrHdr.setCreatedDate(new Date());
        instrHdr.setModifiedDate(new Date());
        return instrHdr;
    }

    public InstrumentHeader createInstrumentHeader(InstrumentType instrumentType, String instrumentNum, Double instrumentAmount, Date instrumentDate, String statusCode, User user) {
        InstrumentHeader instrumentHeader = this.createUnsavedInstrumentHeader(instrumentType, instrumentNum, instrumentAmount, instrumentDate, statusCode, user);
        this.session.saveOrUpdate((Object)instrumentHeader);
        return instrumentHeader;
    }

    public CFinancialYear getFinancialYearForDate(Date date) {
        Date endingDate;
        Calendar end;
        Date startingDate;
        Calendar start;
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        CFinancialYear financialYear = new CFinancialYear();
        if (now.get(2) > 3) {
            start = (Calendar)now.clone();
            start.set(now.get(1), 3, 1);
            startingDate = start.getTime();
            end = (Calendar)now.clone();
            end.set(now.get(1) + 1, 2, 31);
            endingDate = end.getTime();
        } else {
            start = (Calendar)now.clone();
            start.set(now.get(1) - 1, 3, 1);
            startingDate = start.getTime();
            end = (Calendar)now.clone();
            end.set(now.get(1), 2, 31);
            endingDate = end.getTime();
        }
        String finYrRange = start.get(1) + "_" + String.valueOf(end.get(1)).substring(2);
        financialYear.setStartingDate(startingDate);
        financialYear.setEndingDate(endingDate);
        financialYear.setFinYearRange(finYrRange);
        this.session.saveOrUpdate((Object)financialYear);
        return financialYear;
    }

    public CVoucherHeader createVoucher(String name) {
        CVoucherHeader voucher = new CVoucherHeader();
        voucher.setName("testVoucher" + name);
        voucher.setType("testType");
        voucher.setEffectiveDate(new Date());
        voucher.setVoucherDate(new Date());
        voucher.setFiscalPeriodId(Integer.valueOf(1));
        voucher.setVoucherNumber("testVoucherNumber");
        voucher.setCgvn("testCGVN" + name);
        this.session.saveOrUpdate((Object)voucher);
        return voucher;
    }

    public ReceiptVoucher createReceiptVoucher() throws NumberFormatException {
        ReceiptVoucher receiptVoucher = new ReceiptVoucher();
        ReceiptHeader receiptHeader = this.createReceiptHeader("testReceiptNumber");
        CVoucherHeader voucherHeader = this.createVoucher("testVoucher");
        receiptVoucher.setReceiptHeader(receiptHeader);
        receiptVoucher.setVoucherheader(voucherHeader);
        this.session.saveOrUpdate((Object)receiptVoucher);
        return receiptVoucher;
    }

    public ReceiptVoucher createReceiptVoucher(CVoucherHeader voucherHeader) throws NumberFormatException {
        ReceiptVoucher receiptVoucher = new ReceiptVoucher();
        ReceiptHeader receiptHeader1 = this.createUnsavedReceiptHeader();
        receiptHeader1.setReceiptnumber("testReceiptnumber1" + this.getRandomNumber());
        receiptVoucher.setReceiptHeader(receiptHeader1);
        receiptVoucher.setVoucherheader(voucherHeader);
        this.session.saveOrUpdate((Object)receiptVoucher);
        return receiptVoucher;
    }

    public ReceiptDetail createReceiptDetail() throws NumberFormatException {
        return this.createReceiptDetail(this.createCOA("1100201"), BigDecimal.valueOf(100.0), BigDecimal.valueOf(100.0), this.createFunction("Test Function"), 1L, "testGLDescription", this.createReceiptHeader("11111"));
    }

    public ReceiptDetail createUnsavedReceiptDetail(CChartOfAccounts coa, BigDecimal crAmt, BigDecimal drAmt, CFunction function, long orderNum, String description, ReceiptHeader receiptHeader, Boolean isActualDemand) {
        ReceiptDetail receiptDetail = new ReceiptDetail();
        receiptDetail.setAccounthead(coa);
        receiptDetail.setCramount(crAmt);
        receiptDetail.setDramount(drAmt);
        receiptDetail.setFunction(function);
        receiptDetail.setOrdernumber(Long.valueOf(orderNum));
        receiptDetail.setDescription(description);
        receiptDetail.setReceiptHeader(receiptHeader);
        receiptDetail.setIsActualDemand(isActualDemand);
        receiptDetail.setCramountToBePaid(crAmt);
        return receiptDetail;
    }

    public ReceiptDetail createReceiptDetail(CChartOfAccounts coa, BigDecimal crAmt, BigDecimal drAmt, CFunction function, long orderNum, String description, ReceiptHeader receiptHeader) {
        ReceiptDetail receiptDetail = this.createUnsavedReceiptDetail(coa, crAmt, drAmt, function, orderNum, description, receiptHeader, true);
        this.session.saveOrUpdate((Object)receiptDetail);
        return receiptDetail;
    }

    public ReceiptMisc createUnSavedReceiptMisc(ReceiptHeader receiptHeader) {
        ReceiptMisc receiptMisc = new ReceiptMisc();
        Fund fund = this.createFund("testFund");
        Scheme scheme = this.createScheme("123", "testscheme", fund);
        receiptMisc.setBoundary(this.createBoundary());
        receiptMisc.setDepartment(this.createDept("testDeptName", "testDeptCode"));
        receiptMisc.setFund(fund);
        receiptMisc.setFundsource(this.createFundsource("testFSName", "testFSCode"));
        receiptMisc.setScheme(scheme);
        receiptMisc.setSubscheme(this.createSubScheme(scheme));
        receiptMisc.setReceiptHeader(receiptHeader);
        return receiptMisc;
    }

    public ReceiptMisc createReceiptMis() throws NumberFormatException {
        ReceiptMisc receiptMisc = new ReceiptMisc();
        Fund fund = this.createFund("001");
        Scheme scheme = this.createScheme("234", "testscheme1", fund);
        receiptMisc.setBoundary(this.createBoundary());
        receiptMisc.setDepartment(this.createDept("testDeptName", "testDeptCode"));
        receiptMisc.setFund(fund);
        receiptMisc.setFundsource(this.createFundsource("testFSName", "testFSCode"));
        receiptMisc.setScheme(scheme);
        receiptMisc.setSubscheme(this.createSubScheme(scheme));
        receiptMisc.setReceiptHeader(this.createReceiptHeader("11111"));
        receiptMisc.setIdFunctionary(this.createFunctionary());
        this.session.saveOrUpdate((Object)receiptMisc);
        return receiptMisc;
    }

    public Functionary createFunctionary() {
        Functionary functionary = new Functionary();
        functionary.setCode(BigDecimal.valueOf(10102L));
        functionary.setCreatetimestamp(new Date());
        functionary.setIsactive(Boolean.valueOf(true));
        functionary.setName("Test Functionary");
        functionary.setUpdatetimestamp(new Date());
        return functionary;
    }

    public Fundsource createFundsource(String name, String code) {
        Fundsource newFundsource = new Fundsource();
        Date date = new Date();
        newFundsource.setCode(code + this.getRandomNumber());
        newFundsource.setName(name + this.getRandomNumber());
        newFundsource.setLlevel(BigDecimal.valueOf(0L));
        newFundsource.setIsactive(Boolean.valueOf(true));
        newFundsource.setCreatedDate(date);
        newFundsource.setLastModifiedDate(date);
        newFundsource.setIsnotleaf(Boolean.valueOf(true));
        this.session.saveOrUpdate((Object)newFundsource);
        return newFundsource;
    }

    public Boundary createBoundary() {
        Boundary boundaryImpl = new Boundary();
        boundaryImpl.setBoundaryNum(Long.valueOf(123232L));
        boundaryImpl.setName("Bangalore");
        boundaryImpl.setBoundaryType(this.createBoundaryType());
        boundaryImpl.setHistory(false);
        this.session.saveOrUpdate((Object)boundaryImpl);
        return boundaryImpl;
    }

    public BoundaryType createBoundaryType() {
        BoundaryType boundaryTypeImpl = new BoundaryType();
        boundaryTypeImpl.setHierarchy(Long.valueOf(1L));
        boundaryTypeImpl.setName("karnataka");
        boundaryTypeImpl.setLastModifiedDate(new Date());
        this.session.saveOrUpdate((Object)boundaryTypeImpl);
        return boundaryTypeImpl;
    }

    public HierarchyType createHierarchy(String name, String code) {
        HierarchyType hierarchyType = new HierarchyType();
        hierarchyType.setName(name + this.getRandomNumber());
        hierarchyType.setCode(code + this.getRandomNumber());
        this.session.saveOrUpdate((Object)hierarchyType);
        return hierarchyType;
    }

    public Department createDept(String deptName, String deptCode) {
        Department empDept = new Department();
        empDept.setName(deptName + this.getRandomNumber());
        empDept.setLastModifiedDate(new Date());
        empDept.setCode(deptCode + this.getRandomNumber());
        this.session.saveOrUpdate((Object)empDept);
        return empDept;
    }

    public Department createDeptForCode(String deptCode) {
        Department empDept = new Department();
        empDept.setName(deptCode);
        empDept.setCode(deptCode);
        empDept.setLastModifiedDate(new Date());
        this.session.saveOrUpdate((Object)empDept);
        return empDept;
    }

    public Fund createFund(String code) {
        Fund fund = new Fund();
        fund.setIdentifier(Character.valueOf('O'));
        fund.setName(code);
        fund.setCode(code + this.getRandomNumber());
        fund.setLlevel(BigDecimal.valueOf(0L));
        fund.setIsactive(Boolean.valueOf(true));
        fund.setCreatedDate(new Date());
        this.session.saveOrUpdate((Object)fund);
        return fund;
    }

    public InstrumentType createInstrumentTypeWithAccountCode() {
        InstrumentType instrType = this.createUnsavedInstrumentType("testInstrumentType" + this.getRandomNumber());
        User user = this.createUser("egovernments");
        Date date = new Date();
        InstrumentAccountCodes instrAccountCode = new InstrumentAccountCodes();
        instrAccountCode.setCreatedBy(user);
        instrAccountCode.setCreatedDate(date);
        instrAccountCode.setModifiedBy(user);
        instrAccountCode.setModifiedDate(date);
        instrAccountCode.setInstrumentType(instrType);
        instrType.getInstrumentAccountCodes().add(instrAccountCode);
        this.session.saveOrUpdate((Object)instrType);
        return instrType;
    }

    public InstrumentAccountCodes createInstrumentAccountCodesForInstrType(String instrType) {
        InstrumentAccountCodes instrAccountCode = new InstrumentAccountCodes();
        User user = this.createUser("egovernments");
        Date date = new Date();
        instrAccountCode.setCreatedBy(user);
        instrAccountCode.setCreatedDate(date);
        instrAccountCode.setModifiedBy(user);
        instrAccountCode.setModifiedDate(date);
        InstrumentType type = this.createInstrumentType(instrType);
        type.getInstrumentAccountCodes().add(instrAccountCode);
        this.session.saveOrUpdate((Object)type);
        instrAccountCode.setInstrumentType(type);
        this.session.saveOrUpdate((Object)instrAccountCode);
        return instrAccountCode;
    }

    public InstrumentOtherDetails createInstrumentOtherDetails(InstrumentVoucher instrVoucher, Date statusDate) {
        InstrumentOtherDetails instrOtherDet = new InstrumentOtherDetails();
        instrOtherDet.setInstrumentHeaderId(instrVoucher.getInstrumentHeaderId());
        instrOtherDet.setPayinslipId(instrVoucher.getVoucherHeaderId());
        instrOtherDet.setInstrumentStatusDate(statusDate);
        User user = this.createUser("testUser");
        instrOtherDet.setCreatedBy(user);
        instrOtherDet.setModifiedBy(user);
        instrOtherDet.setCreatedDate(statusDate);
        instrOtherDet.setModifiedDate(statusDate);
        this.session.saveOrUpdate((Object)instrOtherDet);
        return instrOtherDet;
    }

    public InstrumentVoucher createInstrumentVoucher(EgwStatus instrumentStatus, InstrumentType instrumentType) {
        InstrumentVoucher instrVoucher = new InstrumentVoucher();
        InstrumentHeader instrHeader = this.createInstrumentHeader(instrumentType, instrumentStatus);
        CVoucherHeader voucher = this.createVoucher("testVoucher");
        User user = this.createUser("testUser");
        Date date = new Date();
        instrVoucher.setInstrumentHeaderId(instrHeader);
        instrVoucher.setVoucherHeaderId(voucher);
        instrVoucher.setCreatedBy(user);
        instrVoucher.setModifiedBy(user);
        instrVoucher.setCreatedDate(date);
        instrVoucher.setModifiedDate(date);
        this.session.saveOrUpdate((Object)instrVoucher);
        return instrVoucher;
    }

    public ReceiptDetail createReceiptDetailWithoutHeader() {
        ReceiptDetail receiptDetail = new ReceiptDetail();
        receiptDetail.setAccounthead(this.createCOA("testGLCode"));
        receiptDetail.setCramount(BigDecimal.valueOf(10000L));
        receiptDetail.setDramount(BigDecimal.valueOf(0L));
        receiptDetail.setFunction(this.createFunction("testFunction"));
        receiptDetail.setFinancialYear(this.getFinancialYearForDate(new Date()));
        this.session.saveOrUpdate((Object)receiptDetail);
        return receiptDetail;
    }

    public Position createPosition(Designation desig) {
        Position position = new Position();
        position.setName(desig.getName() + "pos");
        this.session.saveOrUpdate((Object)position);
        return position;
    }

    public Department createDept(String name) {
        Department d = new Department();
        d.setName(name + this.getRandomNumber());
        d.setCode(name + this.getRandomNumber());
        this.session.save((Object)d);
        return d;
    }

    public Designation createDesignation(int deptId, String designationName) {
        Designation designation = new Designation();
        designation.setName(designationName);
        designation.setDescription(designationName);
        this.session.saveOrUpdate((Object)designation);
        return designation;
    }

    public PersonalInformation createPersonalInformation(User user, Department dept) {
        PersonalInformation personalInformation = new PersonalInformation();
        personalInformation.setEmployeeFirstName(user.getName());
        Random ran = new Random();
        personalInformation.setEmployeeCode(Integer.valueOf(ran.nextInt()));
        personalInformation.setUserMaster(user);
        this.session.saveOrUpdate((Object)personalInformation);
        return personalInformation;
    }

    public Accountdetailkey createAccountdetailkey(String keyname) {
        Accountdetailkey accountdetailkey = new Accountdetailkey();
        accountdetailkey.setAccountdetailtype(this.createAccountdetailtype("testAccountDetailTypeName"));
        accountdetailkey.setDetailkey(Integer.valueOf(1));
        accountdetailkey.setDetailname(keyname);
        accountdetailkey.setGroupid(Integer.valueOf(1));
        this.session.saveOrUpdate((Object)accountdetailkey);
        return accountdetailkey;
    }

    public Accountdetailtype createAccountdetailtype(String name) {
        Accountdetailtype accountdetailtype = new Accountdetailtype();
        accountdetailtype.setName(name + this.getRandomNumber());
        accountdetailtype.setDescription(name);
        accountdetailtype.setAttributename(name + this.getRandomNumber());
        accountdetailtype.setNbroflevels(new BigDecimal(1));
        this.session.saveOrUpdate((Object)accountdetailtype);
        return accountdetailtype;
    }

    public AccountPayeeDetail createAccountPayeeDetail() {
        return this.createAccountPayeeDetail(this.createAccountdetailtype("test"), this.createAccountdetailkey("test"), BigDecimal.valueOf(100.0), this.createReceiptDetailWithoutHeader());
    }

    public AccountPayeeDetail createUnsavedAccountPayeeDetail(Accountdetailtype accdetailtype, Accountdetailkey accdetailkey, BigDecimal amt, ReceiptDetail receiptDetail) {
        AccountPayeeDetail accpayeeDetail = new AccountPayeeDetail();
        accpayeeDetail.setAmount(amt);
        accpayeeDetail.setAccountDetailKey(accdetailkey);
        accpayeeDetail.setAccountDetailType(accdetailtype);
        receiptDetail.addAccountPayeeDetail(accpayeeDetail);
        accpayeeDetail.setReceiptDetail(receiptDetail);
        return accpayeeDetail;
    }

    public AccountPayeeDetail createAccountPayeeDetail(Accountdetailtype accdetailtype, Accountdetailkey accdetailkey, BigDecimal amt, ReceiptDetail receiptDetail) {
        AccountPayeeDetail accpayeeDetail = this.createUnsavedAccountPayeeDetail(accdetailtype, accdetailkey, amt, receiptDetail);
        this.session.saveOrUpdate((Object)accpayeeDetail);
        return accpayeeDetail;
    }

    public Scheme createScheme(String code, String name, Fund fund) {
        Scheme scheme = new Scheme();
        scheme.setCode(code + this.getRandomNumber());
        scheme.setName(name + this.getRandomNumber());
        scheme.setFund(fund);
        scheme.setIsactive(Boolean.valueOf(true));
        this.session.saveOrUpdate((Object)scheme);
        return scheme;
    }

    public SubScheme createSubScheme(Scheme scheme) {
        SubScheme subscheme = new SubScheme();
        subscheme.setCode("1234567" + this.getRandomNumber());
        subscheme.setName("subScheme" + this.getRandomNumber());
        subscheme.setValidfrom(new Date());
        subscheme.setValidto(new Date());
        subscheme.setScheme(scheme);
        subscheme.setIsactive(Boolean.valueOf(true));
        subscheme.setLastmodifieddate(new Date());
        this.session.saveOrUpdate((Object)subscheme);
        return subscheme;
    }

    public ReceiptMisc createReceiptMisForMiscReceipt() throws NumberFormatException {
        ReceiptMisc receiptMisc = new ReceiptMisc();
        Fund fund = this.createFund("001");
        Scheme scheme = this.createScheme("234", "testscheme1", fund);
        receiptMisc.setBoundary(this.createBoundary());
        receiptMisc.setDepartment(this.createDept("testDeptName", "testDeptCode"));
        receiptMisc.setFund(fund);
        receiptMisc.setFundsource(this.createFundsource("testFSName", "testFSCode"));
        receiptMisc.setScheme(scheme);
        receiptMisc.setSubscheme(this.createSubScheme(scheme));
        receiptMisc.setReceiptHeader(this.createReceiptHeader("11111"));
        receiptMisc.setIdFunctionary(this.createSavedFunctionary());
        this.session.saveOrUpdate((Object)receiptMisc);
        return receiptMisc;
    }

    public List<ReceiptDetailInfo> createBillCreditDetailslist() {
        ArrayList<ReceiptDetailInfo> billCreditDetailslist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setAccounthead("Surcharge on Stamp Duty for Transfer of Immovable Properties");
        vd.setCreditAmountDetail(new BigDecimal(100));
        vd.setDebitAmountDetail(new BigDecimal(0));
        vd.setAmount(new BigDecimal(0));
        vd.setGlcodeDetail("testGLCODE");
        vd.setGlcodeIdDetail(Long.valueOf(355L));
        billCreditDetailslist.add(vd);
        return billCreditDetailslist;
    }

    public List<ReceiptDetailInfo> createEmptyBillRebateDetailslist() {
        ArrayList<ReceiptDetailInfo> billRebateDetailslist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setAccounthead("");
        vd.setCreditAmountDetail(new BigDecimal(0));
        vd.setDebitAmountDetail(new BigDecimal(0));
        vd.setAmount(new BigDecimal(0));
        vd.setGlcodeDetail("");
        billRebateDetailslist.add(vd);
        return billRebateDetailslist;
    }

    public List<ReceiptDetailInfo> createEmptySubLedgerlist() {
        ArrayList<ReceiptDetailInfo> subLedgerlist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setCreditAmountDetail(new BigDecimal(0));
        vd.setDebitAmountDetail(new BigDecimal(0));
        vd.setAmount(new BigDecimal(0));
        vd.setDetailCode("");
        vd.setDetailKey("");
        subLedgerlist.add(vd);
        return subLedgerlist;
    }

    public Functionary createSavedFunctionary() {
        Functionary functionary = new Functionary();
        functionary.setCode(BigDecimal.valueOf(10102L));
        functionary.setCreatetimestamp(new Date());
        functionary.setIsactive(Boolean.valueOf(true));
        functionary.setName("Test Functionary");
        functionary.setUpdatetimestamp(new Date());
        this.session.saveOrUpdate((Object)functionary);
        return functionary;
    }

    public CChartOfAccountDetail createCOADetail(CChartOfAccounts c, Accountdetailtype a) {
        CChartOfAccountDetail cChartOfAccountDetail = new CChartOfAccountDetail();
        cChartOfAccountDetail.setGlCodeId(c);
        cChartOfAccountDetail.setDetailTypeId(a);
        this.session.saveOrUpdate((Object)cChartOfAccountDetail);
        return cChartOfAccountDetail;
    }

    public List<ReceiptDetailInfo> createBillRebateDetailslist() {
        ArrayList<ReceiptDetailInfo> billRebateDetailslist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setAccounthead("Leave Salary and Gratuity Fund");
        vd.setCreditAmountDetail(new BigDecimal(0));
        vd.setDebitAmountDetail(new BigDecimal(100));
        vd.setAmount(new BigDecimal(0));
        vd.setGlcodeDetail("testBRGLCode");
        vd.setGlcodeIdDetail(Long.valueOf(757L));
        billRebateDetailslist.add(vd);
        return billRebateDetailslist;
    }

    public CChartOfAccounts createCOAForGLCode(String glcode) {
        CChartOfAccounts coa = new CChartOfAccounts();
        User user = this.createUser("testUser");
        Date date = new Date();
        coa.setGlcode(glcode);
        coa.setName("testcoa");
        coa.setIsActiveForPosting(Boolean.valueOf(true));
        coa.setCreatedBy(user);
        coa.setModifiedBy(user);
        coa.setCreatedDate(date);
        coa.setModifiedDate(date);
        coa.setPurposeId(Long.valueOf(4L));
        coa.setType(Character.valueOf('I'));
        this.session.saveOrUpdate((Object)coa);
        return coa;
    }

    public List<ReceiptDetailInfo> createSubLedgerlist() {
        ArrayList<ReceiptDetailInfo> subLedgerlist = new ArrayList<ReceiptDetailInfo>();
        CChartOfAccounts ccoa = this.createCOA("subLedGLCode");
        Accountdetailkey accDetKey1 = this.createAccountdetailkey("testDetailKeyName1");
        Accountdetailkey accDetKey2 = this.createAccountdetailkey("testDetailKeyName2");
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setCreditAmountDetail(new BigDecimal(0));
        vd.setDebitAmountDetail(new BigDecimal(0));
        vd.setAmount(new BigDecimal(50));
        vd.setDetailCode("102");
        vd.setDetailKey(accDetKey1.getDetailkey().toString());
        vd.setDetailKeyId(accDetKey1.getDetailkey());
        vd.setDetailType(accDetKey1.getAccountdetailtype());
        vd.setDetailTypeName("Employee");
        vd.setGlcode(ccoa);
        vd.setSubledgerCode("3117004");
        subLedgerlist.add(vd);
        ReceiptDetailInfo vd2 = new ReceiptDetailInfo();
        vd2.setCreditAmountDetail(new BigDecimal(0));
        vd2.setDebitAmountDetail(new BigDecimal(0));
        vd2.setAmount(new BigDecimal(50));
        vd2.setDetailCode("103");
        vd2.setDetailKey(accDetKey2.getDetailkey().toString());
        vd2.setDetailKeyId(accDetKey2.getDetailkey());
        vd2.setDetailType(accDetKey2.getAccountdetailtype());
        vd2.setDetailTypeName("Employee");
        vd2.setGlcode(ccoa);
        vd2.setSubledgerCode("3117004");
        subLedgerlist.add(vd2);
        return subLedgerlist;
    }

    public List<ReceiptDetailInfo> createSubLedgerlist(CChartOfAccounts ccoa, Accountdetailtype accDetailType) {
        ArrayList<ReceiptDetailInfo> subLedgerlist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setCreditAmountDetail(new BigDecimal(0));
        vd.setDebitAmountDetail(new BigDecimal(0));
        vd.setAmount(new BigDecimal(50));
        vd.setDetailCode("102");
        vd.setDetailKey("CHHIDDU PRASAD");
        vd.setDetailKeyId(Integer.valueOf(3));
        vd.setDetailType(accDetailType);
        vd.setDetailTypeName("Employee");
        vd.setGlcode(ccoa);
        vd.setSubledgerCode("3117004");
        subLedgerlist.add(vd);
        ReceiptDetailInfo vd2 = new ReceiptDetailInfo();
        vd2.setCreditAmountDetail(new BigDecimal(0));
        vd2.setDebitAmountDetail(new BigDecimal(0));
        vd2.setAmount(new BigDecimal(50));
        vd2.setDetailCode("103");
        vd2.setDetailKey("RAM PRASAD");
        vd2.setDetailKeyId(Integer.valueOf(4));
        vd2.setDetailType(accDetailType);
        vd2.setDetailTypeName("Employee");
        vd2.setGlcode(ccoa);
        vd2.setSubledgerCode("3117004");
        subLedgerlist.add(vd2);
        return subLedgerlist;
    }

    public OnlinePayment createOnlinePayment() throws NumberFormatException {
        OnlinePayment onlinePayment = new OnlinePayment();
        User user = this.createUser("testUser");
        onlinePayment.setCreatedDate(new Date());
        onlinePayment.setModifiedDate(new Date());
        onlinePayment.setCreatedBy(user);
        onlinePayment.setModifiedBy(user);
        onlinePayment.setService(this.createServiceDetails());
        onlinePayment.setTransactionAmount(BigDecimal.valueOf(1000L));
        onlinePayment.setTransactionDate(new Date());
        onlinePayment.setTransactionNumber("2309319937");
        onlinePayment.setReceiptHeader(this.createReceiptHeader("101010" + this.getRandomNumber()));
        onlinePayment.setStatus(this.createEgwStatus(("testCodeRH" + this.getRandomNumber()).substring(0, 10), MODULE_NAME_TESTRECEIPTHEADER));
        onlinePayment.getReceiptHeader().setOnlinePayment(onlinePayment);
        this.session.saveOrUpdate((Object)onlinePayment);
        return onlinePayment;
    }

    public OnlinePayment createOnlinePayment(ReceiptHeader receiptHeader, String transNo, BigDecimal transAmt, EgwStatus status) throws NumberFormatException {
        OnlinePayment onlinePayment = new OnlinePayment();
        User user = this.createUser("testUser");
        onlinePayment.setCreatedDate(new Date());
        onlinePayment.setModifiedDate(new Date());
        onlinePayment.setCreatedBy(user);
        onlinePayment.setModifiedBy(user);
        onlinePayment.setService(this.createServiceDetails());
        onlinePayment.setTransactionAmount(transAmt);
        onlinePayment.setTransactionDate(new Date());
        onlinePayment.setTransactionNumber(transNo);
        onlinePayment.setStatus(status);
        receiptHeader.setOnlinePayment(onlinePayment);
        onlinePayment.setReceiptHeader(receiptHeader);
        this.session.saveOrUpdate((Object)onlinePayment);
        return onlinePayment;
    }

    public DefaultPaymentResponse createPaytResponse() {
        DefaultPaymentResponse paytResponse = new DefaultPaymentResponse();
        paytResponse.setMerchantId("MerchantID");
        paytResponse.setCustomerId("customerId");
        paytResponse.setTxnReferenceNo("txnReferenceNo");
        paytResponse.setBankReferenceNo("bankReferenceNo");
        paytResponse.setTxnAmount(BigDecimal.valueOf(1000.0));
        paytResponse.setBankId(Integer.valueOf(1));
        paytResponse.setBankMerchantId(Integer.valueOf(1));
        paytResponse.setTxnType("txnType");
        paytResponse.setCurrencyName("currencyName");
        paytResponse.setItemCode("itemCode");
        paytResponse.setSecurityType("securityType");
        paytResponse.setSecurityId(Integer.valueOf(1));
        paytResponse.setSecurityPassword("securityPassword");
        paytResponse.setTxnDate(new Date());
        paytResponse.setAuthStatus("authStatus");
        paytResponse.setSettlementType("settlementType");
        paytResponse.setReceiptId("10001");
        paytResponse.setAdditionalInfo2("additionalInfo2");
        paytResponse.setAdditionalInfo3("additionalInfo3");
        paytResponse.setPaytGatewayServiceCode("additionalInfo4");
        paytResponse.setBillingServiceCode("additionalInfo5");
        paytResponse.setAdditionalInfo6("additionalInfo6");
        paytResponse.setAdditionalInfo7("additionalInfo7");
        paytResponse.setErrorStatus("errorStatus");
        paytResponse.setErrorDescription("errorDescription");
        paytResponse.setChecksum("checksum");
        return paytResponse;
    }

    public List<Map<String, Object>> createMapForInstrumentHeader(List<InstrumentHeader> instrumentHeaderList) {
        ArrayList<Map<String, Object>> instrumentHeaderMapList = new ArrayList<Map<String, Object>>();
        if (instrumentHeaderList != null) {
            for (InstrumentHeader instrumentHeader : instrumentHeaderList) {
                HashMap<String, Object> instrumentHeaderMap = new HashMap<String, Object>();
                instrumentHeaderMap.put("Instrument number", instrumentHeader.getInstrumentNumber());
                instrumentHeaderMap.put("Instrument date", instrumentHeader.getInstrumentDate());
                instrumentHeaderMap.put("Instrument amount", instrumentHeader.getInstrumentAmount());
                instrumentHeaderMap.put("Instrument type", instrumentHeader.getInstrumentType().getType());
                instrumentHeaderMap.put("Is pay cheque", instrumentHeader.getIsPayCheque());
                if (instrumentHeader.getBankId() != null) {
                    instrumentHeaderMap.put("Bank code", instrumentHeader.getBankId().getCode());
                }
                instrumentHeaderMap.put("Bank branch name", instrumentHeader.getBankBranchName());
                instrumentHeaderMap.put("Transaction number", instrumentHeader.getTransactionNumber());
                instrumentHeaderMap.put("Transaction date", instrumentHeader.getTransactionDate());
                instrumentHeaderMapList.add(instrumentHeaderMap);
            }
        }
        return instrumentHeaderMapList;
    }

    public List<Map<String, Object>> createMapForInstrumentVoucher(List<CVoucherHeader> voucherHeaderList, List<InstrumentHeader> instrumentHeaderList) {
        ArrayList<Map<String, Object>> instrumentVoucherList = new ArrayList<Map<String, Object>>();
        if (voucherHeaderList != null && instrumentHeaderList != null) {
            for (CVoucherHeader voucherHeader : voucherHeaderList) {
                for (InstrumentHeader instrumentHeader : instrumentHeaderList) {
                    HashMap<String, Object> iVoucherMap = new HashMap<String, Object>();
                    iVoucherMap.put("Instrument header", instrumentHeader);
                    iVoucherMap.put("Voucher header", voucherHeader);
                    instrumentVoucherList.add(iVoucherMap);
                }
            }
        }
        return instrumentVoucherList;
    }

    public Challan createChallan() throws NumberFormatException {
        Challan challan = this.createUnsavedChallan();
        this.session.saveOrUpdate((Object)challan);
        return challan;
    }

    public ReceiptHeader createReceiptHeaderWithChallan() throws NumberFormatException {
        ReceiptHeader receiptHeader = this.createReceiptHeader("testReceiptNo");
        receiptHeader.setReceipttype('C');
        Challan challan = new Challan();
        User user = this.createUser("testUser");
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.add(5, 2);
        Date valid = cal.getTime();
        challan.setValidUpto(valid);
        challan.setCreatedDate(date);
        challan.setLastModifiedDate(date);
        challan.setCreatedBy(user);
        challan.setLastModifiedBy(user);
        challan.setChallanNumber("testChallanNo");
        challan.setChallanDate(date);
        challan.setService(this.createServiceDetails("testService"));
        challan.setStatus(this.createEgwStatus(("testCodeRH" + this.getRandomNumber()).substring(0, 10), MODULE_NAME_TESTCHALLANHEADER));
        challan.setVoucherHeader(this.createVoucher("testChallanVoucher"));
        challan.setReceiptHeader(receiptHeader);
        receiptHeader.setChallan(challan);
        this.session.saveOrUpdate((Object)challan);
        this.session.saveOrUpdate((Object)receiptHeader);
        return receiptHeader;
    }

    public Challan createUnsavedChallan() throws NumberFormatException {
        Challan challan = new Challan();
        User user = this.createUser("testUser");
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.add(5, 3);
        Date valid = cal.getTime();
        challan.setValidUpto(valid);
        challan.setCreatedDate(date);
        challan.setLastModifiedDate(date);
        challan.setCreatedBy(user);
        challan.setLastModifiedBy(user);
        challan.setChallanNumber("testChallanNo");
        challan.setChallanDate(date);
        challan.setService(this.createServiceDetails("testService"));
        challan.setStatus(this.createEgwStatus(("testCodeRH" + this.getRandomNumber()).substring(0, 10), MODULE_NAME_TESTCHALLANHEADER));
        return challan;
    }

    public ServiceDetails createUnsavedChallanServiceDetails() {
        ServiceDetails service = new ServiceDetails();
        BankAccountServiceMap tempB = new BankAccountServiceMap();
        String serviceName = "@testChallanSrvc$" + this.getRandomNumber(9999);
        service.setName(serviceName);
        service.setServiceUrl("testServiceURL");
        service.setServiceType("S");
        service.setCode("testCode");
        service.addBankAccountServiceMap(this.createBankAccountServiceMap(service));
        return service;
    }

    public ReceiptMisc createReceiptMisForChallan() throws NumberFormatException {
        ReceiptMisc receiptMisc = new ReceiptMisc();
        Fund fund = this.createFund("001");
        receiptMisc.setBoundary(this.createBoundary());
        receiptMisc.setDepartment(this.createDept("testDeptName", "testDeptCode"));
        receiptMisc.setFund(fund);
        receiptMisc.setReceiptHeader(this.createReceiptHeader("11111"));
        this.session.saveOrUpdate((Object)receiptMisc);
        return receiptMisc;
    }

    public ReceiptDetailInfo createReceiptDetailInfo(BigDecimal creditAmt, BigDecimal debitAmt, String glCode) {
        ReceiptDetailInfo receiptDetailInfo = new ReceiptDetailInfo();
        receiptDetailInfo.setCreditAmountDetail(creditAmt);
        receiptDetailInfo.setDebitAmountDetail(debitAmt);
        receiptDetailInfo.setAmount(new BigDecimal(0));
        receiptDetailInfo.setGlcodeDetail(glCode);
        receiptDetailInfo.setGlcodeIdDetail(Long.valueOf(355L));
        receiptDetailInfo.setFunctionDetail("testFunction");
        receiptDetailInfo.setFunctionIdDetail(Long.valueOf(2L));
        return receiptDetailInfo;
    }

    public List<ReceiptDetailInfo> createCreditDetailslist() {
        ArrayList<ReceiptDetailInfo> billCreditDetailslist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setAccounthead("Surcharge on Stamp Duty for Transfer of Immovable Properties");
        vd.setCreditAmountDetail(new BigDecimal(100));
        vd.setDebitAmountDetail(new BigDecimal(0));
        vd.setAmount(new BigDecimal(0));
        vd.setGlcodeDetail("testGLCODE");
        vd.setGlcodeIdDetail(Long.valueOf(355L));
        vd.setFinancialYearId(Long.valueOf("4"));
        vd.setFunctionDetail("testFunction");
        vd.setFunctionIdDetail(Long.valueOf(2L));
        billCreditDetailslist.add(vd);
        return billCreditDetailslist;
    }

    public List<ReceiptDetailInfo> createCreditDetailslist(CChartOfAccounts account) {
        ArrayList<ReceiptDetailInfo> billCreditDetailslist = new ArrayList<ReceiptDetailInfo>();
        ReceiptDetailInfo vd = new ReceiptDetailInfo();
        vd.setAccounthead(account.getName());
        vd.setCreditAmountDetail(new BigDecimal(100));
        vd.setDebitAmountDetail(new BigDecimal(0));
        vd.setAmount(new BigDecimal(0));
        vd.setGlcodeDetail(account.getGlcode());
        vd.setGlcodeIdDetail(account.getId());
        vd.setFinancialYearId(Long.valueOf("4"));
        vd.setFunctionDetail("testFunction");
        vd.setFunctionIdDetail(Long.valueOf(2L));
        billCreditDetailslist.add(vd);
        return billCreditDetailslist;
    }

    public ReceiptHeader createReceiptHeaderForChallan() throws NumberFormatException {
        ReceiptHeader receiptHeader = null;
        receiptHeader.setReceipttype('C');
        receiptHeader.setReceiptnumber("1234" + this.getRandomNumber());
        receiptHeader.setReferencenumber("12");
        receiptHeader.setConsumerCode("10-10-111-20");
        receiptHeader.setService(this.createServiceDetails());
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setLastModifiedDate(new Date());
        User user = this.createUser("egovernments");
        receiptHeader.setCreatedBy(user);
        receiptHeader.setLastModifiedBy(user);
        receiptHeader.setIsReconciled(Boolean.valueOf(false));
        receiptHeader.setStatus(this.createEgwStatus("testcode", "Challan"));
        receiptHeader.setPaidBy("Test Payee");
        receiptHeader.setReceiptMisc(this.createUnSavedReceiptMisc(receiptHeader));
        receiptHeader.addReceiptDetail(this.createReceiptDetailForChallan());
        this.session.saveOrUpdate(receiptHeader);
        return receiptHeader;
    }

    public ReceiptDetail createReceiptDetailForChallan() throws NumberFormatException {
        ReceiptDetail receiptDetail = this.createUnsavedReceiptDetail(this.createCOA("1100201"), BigDecimal.valueOf(100.0), BigDecimal.valueOf(100.0), this.createFunction("Test Function"), 1L, "testGLDescription", this.createReceiptHeader("11111"), true);
        receiptDetail.setFinancialYear(this.getFinancialYearForDate(new Date()));
        this.session.saveOrUpdate((Object)receiptDetail);
        receiptDetail.addAccountPayeeDetail(this.createAccountPayeeDetail(this.createAccountdetailtype("test"), this.createAccountdetailkey("test"), BigDecimal.valueOf(100.0), receiptDetail));
        this.session.saveOrUpdate((Object)receiptDetail);
        return receiptDetail;
    }

    public ServiceDetails createChallanServiceDetails() throws NumberFormatException {
        ServiceDetails service = new ServiceDetails();
        String serviceName = "@testChallanSrvc$" + this.getRandomNumber(9999);
        service.setName(serviceName);
        service.setServiceUrl("testServiceURL");
        service.setServiceType("S");
        service.setCode("testCode");
        this.session.saveOrUpdate((Object)service);
        return service;
    }
}

