/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.Bankaccount;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.HibernateUtil;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentType;
import org.egov.model.instrument.InstrumentVoucher;
import org.egov.services.contra.ContraService;
import org.egov.services.instrument.InstrumentService;
import org.hibernate.SQLQuery;

public class FinancialsUtil {
    private InstrumentService instrumentService;
    public PersistenceService<InstrumentHeader, Long> instrumentHeaderService;
    private ContraService contraService;
    private CreateVoucher voucherCreator;
    private CollectionsUtil collectionsUtil;
    private static final Logger LOGGER = Logger.getLogger(FinancialsUtil.class);

    public void setInstrumentService(InstrumentService instrumentService) {
        this.instrumentService = instrumentService;
    }

    public InstrumentType getInstrumentTypeByType(String type) {
        return this.instrumentService.getInstrumentTypeByType(type);
    }

    public CVoucherHeader createRemittanceVoucher(HashMap<String, Object> headerdetails, List<HashMap<String, Object>> accountCodeList, List<HashMap<String, Object>> subledgerList) {
        CVoucherHeader voucherHeaderCash = new CVoucherHeader();
        String createVoucher = this.collectionsUtil.getAppConfigValue("Collection", "CREATEVOUCHER_FOR_REMITTANCE");
        if ("Y".equalsIgnoreCase(createVoucher)) {
            try {
                voucherHeaderCash = this.createApprovedVoucher(headerdetails, accountCodeList, subledgerList);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error in createBankRemittance createPreApprovalVoucher when cash amount>0");
            }
        }
        return voucherHeaderCash;
    }

    public CVoucherHeader createVoucher(Map<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails, Boolean receiptBulkUpload, Boolean isVoucherApproved) {
        CVoucherHeader voucherHeader = null;
        LOGGER.debug((Object)"Logs For HandHeldDevice Permance Test : Voucher Creation Started....");
        voucherHeader = !receiptBulkUpload.booleanValue() ? (isVoucherApproved != null && isVoucherApproved.booleanValue() ? this.createApprovedVoucher(headerdetails, accountcodedetails, subledgerdetails) : this.createPreApprovalVoucher(headerdetails, accountcodedetails, subledgerdetails)) : this.createApprovedVoucher(headerdetails, accountcodedetails, subledgerdetails);
        LOGGER.info((Object)"Logs For HandHeldDevice Permance Test : Voucher Creation Ended...");
        return voucherHeader;
    }

    public CVoucherHeader createPreApprovalVoucher(Map<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails) throws ApplicationRuntimeException {
        CVoucherHeader voucherHeaders = null;
        try {
            if (headerdetails instanceof HashMap) {
                voucherHeaders = this.voucherCreator.createPreApprovedVoucher((HashMap)headerdetails, accountcodedetails, subledgerdetails);
            }
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)"Exception while creating voucher!", (Throwable)e);
            throw e;
        }
        return voucherHeaders;
    }

    public CVoucherHeader createApprovedVoucher(Map<String, Object> headerdetails, List<HashMap<String, Object>> accountcodedetails, List<HashMap<String, Object>> subledgerdetails) {
        CVoucherHeader voucherHeaders = null;
        try {
            if (headerdetails instanceof HashMap) {
                headerdetails.put("moduleid", "10");
                voucherHeaders = this.voucherCreator.createVoucher((HashMap)headerdetails, accountcodedetails, subledgerdetails);
            }
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)"Exception while creating voucher!", (Throwable)e);
            throw e;
        }
        return voucherHeaders;
    }

    public CVoucherHeader getReversalVoucher(List<HashMap<String, Object>> paramList) {
        CVoucherHeader voucherHeaders = null;
        try {
            voucherHeaders = this.voucherCreator.reverseVoucher(paramList);
        }
        catch (ApplicationRuntimeException re) {
            LOGGER.error((Object)"Runtime Exception while creating reversal voucher!", (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception while creating reversal voucher!", (Throwable)e);
            throw new ApplicationRuntimeException("Exception while creating reversal voucher!", (Throwable)e);
        }
        return voucherHeaders;
    }

    public List<InstrumentVoucher> updateInstrument(List<Map<String, Object>> paramList) {
        List instrumentVoucherList = this.instrumentService.updateInstrumentVoucherReference(paramList);
        return instrumentVoucherList;
    }

    public List<InstrumentHeader> createInstrument(List<Map<String, Object>> paramList) {
        List instrumentHeaderList = this.instrumentService.addToInstrument(paramList);
        return instrumentHeaderList;
    }

    public void updateCheque_DD_Card_Deposit(Long payInId, String toBankaccountGlcode, InstrumentHeader instrumentHeader, Map<String, Object> instrumentMap) {
        this.contraService.updateCheque_DD_Card_Deposit(payInId, toBankaccountGlcode, instrumentHeader, instrumentMap);
    }

    public void updateCheque_DD_Card_Deposit_Receipt(Long receiptId, String toBankaccountGlcode, InstrumentHeader instrumentHeader, Map<String, Object> instrumentMap) {
        this.contraService.updateCheque_DD_Card_Deposit_Receipt(receiptId, toBankaccountGlcode, instrumentHeader, instrumentMap);
    }

    public void updateCashDeposit(Long payInId, String toBankaccountGlcode, InstrumentHeader instrumentHeader, Map<String, Object> instrumentMap) {
        this.contraService.updateCashDeposit(payInId, toBankaccountGlcode, instrumentHeader, instrumentMap);
    }

    public ContraService getContraService() {
        return this.contraService;
    }

    public void setContraService(ContraService contraService) {
        this.contraService = contraService;
    }

    public void setVoucherCreator(CreateVoucher voucherCreator) {
        this.voucherCreator = voucherCreator;
    }

    public static boolean isRevenueAccountHead(CChartOfAccounts coa, List<CChartOfAccounts> bankCOAList) {
        Long purposeId = coa.getPurposeId();
        if (bankCOAList.contains(coa)) {
            return true;
        }
        if (purposeId != null) {
            try {
                String purposeName;
                SQLQuery query = HibernateUtil.getCurrentSession().createSQLQuery("SELECT NAME FROM EGF_ACCOUNTCODE_PURPOSE WHERE ID = " + purposeId);
                List purposeNames = query.list();
                if (purposeNames != null && purposeNames.size() == 1 && ((purposeName = (String)purposeNames.get(0)).equals("Cash In Hand") || purposeName.equals("Cheque In Hand") || purposeName.equals("Cash In Transit") || purposeName.equals("Credit Card") || purposeName.equals("ATM ACCOUNT CODE") || purposeName.equals("Inter-Unit Transfer Account"))) {
                    return true;
                }
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("Exception in fetching purpose name for id [" + purposeId + "]", (Throwable)e);
            }
        }
        return false;
    }

    public void updateInstrumentHeader(List<InstrumentHeader> instrumentHeaderList, EgwStatus status, Bankaccount depositedBankAccount) {
        for (InstrumentHeader iHeader : instrumentHeaderList) {
            iHeader.setStatusId(status);
            iHeader.setBankAccountId(depositedBankAccount);
            this.instrumentHeaderService.persist((Object)iHeader);
        }
    }

    public static List<CChartOfAccounts> getBankChartofAccountCodeList() {
        ChartOfAccountsHibernateDAO chartOfAccoutsDAO = new ChartOfAccountsHibernateDAO(CChartOfAccounts.class, HibernateUtil.getCurrentSession());
        return chartOfAccoutsDAO.getBankChartofAccountCodeList();
    }

    public Map<String, Object> prepareForUpdateInstrumentDepositSQL() {
        return this.contraService.prepareForUpdateInstrumentDepositSQL();
    }

    public void setInstrumentHeaderService(PersistenceService<InstrumentHeader, Long> instrumentHeaderService) {
        this.instrumentHeaderService = instrumentHeaderService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }
}

