/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.utils;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.service.CommonsService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.EmployeeService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.exception.NoSuchObjectException;
import org.egov.infra.script.entity.Script;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.services.EISServeable;
import org.egov.infstr.services.PersistenceService;
import org.egov.lib.security.terminal.model.Location;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.SearchPositionService;
import org.egov.pims.utils.EisManagersUtill;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CollectionsUtil {
    private final Map<String, EgwStatus> statusMap = new HashMap<String, EgwStatus>();
    private PersistenceService persistenceService;
    @Autowired
    private UserService userService;
    private CommonsService commonsService;
    private PersistenceService<Script, Long> scriptService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private EisCommonService eisCommonService;
    private EISServeable eisService;
    @Autowired
    private SearchPositionService searchPositionService;
    @Autowired
    private ApplicationContext context;
    private static final Logger LOGGER = Logger.getLogger(CollectionsUtil.class);
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private PositionMasterService posService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private DesignationService designationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgwStatus getReceiptStatusForCode(String statusCode) {
        EgwStatus status = this.statusMap.get(statusCode);
        CollectionsUtil collectionsUtil = this;
        synchronized (collectionsUtil) {
            if (status == null && (status = (EgwStatus)this.persistenceService.findByNamedQuery("getEgwStatusByModuleAndCode", new Object[]{"ReceiptHeader", statusCode})) != null) {
                this.statusMap.put(statusCode, status);
            }
        }
        return status;
    }

    public EgwStatus getEgwStatusForModuleAndCode(String moduleName, String statusCode) {
        EgwStatus status = (EgwStatus)this.persistenceService.findByNamedQuery("getEgwStatusByModuleAndCode", new Object[]{moduleName, statusCode});
        return status;
    }

    public String getLoggedInUserName() {
        return this.securityUtils.getCurrentUser().getName();
    }

    public User getLoggedInUser() {
        return this.securityUtils.getCurrentUser();
    }

    public Department getDepartmentOfUser(User user) {
        return this.eisCommonService.getDepartmentForUser(user.getId());
    }

    public Department getDepartmentOfLoggedInUser() {
        User user = this.securityUtils.getCurrentUser();
        return this.getDepartmentOfUser(user);
    }

    public User getUserByUserName(String userName) {
        return this.userService.getUserByUsername(userName);
    }

    public Location getLocationOfUser(Map<String, Object> sessionMap) {
        Location location = null;
        try {
            location = sessionMap.get("counterId") != null && !sessionMap.get("counterId").equals("") ? (Location)this.persistenceService.findByNamedQuery("getLocationById", new Object[]{Integer.valueOf((String)sessionMap.get("counterId"))}) : (Location)this.persistenceService.findByNamedQuery("getLocationByUser", new Object[]{this.getLoggedInUser().getUsername()});
            if (location == null) {
                throw new ApplicationRuntimeException("Unable to fetch the location of the logged in user [" + (String)sessionMap.get("com.egov.user.LoginUserName") + "]");
            }
        }
        catch (Exception exp) {
            String errorMsg = "Unable to fetch the location of the logged in user [" + (String)sessionMap.get("com.egov.user.LoginUserName") + "]";
            LOGGER.error((Object)errorMsg, (Throwable)exp);
            throw new ApplicationRuntimeException(errorMsg, (Throwable)exp);
        }
        return location;
    }

    public List getAllCounters() {
        return this.persistenceService.findAllByNamedQuery("getAllCounters", new Object[0]);
    }

    public List getActiveCounters() {
        return this.persistenceService.findAllByNamedQuery("getAllActiveCounters", new Object[0]);
    }

    public List getCollectionServiceList() {
        return this.persistenceService.findAllByNamedQuery("getCollectionServices", new Object[0]);
    }

    public List getChallanServiceList() {
        return this.persistenceService.findAllByNamedQuery("getServicesByType", new Object[]{"H"});
    }

    public List getBillingServiceList() {
        return this.persistenceService.findAllByNamedQuery("getServicesByType", new Object[]{"B"});
    }

    public List getReceiptCreators() {
        return this.persistenceService.findAllByNamedQuery("CREATEDBYUSERS_OF_RECEIPTS", new Object[0]);
    }

    public List getReceiptZoneList() {
        return this.persistenceService.findAllByNamedQuery("getAllReceiptBoundary", new Object[0]);
    }

    public List<String> getCollectionModesNotAllowed(User loggedInUser) {
        ArrayList<String> collectionsModeNotAllowed = new ArrayList<String>();
        Department dept = null;
        dept = this.isEmployee(loggedInUser) == false ? this.departmentService.getDepartmentByName(this.getDepartmentForWorkFlow()) : this.getDepartmentOfUser(loggedInUser);
        if (dept == null) {
            ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
            validationErrors.add(new ValidationError("Department", "billreceipt.counter.deptcode.null"));
        } else if (dept.getCode().equals("R")) {
            collectionsModeNotAllowed.add("card");
            collectionsModeNotAllowed.add("bankchallan");
        } else {
            collectionsModeNotAllowed.add("cash");
            collectionsModeNotAllowed.add("card");
            collectionsModeNotAllowed.add("bankchallan");
        }
        return collectionsModeNotAllowed;
    }

    public Boolean isEmployee(User user) {
        for (Role role : user.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (role == null || !role.getName().equals(appconfig.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONROLEFORNONEMPLOYEE");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public String getDepartmentForWorkFlow() {
        String department = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONDEPARTMENTFORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return department;
    }

    public Position getPositionByDeptDesgAndBoundary(Department dept, Designation desg, Boundary boundary) {
        Assignment assignmentObj = null;
        Designation desgnObj = this.designationService.getDesignationByName(this.getDesignationForThirdPartyUser());
        Department deptObj = this.departmentService.getDepartmentByName(this.getDepartmentForWorkFlow());
        List employeeList = this.employeeService.findByDepartmentDesignationAndBoundary(deptObj.getId(), desgnObj.getId(), boundary.getId());
        if (!employeeList.isEmpty()) {
            assignmentObj = this.assignmentService.getPrimaryAssignmentForEmployee(((Employee)employeeList.get(0)).getId());
        } else {
            List empList = this.employeeService.findByDepartmentDesignationAndBoundary(deptObj.getId(), desgnObj.getId(), boundary.getParent().getId());
            assignmentObj = this.assignmentService.getPrimaryAssignmentForEmployee(((Employee)empList.get(0)).getId());
        }
        return assignmentObj != null ? assignmentObj.getPosition() : null;
    }

    public String getDesignationForThirdPartyUser() {
        String designation = "";
        List appConfigValue = this.appConfigValuesService.getConfigValuesByModuleAndKey("Collection", "COLLECTIONDESIGNATIONFORCSCOPERATORASCLERK");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            designation = ((AppConfigValues)appConfigValue.get(0)).getValue();
        }
        return designation;
    }

    public Position getPositionOfUser(User user) {
        return this.posService.getCurrentPositionForUser(user.getId());
    }

    public Position getPositionByName(String positionName) {
        return this.posService.getPositionByName(positionName);
    }

    public CFinancialYear getFinancialYearforDate(Date date) {
        return (CFinancialYear)this.persistenceService.getSession().createQuery("from CFinancialYear cfinancialyear where ? between cfinancialyear.startingDate and cfinancialyear.endingDate").setDate(0, date).list().get(0);
    }

    public boolean checkChallanValidity(Challan challan) {
        Calendar current = Calendar.getInstance();
        current.clear(11);
        current.clear(12);
        current.clear(13);
        current.clear(14);
        Calendar validityStart = Calendar.getInstance();
        validityStart.setTime(challan.getChallanDate());
        validityStart.clear(11);
        validityStart.clear(12);
        validityStart.clear(13);
        validityStart.clear(14);
        Calendar validityEnd = Calendar.getInstance();
        validityEnd.setTime(challan.getValidUpto());
        validityEnd.clear(11);
        validityEnd.clear(12);
        validityEnd.clear(13);
        validityEnd.clear(14);
        return validityStart.compareTo(current) <= 0 && validityEnd.compareTo(current) >= 0;
    }

    public void setScriptService(PersistenceService<Script, Long> scriptService) {
        this.scriptService = scriptService;
    }

    public Object getBean(String beanName) {
        Object bean = null;
        try {
            bean = this.context.getBean(beanName);
            LOGGER.debug((Object)(" Got bean : " + beanName));
        }
        catch (BeansException e) {
            String errorMsg = "Could not locate bean [" + beanName + "]";
            LOGGER.error((Object)errorMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errorMsg, (Throwable)e);
        }
        return bean;
    }

    public String getAppConfigValue(String moduleName, String key, String defaultValue) {
        AppConfigValues configVal = this.appConfigValuesService.getAppConfigValueByDate(moduleName, key, new Date());
        return configVal == null ? defaultValue : configVal.getValue();
    }

    public String getAppConfigValue(String moduleName, String key) {
        return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key).get(0)).getValue();
    }

    public List<AppConfigValues> getAppConfigValues(String moduleName, String key) {
        return this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, key);
    }

    public Position getPositionById(Long positionId) {
        return this.posService.getPositionById(positionId);
    }

    public Position getPositionforEmp(Integer employeeId) {
        return EisManagersUtill.getEmployeeService().getPositionforEmp(employeeId);
    }

    public PersonalInformation getEmployeeByDepartmentDesignationBoundaryandFunctionary(Long deptId, Long designationId, Integer boundaryId, Integer functionaryId) {
        PersonalInformation personalInformation = null;
        try {
            personalInformation = EisManagersUtill.getEmployeeService().getEmployeeByFunctionary(deptId, designationId, Long.valueOf(boundaryId.intValue()), functionaryId);
        }
        catch (Exception e) {
            String errorMsg = "Could not get PersonalInformation";
            LOGGER.error((Object)"Could not get PersonalInformation", (Throwable)e);
            throw new ApplicationRuntimeException("Could not get PersonalInformation", (Throwable)e);
        }
        return personalInformation;
    }

    public List<Department> getAllNonPrimaryAssignmentsOfLoggedInUser() {
        return this.getAllNonPrimaryAssignmentsOfUser(this.getLoggedInUser());
    }

    public List<Department> getAllNonPrimaryAssignmentsOfUser(User user) {
        ArrayList<Department> departmentlist = new ArrayList<Department>();
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("code", EisManagersUtill.getEmployeeService().getEmpForUserId(user.getId()).getCode());
            List employeeViewList = this.eisService.getEmployeeInfoList(paramMap);
            if (!employeeViewList.isEmpty()) {
                for (EmployeeView employeeView : employeeViewList) {
                    if (employeeView.getAssignment().getPrimary()) continue;
                    departmentlist.add(employeeView.getAssignment().getDepartment());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Could not get list of assignments", (Throwable)e);
        }
        return departmentlist;
    }

    public Department getNonPrimaryDeptOfUser(User user) {
        List<Department> nonPrimaryAssignments = this.getAllNonPrimaryAssignmentsOfUser(user);
        return nonPrimaryAssignments.isEmpty() ? null : nonPrimaryAssignments.get(0);
    }

    public List<Designation> getDesignationsAllowedForChallanApproval(Integer departmentId, ReceiptHeader receiptHeaderObj) {
        this.scriptService.findAllByNamedQuery("SCRIPT", new Object[]{"collection.challanworkflowdesignations.rules"});
        return null;
    }

    public List<Department> getDepartmentsAllowedForChallanApproval(User loggedInUser, ReceiptHeader receiptHeaderObj) {
        this.scriptService.findAllByNamedQuery("SCRIPT", new Object[]{"collection.challanworkflowdepartment.rules"});
        return null;
    }

    public List<Department> getDepartmentsAllowedForBankRemittanceApproval(User loggedInUser) {
        ContraJournalVoucher contraJournalVoucherObj = new ContraJournalVoucher();
        Department department = contraJournalVoucherObj.getVoucherHeaderId() == null ? this.getDepartmentOfUser(loggedInUser) : contraJournalVoucherObj.getVoucherHeaderId().getVouchermis().getDepartmentid();
        List departments = department.getCode().equals(Character.valueOf('R')) ? (contraJournalVoucherObj.getVoucherHeaderId() == null ? this.persistenceService.findAllBy("select dept from Department dept where dept.code=?", new Object[]{Character.valueOf('R')}) : this.persistenceService.findAllBy("select dept from Department dept where dept.code=?", new Object[]{"CAF"})) : this.persistenceService.findAllBy("select dept from Department dept order by dept.name ", new Object[0]);
        return departments;
    }

    public List<Designation> getDesignationsAllowedForBankRemittanceApproval(Long departmentId) {
        ContraJournalVoucher contraJournalVoucherObj = new ContraJournalVoucher();
        Department department = (Department)this.persistenceService.find("select dept from Department dept where dept.id=?", new Object[]{departmentId});
        List designations = contraJournalVoucherObj.getVoucherHeaderId() == null ? (department.getCode().equals(Character.valueOf('R')) ? this.persistenceService.findAllBy("select distinct(dm) from Designation dm,Assignment a where a.designation.id=dm.id and (a.toDate >= current_timestamp or a.toDate is null) and a.department.id=? and upper(dm.name)=?", new Object[]{departmentId, "REVENUE INSPECTOR"}) : this.persistenceService.findAllBy("select distinct(dm) from Designation dm,Assignment a where a.designation.id=dm.id and (a.toDate >= current_timestamp or a.toDate is null) and a.department.id=?", new Object[]{departmentId})) : (department.getCode().equals("CAF") ? this.persistenceService.findAllBy("select distinct(dm) from Designation dm,Assignment a where a.designation,id=dm.id and (a.toDate >= current_timestamp or a.toDate is null) and a.department.code=? and upper(dm.name)=?", new Object[]{"CAF", "SENIOR GRADE CLERK"}) : this.persistenceService.findAllBy("select distinct(dm) from Designation dm,Assignment a where a.designation.id=dm.id and (a.toDate >= current_timestamp or a.toDate is null) and a.department.id=?", new Object[]{departmentId}));
        return designations;
    }

    public boolean isPropertyTaxArrearAccountHead(String glcode, String description) {
        List list = this.appConfigValuesService.getConfigValuesByModuleAndKey("Property Tax", "ISARREARACCOUNT");
        AppConfigValues penaltyGlCode = this.appConfigValuesService.getAppConfigValueByDate("Property Tax", "PTPENALTYGLCODE", new Date());
        boolean retValue = false;
        LOGGER.debug((Object)("isPropertyTaxArrearAccountHead glcode " + glcode + " description " + description));
        if (penaltyGlCode != null && penaltyGlCode.getValue().equals(glcode)) {
            Module module = this.moduleService.getModuleByName("Property Tax");
            String currInst = this.commonsService.getInsatllmentByModuleForGivenDate(module, new Date()).getDescription();
            retValue = !currInst.equals(description.substring(16, description.length()));
        } else {
            ArrayList<String> accValues = new ArrayList<String>();
            for (AppConfigValues value : list) {
                accValues.add(value.getValue());
            }
            retValue = accValues.contains(glcode);
        }
        return retValue;
    }

    public List<EmployeeView> getPositionBySearchParameters(String beginsWith, Integer desId, Integer deptId, Integer jurdId, Integer roleId, Date userDate, Integer maxResults) throws NoSuchObjectException {
        return this.searchPositionService.getPositionBySearchParameters(beginsWith, desId, deptId, jurdId != null ? Long.valueOf(jurdId.intValue()) : null, roleId, userDate, maxResults);
    }

    public BillingIntegrationService getBillingService(String code) {
        ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(new String[]{"classpath*:org/egov/infstr/beanfactory/globalApplicationContext.xml", "classpath*:org/egov/infstr/beanfactory/egiApplicationContext.xml", "classpath*:org/egov/infstr/beanfactory/applicationContext-pims.xml", "classpath*:org/egov/infstr/beanfactory/applicationContext-egf.xml", "classpath*:org/egov/infstr/beanfactory/applicationContext-eportal.xml", "classpath*:org/egov/infstr/beanfactory/applicationContext-ptis.xml", "classpath*:org/egov/infstr/beanfactory/applicationContext-erpcollections.xml", "classpath*:org/egov/infstr/beanfactory/applicationContext-bpa.xml"});
        BillingIntegrationService billingService = (BillingIntegrationService)applicationContext.getBean(code + "CollectionsInterface");
        return billingService;
    }

    public List getAllLocations() {
        return this.persistenceService.findAllByNamedQuery("getAllLocations", new Object[0]);
    }

    public List getAllFunds() {
        return this.persistenceService.findAllByNamedQuery("getallFund", new Object[0]);
    }

    public User getUserById(Long userId) {
        return this.userService.getUserById(userId);
    }

    public Location getLocationByUser(Long userId) {
        User user = this.userService.getUserById(userId);
        return (Location)this.persistenceService.findByNamedQuery("getLocationByUser", new Object[]{user.getUsername()});
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setCommonsService(CommonsService commonsService) {
        this.commonsService = commonsService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

