/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.CFinancialYear;
import org.egov.infra.script.service.ScriptService;
import org.egov.infstr.utils.SequenceNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class CollectionsNumberGenerator {
    private SequenceNumberGenerator sequenceGenerator;
    @Autowired
    private ScriptService scriptService;
    private CollectionsUtil collectionsUtil;

    public String generateReceiptNumber(ReceiptHeader receiptHeader) {
        CFinancialYear financialYear = this.collectionsUtil.getFinancialYearforDate(new Date());
        SimpleDateFormat sdf = new SimpleDateFormat("MM");
        String formattedDate = sdf.format(receiptHeader.getReceiptdate());
        String strObj = "RECEIPTHEADER_" + financialYear.getFinYearRange();
        String result = formattedDate + '/' + financialYear.getFinYearRange() + '/' + this.sequenceGenerator.getNextNumber(strObj, 0L).getFormattedNumber();
        return result;
    }

    public List<String> generateInternalReferenceNumber(ReceiptHeader receiptHeader, CFinancialYear financialYear, CFinancialYear currentFinancialYear) {
        return (List)this.scriptService.executeScript("collection.internalrefno.generator", ScriptService.createContext((Object[])new Object[]{"receiptHeader", receiptHeader, "finYear", financialYear, "currFinYr", currentFinancialYear, "sequenceGenerator", this.sequenceGenerator}));
    }

    public String generateChallanNumber(Challan challan, CFinancialYear financialYear) {
        return (String)this.scriptService.executeScript("collection.challannumber.generator", ScriptService.createContext((Object[])new Object[]{"challan", challan, "sequenceGenerator", this.sequenceGenerator, "finYear", financialYear, "collectionsUtil", this.collectionsUtil}));
    }

    public void setSequenceGenerator(SequenceNumberGenerator sequenceGenerator) {
        this.sequenceGenerator = sequenceGenerator;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }
}

