/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import org.egov.collection.repository.ServiceCategoryRepository;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.ServiceCategory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

@Service
@Transactional(readOnly=true)
public class ServiceCategoryService {
    private final ServiceCategoryRepository serviceCategoryRepository;
    @Autowired
    @Qualifier(value="entityValidator")
    private LocalValidatorFactoryBean entityValidator;

    @Autowired
    public ServiceCategoryService(ServiceCategoryRepository serviceCategoryRepository) {
        this.serviceCategoryRepository = serviceCategoryRepository;
    }

    @Transactional
    public void create(ServiceCategory serviceCategory) {
        this.serviceCategoryRepository.save(serviceCategory);
    }

    @Transactional
    public void update(ServiceCategory serviceCategory) {
        this.serviceCategoryRepository.save(serviceCategory);
    }

    public List<ServiceCategory> getAllServiceCategoriesOrderByCode() {
        return this.serviceCategoryRepository.findAllByOrderByCodeAsc();
    }

    public ServiceCategory findByCode(String code) {
        return this.serviceCategoryRepository.findByCode(code);
    }

    public List<ServiceCategory> getAllActiveServiceCategories() {
        return this.serviceCategoryRepository.findAllActiveServiceCategories();
    }

    public void validate(ServiceCategory model) {
        List<ValidationError> errors = this.validateModel(model);
        if (!errors.isEmpty()) {
            throw new ValidationException(errors);
        }
    }

    public List<ValidationError> validateModel(ServiceCategory model) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (model == null) {
            errors.add(new ValidationError("", "model.null"));
            return errors;
        }
        Set constraintViolations = this.entityValidator.validate((Object)model, new Class[0]);
        for (ConstraintViolation constraintViolation : constraintViolations) {
            Iterator nodes = constraintViolation.getPropertyPath().iterator();
            while (nodes.hasNext()) {
                errors.add(new ValidationError(((Path.Node)nodes.next()).getName(), constraintViolation.getMessage()));
            }
        }
        return errors;
    }
}

