/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.Challan;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.collection.utils.CollectionsNumberGenerator;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.collection.utils.FinancialsUtil;
import org.egov.commons.Bankaccount;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.EmployeeService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.contra.ContraJournalVoucher;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.model.instrument.InstrumentType;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

public class ReceiptHeaderService
extends PersistenceService<ReceiptHeader, Long> {
    private static final Logger LOGGER = Logger.getLogger(ReceiptHeaderService.class);
    private CollectionsUtil collectionsUtil;
    private CollectionsNumberGenerator collectionsNumberGenerator;
    private FinancialsUtil financialsUtil;
    private PersistenceService persistenceService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private EmployeeService employeeService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;

    public List<ReceiptHeader> findAllByStatusUserCounterService(String statusCode, Long positionId, Integer counterId, String serviceCode) {
        StringBuilder query = new StringBuilder("select receipt from org.egov.collection.entity.ReceiptHeader receipt where 1=1");
        boolean allStatuses = statusCode == null || statusCode.equals("ALL");
        boolean allCounters = counterId == null || counterId < 0;
        boolean allPositions = positionId == null || positionId.equals("ALL");
        boolean allServices = serviceCode == null || serviceCode.equals("ALL");
        int argCount = 0;
        argCount += allStatuses ? 0 : 1;
        argCount += allCounters ? 0 : 1;
        argCount += allPositions ? 0 : 1;
        Object[] arguments = new Object[argCount += allServices ? 0 : 1];
        argCount = 0;
        if (!allStatuses) {
            query.append(" and receipt.status.code = ?");
            arguments[argCount++] = statusCode;
        }
        if (!allPositions) {
            query.append(" and receipt.state.ownerPosition.id = ?");
            arguments[argCount++] = positionId;
        }
        if (!allCounters) {
            query.append(" and receipt.location.id = ?");
            arguments[argCount++] = counterId;
        }
        if (!allServices) {
            query.append(" and receipt.service.code = ?");
            arguments[argCount++] = serviceCode;
        }
        query.append(" order by receipt.createdDate desc");
        return this.findAllBy(query.toString(), arguments);
    }

    public List<String> generateInternalReferenceNo(ReceiptHeader entity) {
        CFinancialYear financialYear = this.collectionsUtil.getFinancialYearforDate(entity.getCreatedDate());
        CFinancialYear currentFinancialYear = this.collectionsUtil.getFinancialYearforDate(new Date());
        return this.collectionsNumberGenerator.generateInternalReferenceNumber(entity, financialYear, currentFinancialYear);
    }

    protected CVoucherHeader createVoucher(ReceiptHeader receiptHeader, Boolean receiptBulkUpload) {
        ReceiptMisc receiptMisc;
        HashMap<String, Object> headerdetails = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> accountCodeList = new ArrayList<HashMap<String, Object>>();
        ArrayList<HashMap<String, Object>> subledgerList = new ArrayList<HashMap<String, Object>>();
        String fundCode = null;
        String fundsourceCode = null;
        String departmentCode = null;
        Boolean isVoucherApproved = Boolean.FALSE;
        if (receiptHeader.getService().getIsVoucherApproved() != null) {
            isVoucherApproved = receiptHeader.getService().getIsVoucherApproved();
        }
        if ((receiptMisc = receiptHeader.getReceiptMisc()).getFund() != null) {
            fundCode = receiptMisc.getFund().getCode();
        }
        if (receiptMisc.getFundsource() != null) {
            fundsourceCode = receiptMisc.getFundsource().getCode();
        }
        if (receiptMisc.getDepartment() != null) {
            departmentCode = receiptMisc.getDepartment().getCode();
        }
        for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
            if (instrumentHeader.getInstrumentType().getType().equals("cash") || instrumentHeader.getInstrumentType().getType().equals("bankchallan")) {
                headerdetails.put("vouchername", "Other receipts");
                headerdetails.put("vouchertype", "Receipt");
                continue;
            }
            if (!instrumentHeader.getInstrumentType().getType().equals("cheque") && !instrumentHeader.getInstrumentType().getType().equals("dd") && !instrumentHeader.getInstrumentType().getType().equals("card") && !instrumentHeader.getInstrumentType().getType().equals("online")) continue;
            if (this.collectionsUtil.getAppConfigValue("Collection", "RECEIPTVOUCHERTYPEFORCHEQUEDDCARD").equals("Journal Voucher")) {
                headerdetails.put("vouchername", "JVGeneral");
                headerdetails.put("vouchertype", "Journal Voucher");
                continue;
            }
            headerdetails.put("vouchername", "Other receipts");
            headerdetails.put("vouchertype", "Receipt");
        }
        headerdetails.put("description", "Collection Module");
        if (receiptHeader.getVoucherDate() == null) {
            headerdetails.put("voucherdate", new Date());
        } else {
            headerdetails.put("voucherdate", receiptHeader.getVoucherDate());
        }
        if (receiptHeader.getVoucherNum() != null && !receiptHeader.getVoucherNum().equals("")) {
            headerdetails.put("vouchernumber", receiptHeader.getVoucherNum());
        }
        headerdetails.put("fundcode", fundCode);
        headerdetails.put("departmentcode", departmentCode);
        headerdetails.put("fundsourcecode", fundsourceCode);
        headerdetails.put("moduleid", "10");
        headerdetails.put("sourcepath", "/collection/receipts/receipt-viewReceipts.action?selectedReceipts=" + receiptHeader.getId());
        Set<Object> receiptDetailSet = new LinkedHashSet(0);
        receiptDetailSet = receiptHeader.getReceipttype() == 'B' ? this.aggregateDuplicateReceiptDetailObject(new ArrayList<ReceiptDetail>(receiptHeader.getReceiptDetails())) : receiptHeader.getReceiptDetails();
        for (ReceiptDetail receiptDetail : receiptDetailSet) {
            if (receiptDetail.getCramount().compareTo(BigDecimal.ZERO) == 0 && receiptDetail.getDramount().compareTo(BigDecimal.ZERO) == 0) continue;
            HashMap<String, Object> accountcodedetailsHashMap = new HashMap<String, Object>();
            accountcodedetailsHashMap.put("glcode", receiptDetail.getAccounthead().getGlcode());
            accountcodedetailsHashMap.put("debitamount", receiptDetail.getDramount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : receiptDetail.getDramount());
            accountcodedetailsHashMap.put("creditamount", receiptDetail.getCramount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : receiptDetail.getCramount());
            if (receiptDetail.getFunction() != null) {
                accountcodedetailsHashMap.put("functioncode", receiptDetail.getFunction().getCode());
            }
            accountCodeList.add(accountcodedetailsHashMap);
            for (AccountPayeeDetail accpayeeDetail : receiptDetail.getAccountPayeeDetails()) {
                if (accpayeeDetail.getAmount().compareTo(BigDecimal.ZERO) == 0) continue;
                HashMap<String, Object> subledgerdetailsHashMap = new HashMap<String, Object>();
                subledgerdetailsHashMap.put("glcode", accpayeeDetail.getReceiptDetail().getAccounthead().getGlcode());
                subledgerdetailsHashMap.put("detailtypeid", accpayeeDetail.getAccountDetailType().getId());
                subledgerdetailsHashMap.put("detailkeyid", accpayeeDetail.getAccountDetailKey().getDetailkey());
                if (accpayeeDetail.getReceiptDetail().getCramount().compareTo(BigDecimal.ZERO) != 0) {
                    subledgerdetailsHashMap.put("creditamount", accpayeeDetail.getAmount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : accpayeeDetail.getAmount());
                } else if (accpayeeDetail.getReceiptDetail().getDramount().compareTo(BigDecimal.ZERO) != 0) {
                    subledgerdetailsHashMap.put("debitamount", accpayeeDetail.getAmount().compareTo(BigDecimal.ZERO) == 0 ? Integer.valueOf(0) : accpayeeDetail.getAmount());
                }
                subledgerList.add(subledgerdetailsHashMap);
            }
        }
        return this.financialsUtil.createVoucher(headerdetails, accountCodeList, subledgerList, receiptBulkUpload, isVoucherApproved);
    }

    public CVoucherHeader createVoucherForReceipt(ReceiptHeader receiptHeader, Boolean receiptBulkUpload) throws ApplicationRuntimeException {
        CVoucherHeader voucherheader = null;
        boolean isParentReceiptInstrumentDeposited = false;
        if (receiptHeader.getReceiptHeader() != null) {
            for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptHeader().getReceiptInstrument()) {
                if (instrumentHeader.getInstrumentType().getType().equals("cash")) {
                    if (!instrumentHeader.getStatusId().getDescription().equals("Reconciled")) continue;
                    isParentReceiptInstrumentDeposited = true;
                    break;
                }
                if (!instrumentHeader.getStatusId().getDescription().equals("Deposited")) continue;
                isParentReceiptInstrumentDeposited = true;
                break;
            }
        }
        if ((receiptHeader.getReceiptHeader() == null || receiptHeader.getReceiptHeader() != null && !isParentReceiptInstrumentDeposited) && (voucherheader = this.createVoucher(receiptHeader, receiptBulkUpload)) != null) {
            ReceiptVoucher receiptVoucher = new ReceiptVoucher();
            receiptVoucher.setVoucherheader(voucherheader);
            receiptVoucher.setReceiptHeader(receiptHeader);
            receiptHeader.addReceiptVoucher(receiptVoucher);
        }
        LOGGER.debug((Object)("Created voucher for receipt : " + receiptHeader.getReceiptnumber()));
        return voucherheader;
    }

    public void createVouchers(ReceiptHeader receiptHeader, Boolean receiptBulkUpload) throws ApplicationRuntimeException {
        this.createVoucherForReceipt(receiptHeader, receiptBulkUpload);
    }

    public void startWorkflow(ReceiptHeader receiptHeader, Boolean receiptBulkUpload) throws ApplicationRuntimeException {
        if (receiptHeader.getState() == null) {
            Position position = null;
            if (!this.collectionsUtil.isEmployee(receiptHeader.getCreatedBy()).booleanValue()) {
                Department dept = this.departmentService.getDepartmentByName(this.collectionsUtil.getDepartmentForWorkFlow());
                Designation desgn = this.designationService.getDesignationByName(this.collectionsUtil.getDesignationForThirdPartyUser());
                position = this.collectionsUtil.getPositionByDeptDesgAndBoundary(dept, desgn, receiptHeader.getReceiptMisc().getBoundary());
            } else {
                position = this.collectionsUtil.getPositionOfUser(receiptHeader.getCreatedBy());
            }
            receiptHeader.transition().start().withSenderName(receiptHeader.getCreatedBy().getName()).withComments("Receipt Created").withStateValue("Receipt Created").withOwner(position).withDateInfo(new Date()).withNextAction("Submit for Approval");
        }
        LOGGER.debug((Object)"Workflow state transition complete");
        if (receiptBulkUpload.booleanValue()) {
            receiptHeader.transition().withSenderName(receiptHeader.getCreatedBy().getName()).withComments("Approval of Data Migration Receipt Complete").withStateValue("Approve").withOwner(this.collectionsUtil.getPositionOfUser(receiptHeader.getCreatedBy())).withDateInfo(new Date());
            receiptHeader.transition().end().withSenderName(receiptHeader.getCreatedBy().getName()).withComments("Data Migration Receipt Approved - Workflow ends").withStateValue("END").withOwner(this.collectionsUtil.getPositionOfUser(receiptHeader.getCreatedBy())).withDateInfo(new Date());
        }
    }

    public List<HashMap<String, Object>> findAllRemitanceDetails(String boundaryIdList) {
        ArrayList<HashMap<String, Object>> paramList = new ArrayList<HashMap<String, Object>>();
        String queryBuilder = "SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,to_char(ch.RECEIPTDATE, 'DD-MM-YYYY') AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt";
        String whereClauseBeforInstumentType = " where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and ";
        String whereClause = " AND ih.ID_STATUS=(select id from egw_status where moduletype='Instrument' and description='New') and ih.ISPAYCHEQUE='0' and ch.STATUS=(select id from egw_status where moduletype='ReceiptHeader' and code='APPROVED') ";
        String groupByClause = " group by to_char(ch.RECEIPTDATE, 'DD-MM-YYYY'),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code";
        String orderBy = " order by RECEIPTDATE";
        StringBuilder queryStringForCashChequeDDCard = new StringBuilder("SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,to_char(ch.RECEIPTDATE, 'DD-MM-YYYY') AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt,egeis_jurisdiction ujl where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and it.TYPE in ('cash','cheque','dd','card')  AND ih.ID_STATUS=(select id from egw_status where moduletype='Instrument' and description='New') and ih.ISPAYCHEQUE='0' and ch.STATUS=(select id from egw_status where moduletype='ReceiptHeader' and code='APPROVED') AND ch.CREATEDBY=ujl.employee and ujl.boundary in (" + boundaryIdList + ")" + " group by to_char(ch.RECEIPTDATE, 'DD-MM-YYYY'),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code");
        User citizenUser = this.collectionsUtil.getUserByUserName("9999999999");
        if (boundaryIdList != null && citizenUser != null) {
            String queryStringForOnline = " union SELECT sum(ih.instrumentamount) as INSTRUMENTMAOUNT,to_char(ch.RECEIPTDATE, 'DD-MM-YYYY') AS RECEIPTDATE,sd.NAME as SERVICENAME,it.TYPE as INSTRUMENTTYPE,fnd.name AS FUNDNAME,dpt.name AS DEPARTMENTNAME,fnd.code AS FUNDCODE,dpt.code AS DEPARTMENTCODE from EGCL_COLLECTIONHEADER ch,EGF_INSTRUMENTHEADER ih,EGCL_COLLECTIONINSTRUMENT ci,EGCL_SERVICEDETAILS sd,EGF_INSTRUMENTTYPE it,EGCL_COLLECTIONMIS cm,FUND fnd,EG_DEPARTMENT dpt where ch.id=cm.collectionheader AND fnd.id=cm.fund AND dpt.id=cm.department and ci.INSTRUMENTHEADER=ih.ID and ch.SERVICEDETAILS=sd.ID and ch.ID=ci.COLLECTIONHEADER and ih.INSTRUMENTTYPE=it.ID and it.TYPE='online' AND ih.ID_STATUS=(select id from egw_status where moduletype='Instrument' and description='New') and ih.ISPAYCHEQUE='0' and ch.STATUS=(select id from egw_status where moduletype='ReceiptHeader' and code='APPROVED') AND ch.CREATEDBY=" + citizenUser.getId() + " group by to_char(ch.RECEIPTDATE, 'DD-MM-YYYY'),sd.NAME,it.TYPE,fnd.name,dpt.name,fnd.code,dpt.code";
            queryStringForCashChequeDDCard.append(queryStringForOnline);
        }
        SQLQuery query = this.getSession().createSQLQuery(queryStringForCashChequeDDCard.toString() + " order by RECEIPTDATE");
        List queryResults = query.list();
        for (int i = 0; i < queryResults.size(); ++i) {
            Object[] arrayObjectInitialIndex = (Object[])queryResults.get(i);
            HashMap objHashMap = new HashMap();
            if (i == 0) {
                objHashMap.put("RECEIPTDATE", arrayObjectInitialIndex[1]);
                objHashMap.put("SERVICENAME", arrayObjectInitialIndex[2]);
                objHashMap.put("FUNDNAME", arrayObjectInitialIndex[4]);
                objHashMap.put("DEPARTMENTNAME", arrayObjectInitialIndex[5]);
                objHashMap.put("FUNDCODE", arrayObjectInitialIndex[6]);
                objHashMap.put("DEPARTMENTCODE", arrayObjectInitialIndex[7]);
                if (arrayObjectInitialIndex[3].equals("cash")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                }
                if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", arrayObjectInitialIndex[0]);
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                }
                if (arrayObjectInitialIndex[3].equals("card")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                }
                if (arrayObjectInitialIndex[3].equals("online")) {
                    objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                    objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                    objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                    objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                }
            } else {
                int checknew = this.checkIfMapObjectExist(paramList, arrayObjectInitialIndex);
                if (checknew == -1) {
                    objHashMap.put("RECEIPTDATE", arrayObjectInitialIndex[1]);
                    objHashMap.put("SERVICENAME", arrayObjectInitialIndex[2]);
                    objHashMap.put("FUNDNAME", arrayObjectInitialIndex[4]);
                    objHashMap.put("DEPARTMENTNAME", arrayObjectInitialIndex[5]);
                    objHashMap.put("FUNDCODE", arrayObjectInitialIndex[6]);
                    objHashMap.put("DEPARTMENTCODE", arrayObjectInitialIndex[7]);
                    if (arrayObjectInitialIndex[3].equals("cash")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                    }
                    if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                    }
                    if (arrayObjectInitialIndex[3].equals("card")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", "");
                    }
                    if (arrayObjectInitialIndex[3].equals("online")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", "");
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", "");
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", "");
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    }
                } else {
                    objHashMap = (HashMap)paramList.get(checknew);
                    paramList.remove(checknew);
                    if (arrayObjectInitialIndex[3].equals("cash")) {
                        objHashMap.put("SERVICETOTALCASHAMOUNT", arrayObjectInitialIndex[0]);
                    }
                    if (arrayObjectInitialIndex[3].equals("cheque") || arrayObjectInitialIndex[3].equals("dd")) {
                        BigDecimal existingAmount = BigDecimal.ZERO;
                        if (objHashMap.get("SERVICETOTALCHEQUEAMOUNT") != "") {
                            existingAmount = new BigDecimal(objHashMap.get("SERVICETOTALCHEQUEAMOUNT").toString());
                        }
                        existingAmount = existingAmount.add(new BigDecimal(arrayObjectInitialIndex[0].toString()));
                        objHashMap.put("SERVICETOTALCHEQUEAMOUNT", existingAmount);
                    }
                    if (arrayObjectInitialIndex[3].equals("card")) {
                        objHashMap.put("SERVICETOTALCARDPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    }
                    if (arrayObjectInitialIndex[3].equals("online")) {
                        objHashMap.put("SERVICETOTALONLINEPAYMENTAMOUNT", arrayObjectInitialIndex[0]);
                    }
                }
            }
            if (objHashMap.get("RECEIPTDATE") == null || objHashMap.get("SERVICENAME") == null) continue;
            paramList.add(objHashMap);
        }
        return paramList;
    }

    public int checkIfMapObjectExist(List<HashMap<String, Object>> paramList, Object[] arrayObjectInitialIndexTemp) {
        int check = -1;
        for (int m = 0; m < paramList.size(); ++m) {
            HashMap<String, Object> objHashMapTemp = paramList.get(m);
            if (arrayObjectInitialIndexTemp[1] == null || arrayObjectInitialIndexTemp[2] == null || !arrayObjectInitialIndexTemp[1].equals(objHashMapTemp.get("RECEIPTDATE")) || !arrayObjectInitialIndexTemp[2].equals(objHashMapTemp.get("SERVICENAME")) || !arrayObjectInitialIndexTemp[6].equals(objHashMapTemp.get("FUNDCODE")) || !arrayObjectInitialIndexTemp[7].equals(objHashMapTemp.get("DEPARTMENTCODE"))) continue;
            check = m;
            break;
        }
        return check;
    }

    public List createBankRemittance(String[] serviceNameArr, String[] totalCashAmount, String[] totalChequeAmount, String[] totalCardAmount, String[] totalOnlineAmount, String[] receiptDateArray, String[] fundCodeArray, String[] departmentCodeArray, Integer accountNumberId, Integer positionUser, String[] receiptNumberArray) {
        ArrayList<CVoucherHeader> newContraVoucherList = new ArrayList<CVoucherHeader>();
        ArrayList bankRemittanceList = new ArrayList();
        SimpleDateFormat dateFomatter = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
        Map<String, Object> instrumentDepositeMap = this.financialsUtil.prepareForUpdateInstrumentDepositSQL();
        String instrumentGlCodeQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE=";
        String receiptInstrumentQueryString = "select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ";
        String serviceNameCondition = "receipt.service.name=? ";
        String receiptDateCondition = "and to_char(receipt.createdDate,'dd-MM-yyyy')=? ";
        String instrumentStatusCondition = "and instruments.statusId.id=? ";
        String instrumentTypeCondition = "and instruments.instrumentType.type = ? ";
        String receiptFundCondition = "and receipt.receiptMisc.fund.code = ? ";
        String receiptDepartmentCondition = "and receipt.receiptMisc.department.code = ? ";
        String cashInHandQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cash'";
        String chequeInHandQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cheque'";
        String cardPaymentQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='card'";
        String onlinePaymentQueryString = "SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='online'";
        SQLQuery cashInHand = this.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cash'");
        SQLQuery chequeInHand = this.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='cheque'");
        SQLQuery cardPaymentAccount = this.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='card'");
        SQLQuery onlinePaymentAccount = this.getSession().createSQLQuery("SELECT COA.GLCODE FROM CHARTOFACCOUNTS COA,EGF_INSTRUMENTACCOUNTCODES IAC,EGF_INSTRUMENTTYPE IT WHERE IT.ID=IAC.TYPEID AND IAC.GLCODEID=COA.ID AND IT.TYPE='online'");
        String cashInHandGLCode = null;
        String chequeInHandGlcode = null;
        String cardPaymentGlCode = null;
        String onlinePaymentGlCode = null;
        String voucherWorkflowMsg = "Voucher Workflow Started";
        if (!cashInHand.list().isEmpty()) {
            cashInHandGLCode = cashInHand.list().get(0).toString();
        }
        if (!chequeInHand.list().isEmpty()) {
            chequeInHandGlcode = chequeInHand.list().get(0).toString();
        }
        if (!cardPaymentAccount.list().isEmpty()) {
            cardPaymentGlCode = cardPaymentAccount.list().get(0).toString();
        }
        if (!onlinePaymentAccount.list().isEmpty()) {
            onlinePaymentGlCode = onlinePaymentAccount.list().get(0).toString();
        }
        EgwStatus status = this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "New");
        Boolean voucherTypeForChequeDDCard = false;
        Boolean useReceiptDateAsContraVoucherDate = false;
        if (this.collectionsUtil.getAppConfigValue("Collection", "REMITTANCEVOUCHERTYPEFORCHEQUEDDCARD").equals("Receipt")) {
            voucherTypeForChequeDDCard = true;
        }
        if (this.collectionsUtil.getAppConfigValue("Collection", "USERECEIPTDATEFORCONTRA").equals("Y")) {
            useReceiptDateAsContraVoucherDate = true;
        }
        for (int i = 0; i < serviceNameArr.length; ++i) {
            HashMap<String, Object> accountcodedetailsCreditOnlineHashMap;
            ArrayList<HashMap<String, Object>> accountCodeOnlineList;
            List instrumentHeaderListOnline;
            StringBuilder onlineQueryBuilder;
            List receiptHeaders;
            Object statusDeposited;
            HashMap<String, Object> accountcodedetailsDebitHashMap;
            HashMap<String, Object> headerdetails;
            Object[] arguments;
            String serviceName = serviceNameArr[i].trim();
            Date voucherDate = new Date();
            if (useReceiptDateAsContraVoucherDate.booleanValue()) {
                try {
                    voucherDate = dateFomatter.parse(receiptDateArray[i]);
                }
                catch (ParseException exp) {
                    LOGGER.debug((Object)("Exception in parsing date  " + receiptDateArray[i] + " - " + exp.getMessage()));
                }
            }
            if (serviceName == null || serviceName.length() <= 0) continue;
            String serviceGLCodeQueryString = "select coa.glcode from BANKACCOUNT ba,CHARTOFACCOUNTS coa where ba.GLCODEID=coa.ID and ba.ID=" + accountNumberId;
            this.persistenceService.findByNamedQuery("getServicesByName", new Object[]{serviceName});
            Bankaccount depositedBankAccount = null;
            ServiceDetails serviceDetails = (ServiceDetails)this.persistenceService.findByNamedQuery("getServicesByName", new Object[]{serviceName});
            SQLQuery serviceGLCodeQuery = this.getSession().createSQLQuery(serviceGLCodeQueryString);
            String serviceGlCode = serviceGLCodeQuery.list().get(0).toString();
            ArrayList<HashMap<String, Object>> subledgerList = new ArrayList<HashMap<String, Object>>();
            if (totalCashAmount[i].trim() != null && totalCashAmount[i].trim().length() > 0 && cashInHandGLCode != null) {
                StringBuilder cashQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
                cashQueryBuilder.append("receipt.service.name=? ");
                cashQueryBuilder.append("and to_char(receipt.createdDate,'dd-MM-yyyy')=? ");
                cashQueryBuilder.append("and instruments.statusId.id=? ");
                cashQueryBuilder.append("and instruments.instrumentType.type = ? ");
                cashQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
                cashQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
                arguments = new Object[]{serviceName, receiptDateArray[i], status.getId(), "cash", fundCodeArray[i], departmentCodeArray[i]};
                List instrumentHeaderListCash = this.persistenceService.findAllBy(cashQueryBuilder.toString(), arguments);
                headerdetails = new HashMap<String, Object>();
                headerdetails.put("vouchername", "Pay in slip");
                headerdetails.put("vouchertype", "Contra");
                headerdetails.put("description", "Collection Module");
                headerdetails.put("voucherdate", voucherDate);
                headerdetails.put("fundcode", fundCodeArray[i]);
                headerdetails.put("departmentcode", departmentCodeArray[i]);
                headerdetails.put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
                headerdetails.put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
                headerdetails.put("moduleid", "10");
                headerdetails.put("moduleid", "10");
                ArrayList<HashMap<String, Object>> accountCodeCashList = new ArrayList<HashMap<String, Object>>();
                HashMap<String, Object> accountcodedetailsCreditCashHashMap = new HashMap<String, Object>();
                accountcodedetailsCreditCashHashMap.put("glcode", cashInHandGLCode);
                accountcodedetailsCreditCashHashMap.put("functioncode", null);
                accountcodedetailsCreditCashHashMap.put("creditamount", totalCashAmount[i]);
                accountcodedetailsCreditCashHashMap.put("debitamount", 0);
                accountCodeCashList.add(accountcodedetailsCreditCashHashMap);
                accountcodedetailsDebitHashMap = new HashMap<String, Object>();
                accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
                accountcodedetailsDebitHashMap.put("functioncode", null);
                accountcodedetailsDebitHashMap.put("creditamount", 0);
                accountcodedetailsDebitHashMap.put("debitamount", totalCashAmount[i]);
                accountCodeCashList.add(accountcodedetailsDebitHashMap);
                CVoucherHeader voucherHeaderCash = this.financialsUtil.createRemittanceVoucher(headerdetails, accountCodeCashList, subledgerList);
                newContraVoucherList.add(voucherHeaderCash);
                depositedBankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where chartofaccounts.glcode=?", new Object[]{serviceGlCode});
                if (voucherHeaderCash != null && voucherHeaderCash.getId() != null) {
                    this.createVoucherForCashRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListCash, voucherHeaderCash);
                } else {
                    statusDeposited = this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Deposited");
                    this.financialsUtil.updateInstrumentHeader(instrumentHeaderListCash, (EgwStatus)statusDeposited, depositedBankAccount);
                }
                for (InstrumentHeader instHead : instrumentHeaderListCash) {
                    receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                    bankRemittanceList.addAll(receiptHeaders);
                }
            }
            if (totalChequeAmount[i].trim() != null && totalChequeAmount[i].trim().length() > 0 && chequeInHandGlcode != null) {
                StringBuilder chequeQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
                chequeQueryBuilder.append("receipt.service.name=? ");
                chequeQueryBuilder.append("and to_char(receipt.createdDate,'dd-MM-yyyy')=? ");
                chequeQueryBuilder.append("and instruments.statusId.id=? ");
                chequeQueryBuilder.append("and instruments.instrumentType.type in ( ?, ?)");
                chequeQueryBuilder.append("and receipt.status.id=(select id from org.egov.commons.EgwStatus where moduletype=? and code=?) ");
                chequeQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
                chequeQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
                arguments = new Object[]{serviceName, receiptDateArray[i], status.getId(), "cheque", "dd", "ReceiptHeader", "APPROVED", fundCodeArray[i], departmentCodeArray[i]};
                List instrumentHeaderListCheque = this.persistenceService.findAllBy(chequeQueryBuilder.toString(), arguments);
                headerdetails = new HashMap();
                ArrayList<HashMap<String, Object>> accountCodeChequeList = new ArrayList<HashMap<String, Object>>();
                HashMap<String, Object> accountcodedetailsCreditChequeHashMap = new HashMap<String, Object>();
                if (voucherTypeForChequeDDCard.booleanValue()) {
                    headerdetails.put("vouchername", "Other receipts");
                    headerdetails.put("vouchertype", "Receipt");
                } else {
                    headerdetails.put("vouchername", "Pay in slip");
                    headerdetails.put("vouchertype", "Contra");
                }
                headerdetails.put("vouchername", "Pay in slip");
                headerdetails.put("vouchertype", "Contra");
                headerdetails.put("description", "Collection Module");
                headerdetails.put("voucherdate", voucherDate);
                headerdetails.put("fundcode", fundCodeArray[i]);
                headerdetails.put("departmentcode", departmentCodeArray[i]);
                headerdetails.put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
                headerdetails.put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
                headerdetails.put("moduleid", "10");
                accountcodedetailsCreditChequeHashMap.put("glcode", chequeInHandGlcode);
                accountcodedetailsCreditChequeHashMap.put("functioncode", null);
                accountcodedetailsCreditChequeHashMap.put("creditamount", totalChequeAmount[i]);
                accountcodedetailsCreditChequeHashMap.put("debitamount", 0);
                accountCodeChequeList.add(accountcodedetailsCreditChequeHashMap);
                accountcodedetailsDebitHashMap = new HashMap();
                accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
                accountcodedetailsDebitHashMap.put("functioncode", null);
                accountcodedetailsDebitHashMap.put("creditamount", 0);
                accountcodedetailsDebitHashMap.put("debitamount", totalChequeAmount[i]);
                accountCodeChequeList.add(accountcodedetailsDebitHashMap);
                CVoucherHeader voucherHeaderCheque = this.financialsUtil.createRemittanceVoucher(headerdetails, accountCodeChequeList, subledgerList);
                newContraVoucherList.add(voucherHeaderCheque);
                depositedBankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where chartofaccounts.glcode=?", new Object[]{serviceGlCode});
                if (voucherHeaderCheque != null && voucherHeaderCheque.getId() != null) {
                    this.createVoucherForChequeCardRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherTypeForChequeDDCard, voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListCheque, voucherHeaderCheque);
                } else {
                    statusDeposited = this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Deposited");
                    this.financialsUtil.updateInstrumentHeader(instrumentHeaderListCheque, (EgwStatus)statusDeposited, depositedBankAccount);
                }
                for (InstrumentHeader instHead : instrumentHeaderListCheque) {
                    receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                    bankRemittanceList.addAll(receiptHeaders);
                }
            }
            if (totalCardAmount[i].trim() != null && totalCardAmount[i].trim().length() > 0 && cardPaymentGlCode != null) {
                onlineQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
                onlineQueryBuilder.append("receipt.service.name=? ");
                onlineQueryBuilder.append("and to_char(receipt.createdDate,'dd-MM-yyyy')=? ");
                onlineQueryBuilder.append("and instruments.statusId.id=? ");
                onlineQueryBuilder.append("and instruments.instrumentType.type = ? ");
                onlineQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
                onlineQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
                arguments = new Object[]{serviceName, receiptDateArray[i], status.getId(), "card", fundCodeArray[i], departmentCodeArray[i]};
                instrumentHeaderListOnline = this.persistenceService.findAllBy(onlineQueryBuilder.toString(), arguments);
                headerdetails = new HashMap();
                if (voucherTypeForChequeDDCard.booleanValue()) {
                    headerdetails.put("vouchername", "Other receipts");
                    headerdetails.put("vouchertype", "Receipt");
                } else {
                    headerdetails.put("vouchername", "Pay in slip");
                    headerdetails.put("vouchertype", "Contra");
                }
                headerdetails.put("vouchername", "Pay in slip");
                headerdetails.put("vouchertype", "Contra");
                headerdetails.put("description", "Collection Module");
                headerdetails.put("voucherdate", voucherDate);
                headerdetails.put("fundcode", fundCodeArray[i]);
                headerdetails.put("departmentcode", departmentCodeArray[i]);
                headerdetails.put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
                headerdetails.put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
                headerdetails.put("moduleid", "10");
                accountCodeOnlineList = new ArrayList<HashMap<String, Object>>();
                accountcodedetailsCreditOnlineHashMap = new HashMap<String, Object>();
                accountcodedetailsCreditOnlineHashMap.put("glcode", cardPaymentGlCode);
                accountcodedetailsCreditOnlineHashMap.put("functioncode", null);
                accountcodedetailsCreditOnlineHashMap.put("creditamount", totalCardAmount[i]);
                accountcodedetailsCreditOnlineHashMap.put("debitamount", 0);
                accountCodeOnlineList.add(accountcodedetailsCreditOnlineHashMap);
                accountcodedetailsDebitHashMap = new HashMap();
                accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
                accountcodedetailsDebitHashMap.put("functioncode", null);
                accountcodedetailsDebitHashMap.put("creditamount", 0);
                accountcodedetailsDebitHashMap.put("debitamount", totalCardAmount[i]);
                accountCodeOnlineList.add(accountcodedetailsDebitHashMap);
                String createVoucher = this.collectionsUtil.getAppConfigValue("Collection", "CREATEVOUCHER_FOR_REMITTANCE");
                if ("Y".equalsIgnoreCase(createVoucher)) {
                    CVoucherHeader voucherHeaderCard = this.financialsUtil.createRemittanceVoucher(headerdetails, accountCodeOnlineList, subledgerList);
                    newContraVoucherList.add(voucherHeaderCard);
                    depositedBankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where chartofaccounts.glcode=?", new Object[]{serviceGlCode});
                    if (voucherHeaderCard != null && voucherHeaderCard.getId() != null) {
                        this.createVoucherForChequeCardRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherTypeForChequeDDCard, voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListOnline, voucherHeaderCard);
                    } else {
                        EgwStatus statusDeposited2 = this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Deposited");
                        this.financialsUtil.updateInstrumentHeader(instrumentHeaderListOnline, statusDeposited2, depositedBankAccount);
                    }
                    for (InstrumentHeader instHead : instrumentHeaderListOnline) {
                        List receiptHeaders2 = this.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                        bankRemittanceList.addAll(receiptHeaders2);
                    }
                }
            }
            if (totalOnlineAmount[i].trim() == null || totalOnlineAmount[i].trim().length() <= 0 || onlinePaymentGlCode == null) continue;
            onlineQueryBuilder = new StringBuilder("select DISTINCT (instruments) from org.egov.collection.entity.ReceiptHeader receipt join receipt.receiptInstrument as instruments where ");
            onlineQueryBuilder.append("receipt.service.name=? ");
            onlineQueryBuilder.append("and to_char(receipt.createdDate,'dd-MM-yyyy')=? ");
            onlineQueryBuilder.append("and instruments.statusId.id=? ");
            onlineQueryBuilder.append("and instruments.instrumentType.type = ? ");
            onlineQueryBuilder.append("and receipt.receiptMisc.fund.code = ? ");
            onlineQueryBuilder.append("and receipt.receiptMisc.department.code = ? ");
            arguments = new Object[]{serviceName, receiptDateArray[i], status.getId(), "online", fundCodeArray[i], departmentCodeArray[i]};
            instrumentHeaderListOnline = this.persistenceService.findAllBy(onlineQueryBuilder.toString(), arguments);
            headerdetails = new HashMap();
            if (voucherTypeForChequeDDCard.booleanValue()) {
                headerdetails.put("vouchername", "Other receipts");
                headerdetails.put("vouchertype", "Receipt");
            } else {
                headerdetails.put("vouchername", "Pay in slip");
                headerdetails.put("vouchertype", "Contra");
            }
            headerdetails.put("vouchername", "Pay in slip");
            headerdetails.put("vouchertype", "Contra");
            headerdetails.put("description", "Collection Module");
            headerdetails.put("voucherdate", voucherDate);
            headerdetails.put("fundcode", fundCodeArray[i]);
            headerdetails.put("departmentcode", departmentCodeArray[i]);
            headerdetails.put("fundsourcecode", serviceDetails.getFundSource() == null ? null : serviceDetails.getFundSource().getCode());
            headerdetails.put("functionarycode", serviceDetails.getFunctionary() == null ? null : serviceDetails.getFunctionary().getCode());
            headerdetails.put("moduleid", "10");
            accountCodeOnlineList = new ArrayList();
            accountcodedetailsCreditOnlineHashMap = new HashMap();
            accountcodedetailsCreditOnlineHashMap.put("glcode", onlinePaymentGlCode);
            accountcodedetailsCreditOnlineHashMap.put("functioncode", null);
            accountcodedetailsCreditOnlineHashMap.put("creditamount", totalOnlineAmount[i]);
            accountcodedetailsCreditOnlineHashMap.put("debitamount", 0);
            accountCodeOnlineList.add(accountcodedetailsCreditOnlineHashMap);
            accountcodedetailsDebitHashMap = new HashMap();
            accountcodedetailsDebitHashMap.put("glcode", serviceGlCode);
            accountcodedetailsDebitHashMap.put("functioncode", null);
            accountcodedetailsDebitHashMap.put("creditamount", 0);
            accountcodedetailsDebitHashMap.put("debitamount", totalOnlineAmount[i]);
            accountCodeOnlineList.add(accountcodedetailsDebitHashMap);
            CVoucherHeader voucherHeaderCard = this.financialsUtil.createRemittanceVoucher(headerdetails, accountCodeOnlineList, subledgerList);
            newContraVoucherList.add(voucherHeaderCard);
            depositedBankAccount = (Bankaccount)this.persistenceService.find("from Bankaccount where chartofaccounts.glcode=?", new Object[]{serviceGlCode});
            if (voucherHeaderCard != null && voucherHeaderCard.getId() != null) {
                this.createVoucherForChequeCardRemittance(instrumentDepositeMap, "Voucher Workflow Started", voucherTypeForChequeDDCard, voucherDate, depositedBankAccount, serviceGlCode, instrumentHeaderListOnline, voucherHeaderCard);
            } else {
                statusDeposited = this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Deposited");
                this.financialsUtil.updateInstrumentHeader(instrumentHeaderListOnline, (EgwStatus)statusDeposited, depositedBankAccount);
            }
            for (InstrumentHeader instHead : instrumentHeaderListOnline) {
                receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTHEADER_AND_SERVICECODE", new Object[]{instHead.getId(), serviceDetails.getCode()});
                bankRemittanceList.addAll(receiptHeaders);
            }
        }
        for (ReceiptHeader receiptHeader : bankRemittanceList) {
            EgwStatus statusRemitted = this.egwStatusDAO.getStatusByModuleAndCode("ReceiptHeader", "REMITTED");
            receiptHeader.setStatus(statusRemitted);
            this.getSession().flush();
            this.persistenceService.update((Object)receiptHeader);
        }
        return bankRemittanceList;
    }

    private void createVoucherForChequeCardRemittance(Map<String, Object> instrumentDepositeMap, String voucherWorkflowMsg, Boolean voucherTypeForChequeDDCard, Date voucherDate, Bankaccount depositedBankAccount, String serviceGlCode, List<InstrumentHeader> instrumentHeaderListCheque, CVoucherHeader voucherHeaderCheque) {
        for (InstrumentHeader instrumentHeader : instrumentHeaderListCheque) {
            if (voucherHeaderCheque.getId() == null || serviceGlCode == null) continue;
            Map<String, Object> chequeMap = this.constructInstrumentMap(instrumentDepositeMap, depositedBankAccount, instrumentHeader, voucherHeaderCheque, voucherDate);
            if (voucherTypeForChequeDDCard.booleanValue()) {
                this.financialsUtil.updateCheque_DD_Card_Deposit_Receipt(voucherHeaderCheque.getId(), serviceGlCode, instrumentHeader, chequeMap);
                continue;
            }
            this.financialsUtil.updateCheque_DD_Card_Deposit(voucherHeaderCheque.getId(), serviceGlCode, instrumentHeader, chequeMap);
            ContraJournalVoucher contraJournalVoucher = (ContraJournalVoucher)this.persistenceService.findByNamedQuery("getContraVoucherbyVoucherHeaderId", new Object[]{voucherHeaderCheque.getId(), instrumentHeader.getId()});
            contraJournalVoucher.transition(true).start().withSenderName(contraJournalVoucher.getCreatedBy().getName()).withComments("NEW").withOwner(this.collectionsUtil.getPositionOfUser(contraJournalVoucher.getCreatedBy()));
            contraJournalVoucher.transition(true).withSenderName(contraJournalVoucher.getCreatedBy().getName()).withComments(voucherWorkflowMsg).withOwner(this.collectionsUtil.getPositionOfUser(contraJournalVoucher.getCreatedBy()));
        }
    }

    private void createVoucherForCashRemittance(Map<String, Object> instrumentDepositeMap, String voucherWorkflowMsg, Date voucherDate, Bankaccount depositedBankAccount, String serviceGlCode, List<InstrumentHeader> instrumentHeaderListCash, CVoucherHeader voucherHeaderCash) {
        for (InstrumentHeader instrumentHeader : instrumentHeaderListCash) {
            if (voucherHeaderCash.getId() == null || serviceGlCode == null) continue;
            Map<String, Object> cashMap = this.constructInstrumentMap(instrumentDepositeMap, depositedBankAccount, instrumentHeader, voucherHeaderCash, voucherDate);
            this.financialsUtil.updateCashDeposit(voucherHeaderCash.getId(), serviceGlCode, instrumentHeader, cashMap);
            ContraJournalVoucher contraJournalVoucher = (ContraJournalVoucher)this.persistenceService.findByNamedQuery("getContraVoucherbyVoucherHeaderId", new Object[]{voucherHeaderCash.getId(), instrumentHeader.getId()});
            contraJournalVoucher.transition(true).start().withSenderName(contraJournalVoucher.getCreatedBy().getName()).withComments("Voucher Created").withOwner(this.collectionsUtil.getPositionOfUser(contraJournalVoucher.getCreatedBy()));
            contraJournalVoucher.transition(true).transition().withSenderName(contraJournalVoucher.getCreatedBy().getName()).withComments(voucherWorkflowMsg).withOwner(this.collectionsUtil.getPositionOfUser(contraJournalVoucher.getCreatedBy()));
        }
    }

    public Set<ReceiptDetail> aggregateDuplicateReceiptDetailObject(List<ReceiptDetail> receiptDetailSetParam) {
        ArrayList<ReceiptDetail> newReceiptDetailList = new ArrayList<ReceiptDetail>();
        int counter = 0;
        for (ReceiptDetail receiptDetailObj : receiptDetailSetParam) {
            if (counter == 0) {
                newReceiptDetailList.add(receiptDetailObj);
            } else {
                int checknew = this.checkIfReceiptDetailObjectExist(newReceiptDetailList, receiptDetailObj);
                if (checknew == -1) {
                    newReceiptDetailList.add(receiptDetailObj);
                } else {
                    ReceiptDetail receiptDetail = new ReceiptDetail();
                    ReceiptDetail newReceiptDetailObj = (ReceiptDetail)newReceiptDetailList.get(checknew);
                    newReceiptDetailList.remove(checknew);
                    receiptDetail.setAccounthead(newReceiptDetailObj.getAccounthead());
                    receiptDetail.setAccountPayeeDetails(newReceiptDetailObj.getAccountPayeeDetails());
                    receiptDetail.setCramount(newReceiptDetailObj.getCramount().add(receiptDetailObj.getCramount()));
                    receiptDetail.setCramountToBePaid(newReceiptDetailObj.getCramountToBePaid());
                    receiptDetail.setDescription(newReceiptDetailObj.getDescription());
                    receiptDetail.setDramount(newReceiptDetailObj.getDramount().add(receiptDetailObj.getDramount()));
                    receiptDetail.setFinancialYear(newReceiptDetailObj.getFinancialYear());
                    receiptDetail.setFunction(newReceiptDetailObj.getFunction());
                    receiptDetail.setOrdernumber(newReceiptDetailObj.getOrdernumber());
                    newReceiptDetailList.add(receiptDetail);
                }
            }
            ++counter;
        }
        return new HashSet<ReceiptDetail>(newReceiptDetailList);
    }

    public int checkIfReceiptDetailObjectExist(List<ReceiptDetail> newReceiptDetailSet, ReceiptDetail receiptDetailObj) {
        int check = -1;
        for (int m = 0; m < newReceiptDetailSet.size(); ++m) {
            ReceiptDetail receiptDetail = newReceiptDetailSet.get(m);
            if (!receiptDetailObj.getAccounthead().getId().equals(receiptDetail.getAccounthead().getId())) continue;
            check = m;
            break;
        }
        return check;
    }

    public void endReceiptWorkFlowOnCancellation(ReceiptHeader receiptHeaderToBeCancelled) {
        Position position = null;
        if (!this.collectionsUtil.isEmployee(receiptHeaderToBeCancelled.getCreatedBy()).booleanValue()) {
            Department dept = this.departmentService.getDepartmentByName(this.collectionsUtil.getDepartmentForWorkFlow());
            Designation desgn = this.designationService.getDesignationByName(this.collectionsUtil.getDesignationForThirdPartyUser());
            position = this.collectionsUtil.getPositionByDeptDesgAndBoundary(dept, desgn, receiptHeaderToBeCancelled.getReceiptMisc().getBoundary());
        } else {
            position = this.collectionsUtil.getPositionOfUser(receiptHeaderToBeCancelled.getCreatedBy());
        }
        if (position != null) {
            receiptHeaderToBeCancelled.transition(true).end().withSenderName(receiptHeaderToBeCancelled.getCreatedBy().getName()).withComments("Receipt Cancelled - Workflow ends").withStateValue("END").withOwner(position).withDateInfo(new Date());
        }
    }

    public ReceiptHeader persist(ReceiptHeader receiptHeader) {
        if (receiptHeader.getReceipttype() != 'C' && !"PENDING".equals(receiptHeader.getStatus().getCode()) && receiptHeader.getReceiptnumber() == null) {
            this.setReceiptNumber(receiptHeader);
        }
        if (receiptHeader.getChallan() != null) {
            Challan challan = receiptHeader.getChallan();
            if (challan.getChallanNumber() == null) {
                this.setChallanNumber(challan);
            }
            receiptHeader.setChallan(challan);
            LOGGER.info((Object)("Persisted challan with challan number " + challan.getChallanNumber()));
        }
        return (ReceiptHeader)((Object)super.persist((Object)receiptHeader));
    }

    public ReceiptHeader persistChallan(ReceiptHeader entity) {
        for (ReceiptHeader receiptHeader : entity.getReceiptHeaders()) {
            Integer.valueOf(this.collectionsUtil.getAppConfigValue("Collection", "CHALLANVALIDUPTO"));
            Challan challan = receiptHeader.getChallan();
            if (challan.getCreatedDate() == null) {
                challan.setCreatedDate(new Date());
            }
            if (challan.getChallanNumber() == null) {
                this.setChallanNumber(challan);
            }
            challan.setReceiptHeader(receiptHeader);
            receiptHeader.setChallan(challan);
            LOGGER.info((Object)("Persisting challan with challan number " + challan.getChallanNumber()));
        }
        return (ReceiptHeader)((Object)super.persist((Object)entity));
    }

    public List<ReceiptHeader> persist(Set<ReceiptHeader> entity) {
        ArrayList<ReceiptHeader> saved = new ArrayList<ReceiptHeader>();
        for (ReceiptHeader rpd : entity) {
            saved.add(this.persist(rpd));
        }
        return saved;
    }

    public List<ReceiptHeader> persistPendingReceipts(ReceiptHeader receiptHeader) {
        ArrayList<ReceiptHeader> saved = new ArrayList<ReceiptHeader>();
        saved.add((ReceiptHeader)((Object)super.persist((Object)receiptHeader)));
        return saved;
    }

    public void setReceiptNumber(ReceiptHeader entity) {
        entity.setReceiptnumber(this.collectionsNumberGenerator.generateReceiptNumber(entity));
    }

    private void setChallanNumber(Challan challan) {
        CFinancialYear financialYear = this.collectionsUtil.getFinancialYearforDate(challan.getCreatedDate());
        challan.setChallanNumber(this.collectionsNumberGenerator.generateChallanNumber(challan, financialYear));
    }

    public void setCollectionsNumberGenerator(CollectionsNumberGenerator collectionsNumberGenerator) {
        this.collectionsNumberGenerator = collectionsNumberGenerator;
    }

    private BillingIntegrationService getBillingServiceBean(String serviceCode) {
        return (BillingIntegrationService)this.collectionsUtil.getBean(serviceCode + "CollectionsInterface");
    }

    public Boolean updateBillingSystem(String serviceCode, Set<BillReceiptInfo> billReceipts) {
        BillingIntegrationService billingService = this.getBillingServiceBean(serviceCode);
        if (billingService == null) {
            return false;
        }
        try {
            billingService.updateReceiptDetails(billReceipts);
            return true;
        }
        catch (Exception e) {
            String errMsg = "Exception while updating billing system [" + serviceCode + "] with receipt details!";
            LOGGER.error((Object)errMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errMsg, (Throwable)e);
        }
    }

    public void createReversalVoucher(ReceiptVoucher receiptVoucher, String instrumentType) {
        ArrayList<HashMap<String, Object>> reversalVoucherInfoList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> reversalVoucherInfo = new HashMap<String, Object>();
        if (receiptVoucher.getVoucherheader() != null) {
            reversalVoucherInfo.put("Original voucher header id", receiptVoucher.getVoucherheader().getId());
            reversalVoucherInfo.put("Reversal voucher date", new Date());
            if (receiptVoucher.getVoucherheader().getType().equals("Journal Voucher")) {
                reversalVoucherInfo.put("Reversal voucher type", "Journal Voucher");
                reversalVoucherInfo.put("Reversal voucher name", "JVGeneral");
            } else if (receiptVoucher.getVoucherheader().getType().equals("Receipt")) {
                reversalVoucherInfo.put("Reversal voucher type", "Payment");
                reversalVoucherInfo.put("Reversal voucher name", "Direct Bank Payment");
            }
        }
        reversalVoucherInfoList.add(reversalVoucherInfo);
        try {
            this.financialsUtil.getReversalVoucher(reversalVoucherInfoList);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Receipt Service Exception while creating reversal voucher!", (Throwable)e);
        }
    }

    public void updateInstrument(List<CVoucherHeader> voucherHeaderList, List<InstrumentHeader> instrumentHeaderList) {
        ArrayList<Map<String, Object>> instrumentVoucherList = new ArrayList<Map<String, Object>>();
        if (voucherHeaderList != null && instrumentHeaderList != null) {
            for (CVoucherHeader voucherHeader : voucherHeaderList) {
                for (InstrumentHeader instrumentHeader : instrumentHeaderList) {
                    HashMap<String, Object> iVoucherMap = new HashMap<String, Object>();
                    iVoucherMap.put("Instrument header", instrumentHeader);
                    iVoucherMap.put("Voucher header", voucherHeader);
                    instrumentVoucherList.add(iVoucherMap);
                }
            }
            this.financialsUtil.updateInstrument(instrumentVoucherList);
        }
    }

    public List<InstrumentHeader> createInstrument(List<InstrumentHeader> instrumentHeaderList) {
        ArrayList<Map<String, Object>> instrumentHeaderMapList = new ArrayList<Map<String, Object>>();
        if (instrumentHeaderList != null) {
            for (InstrumentHeader instrumentHeader : instrumentHeaderList) {
                HashMap<String, Object> instrumentHeaderMap = new HashMap<String, Object>();
                instrumentHeaderMap.put("Instrument number", instrumentHeader.getInstrumentNumber());
                instrumentHeaderMap.put("Instrument date", instrumentHeader.getInstrumentDate());
                instrumentHeaderMap.put("Instrument amount", instrumentHeader.getInstrumentAmount());
                instrumentHeaderMap.put("Instrument type", instrumentHeader.getInstrumentType().getType());
                instrumentHeaderMap.put("Is pay cheque", instrumentHeader.getIsPayCheque());
                if (instrumentHeader.getBankId() != null) {
                    instrumentHeaderMap.put("Bank code", instrumentHeader.getBankId().getCode());
                }
                instrumentHeaderMap.put("Bank branch name", instrumentHeader.getBankBranchName());
                instrumentHeaderMap.put("Transaction number", instrumentHeader.getTransactionNumber());
                instrumentHeaderMap.put("Transaction date", instrumentHeader.getTransactionDate());
                if (instrumentHeader.getBankAccountId() != null) {
                    instrumentHeaderMap.put("Bank account id", instrumentHeader.getBankAccountId().getId());
                }
                instrumentHeaderMapList.add(instrumentHeaderMap);
            }
        }
        return this.financialsUtil.createInstrument(instrumentHeaderMapList);
    }

    private Map<String, Object> constructInstrumentMap(Map<String, Object> instrumentDepositeMap, Bankaccount bankaccount, InstrumentHeader instrumentHeader, CVoucherHeader voucherHeader, Date voucherDate) {
        InstrumentType instrumentType = (InstrumentType)this.persistenceService.find("select it from InstrumentType it,InstrumentHeader ih where ih.instrumentType=it.id and ih.id=?", new Object[]{instrumentHeader.getId()});
        instrumentDepositeMap.put("instrumentheader", instrumentHeader.getId());
        instrumentDepositeMap.put("bankaccountid", bankaccount.getId());
        instrumentDepositeMap.put("instrumentamount", instrumentHeader.getInstrumentAmount());
        instrumentDepositeMap.put("instrumenttype", instrumentType.getType());
        instrumentDepositeMap.put("depositdate", voucherDate);
        instrumentDepositeMap.put("createdby", voucherHeader.getCreatedBy().getId());
        instrumentDepositeMap.put("ispaycheque", instrumentHeader.getIsPayCheque());
        instrumentDepositeMap.put("payinid", voucherHeader.getId());
        return instrumentDepositeMap;
    }

    public void performWorkflow(String actionName, ReceiptHeader receiptHeader, String remarks) {
        try {
            Position operatorPosition;
            Department department;
            Employee employee = null;
            Boolean isEmployee = this.collectionsUtil.isEmployee(receiptHeader.getCreatedBy());
            if (!isEmployee.booleanValue()) {
                department = this.departmentService.getDepartmentByName(this.collectionsUtil.getDepartmentForWorkFlow());
                Designation desgn = this.designationService.getDesignationByName(this.collectionsUtil.getDesignationForThirdPartyUser());
                employee = this.employeeService.getEmployeeById(this.collectionsUtil.getLoggedInUser().getId());
                operatorPosition = this.collectionsUtil.getPositionByDeptDesgAndBoundary(department, desgn, receiptHeader.getReceiptMisc().getBoundary());
            } else {
                operatorPosition = this.collectionsUtil.getPositionOfUser(receiptHeader.getCreatedBy());
                department = this.collectionsUtil.getDepartmentOfUser(receiptHeader.getCreatedBy());
                employee = this.employeeService.getEmployeeById(receiptHeader.getCreatedBy().getId());
            }
            Designation designation = this.designationService.getDesignationByName("Section manager");
            Boundary boundary = null;
            for (Jurisdiction jur : employee.getJurisdictions()) {
                boundary = jur.getBoundary();
            }
            List emp = this.employeeService.findByDepartmentDesignationAndBoundary(department.getId(), designation.getId(), boundary.getId());
            Position approverPosition = this.collectionsUtil.getPositionOfUser((User)emp.get(0));
            System.out.println(approverPosition.getName());
            if (actionName.equals("Submit for Approval")) {
                this.perform(receiptHeader, "Approve", "SUBMITTED", "Approve", approverPosition, remarks);
            } else if (actionName.equals("Approve")) {
                this.perform(receiptHeader, "Approved", "APPROVED", "", approverPosition, remarks);
            } else if (actionName.equals("Reject")) {
                this.perform(receiptHeader, "Rejected", "TO_BE_SUBMITTED", "Submit for Approval", operatorPosition, remarks);
            }
        }
        catch (ValidationException e) {
            LOGGER.error((Object)"Receipt Service Exception while workflow transition!", (Throwable)e);
        }
    }

    public void perform(ReceiptHeader receiptHeader, String wfState, String newStatusCode, String nextAction, Position ownerPosition, String remarks) {
        receiptHeader.setStatus(this.collectionsUtil.getReceiptStatusForCode(newStatusCode));
        if (receiptHeader.getStatus().getCode().equals("APPROVED")) {
            receiptHeader.transition().end().withSenderName(receiptHeader.getCreatedBy().getName()).withComments("Receipt Approved - Workflow ends").withStateValue("END").withOwner(ownerPosition).withDateInfo(new Date());
        } else {
            receiptHeader.transition().withSenderName(receiptHeader.getCreatedBy().getName()).withComments(remarks).withStateValue(wfState).withOwner(ownerPosition).withDateInfo(new Date()).withNextAction(nextAction);
        }
        this.getSession().flush();
        this.persistenceService.persist((Object)receiptHeader);
    }

    public Set<InstrumentHeader> createOnlineInstrument(Date transactionDate, String transactionId, BigDecimal transactionAmt) {
        InstrumentHeader onlineInstrumentHeader = new InstrumentHeader();
        HashSet<InstrumentHeader> instrumentHeaderSet = new HashSet();
        onlineInstrumentHeader.setInstrumentType(this.financialsUtil.getInstrumentTypeByType("online"));
        onlineInstrumentHeader.setTransactionDate(transactionDate);
        onlineInstrumentHeader.setIsPayCheque("0");
        onlineInstrumentHeader.setTransactionNumber(transactionId);
        onlineInstrumentHeader.setInstrumentAmount(transactionAmt);
        ArrayList<InstrumentHeader> instHeaderList = new ArrayList<InstrumentHeader>();
        instHeaderList.add(onlineInstrumentHeader);
        instrumentHeaderSet = new HashSet<InstrumentHeader>(this.createInstrument(instHeaderList));
        return instrumentHeaderSet;
    }

    public String getReceiptHeaderforDishonor(Long mode, Long bankAccId, Long bankId, String chequeDDNo, String chqueDDDate) {
        StringBuilder sb = new StringBuilder(300);
        new ArrayList();
        sb.append("FROM egcl_collectionheader rpt,egcl_collectioninstrument ci,egf_instrumentheader ih,egw_status status,bank b,bankbranch bb,bankaccount ba WHERE rpt.id = ci.collectionheader AND ci.instrumentheader = ih.id AND status.id = ih.id_status AND b.id = bb.bankid AND bb.id = ba.branchid AND ba.id = ih.bankaccountid AND ih.instrumenttype = '" + mode + "' AND ((ih.ispaycheque ='0' AND status.moduletype ='" + "Instrument" + "'" + "AND status.description = '" + "Deposited" + "'))");
        if (bankAccId != null && bankAccId != 0L) {
            sb.append(" AND ih.bankaccountid=" + bankAccId + "");
        }
        if ((bankAccId == null || bankAccId == 0L) && bankId != null && bankId != 0L) {
            sb.append(" AND ih.bankid=" + bankAccId + "");
        }
        if (!"".equals(chequeDDNo) && chequeDDNo != null) {
            sb.append(" AND ih.instrumentnumber=trim('" + chequeDDNo + "') ");
        }
        if (!"".equals(chqueDDDate) && chqueDDDate != null) {
            sb.append(" AND ih.instrumentdate >= '" + chqueDDDate + "' ");
        }
        return sb.toString();
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setFinancialsUtil(FinancialsUtil financialsUtil) {
        this.financialsUtil = financialsUtil;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }
}

