/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.service;

import java.util.Date;
import org.apache.log4j.Logger;
import org.egov.collection.entity.Challan;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public class ChallanService
extends PersistenceService<Challan, Long> {
    private static final Logger LOGGER = Logger.getLogger(ChallanService.class);
    @Autowired
    private CollectionsUtil collectionsUtil;

    public void workflowtransition(Challan challan, Position nextPosition, String actionName, String remarks) throws ApplicationRuntimeException {
        if (challan.getState() == null) {
            challan.transition().start().withSenderName(challan.getCreatedBy().getName()).withComments("Challan Workflow Started").withStateValue("NEW").withOwner(this.collectionsUtil.getPositionOfUser(challan.getCreatedBy())).withDateInfo(new Date());
            LOGGER.debug((Object)"Challan Workflow Started.");
        }
        if ("CHALLAN_NEW".equals(actionName) || "CHALLAN_MODIFY".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getEgwStatusForModuleAndCode("Challan", "CREATED"));
            challan.transition(true).withComments("Challan created").withStateValue("CREATED").withSenderName(challan.getCreatedBy().getName()).withDateInfo(new Date()).transition();
        }
        if ("CHALLAN_APPROVE".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getEgwStatusForModuleAndCode("Challan", "APPROVED"));
            challan.transition(true).withComments(remarks).withStateValue("APPROVED").withSenderName(challan.getCreatedBy().getName()).withDateInfo(new Date()).transition();
        }
        if ("CHALLAN_REJECT".equals(actionName)) {
            this.collectionsUtil.getPositionOfUser(challan.getCreatedBy());
            challan.setStatus(this.collectionsUtil.getEgwStatusForModuleAndCode("Challan", "REJECTED"));
            challan.transition(true).withComments(remarks).withStateValue("REJECTED").withSenderName(challan.getCreatedBy().getName()).withDateInfo(new Date()).transition();
        }
        if ("CHALLAN_CANCEL".equals(actionName)) {
            challan.setStatus(this.collectionsUtil.getEgwStatusForModuleAndCode("Challan", "CANCELLED"));
            challan.transition(true).withComments(remarks).withStateValue("CANCELLED").withSenderName(challan.getCreatedBy().getName()).withDateInfo(new Date()).transition();
        }
        this.persist((Object)challan);
        LOGGER.debug((Object)("Challan workflow transition completed. Challan transitioned to : " + challan.getCurrentState().getValue()));
        if ("CHALLAN_CANCEL".equals(actionName) || "CHALLAN_VALIDATE".equals(actionName)) {
            challan.transition(true).withComments("End of challan worklow").withStateValue("END").withSenderName(challan.getCreatedBy().getName()).withDateInfo(new Date()).end();
            LOGGER.debug((Object)"End of Challan Workflow.");
        }
    }

    public CollectionsUtil getCollectionsUtil() {
        return this.collectionsUtil;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }
}

