/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.scheduler;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.scheduler.quartz.AbstractQuartzJob;
import org.egov.infstr.services.PersistenceService;
import org.egov.infstr.utils.DateUtils;
import org.egov.services.instrument.InstrumentService;
import org.springframework.beans.factory.annotation.Autowired;

public class UpdateDishonoredInstrumentsJob
extends AbstractQuartzJob {
    private static final Logger LOGGER = Logger.getLogger(UpdateDishonoredInstrumentsJob.class);
    private static final long serialVersionUID = 1L;
    protected PersistenceService persistenceService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ReceiptHeaderService receiptHeaderService;
    private final Set<BillReceiptInfo> billReceipts = new HashSet<BillReceiptInfo>();
    private final CollectionsUtil collectionsUtil = new CollectionsUtil();
    private boolean testMode = false;

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.collectionsUtil.setPersistenceService(persistenceService);
    }

    public void setInstrumentService(InstrumentService instrumentService) {
    }

    public void executeJob() {
        this.processDishonoredInstruments();
    }

    public void processDishonoredInstruments() {
        LOGGER.debug((Object)"Started batch update process");
        Date bouncedToDate = new Date();
        Date bouncedFromDate = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
            String strDate = sdf.format(bouncedToDate);
            bouncedToDate = sdf.parse(strDate);
            bouncedToDate = DateUtils.add((Date)bouncedToDate, (int)5, (int)1);
            AppConfigValues appData = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Collections", "BOUNCEDINSTRUPDATE_RECONDATE").get(0);
            bouncedFromDate = sdf.parse(appData.getValue());
            bouncedFromDate = DateUtils.add((Date)bouncedFromDate, (int)5, (int)-1);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Exception occured : " + e.getMessage()));
        }
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }
}

