/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.collection.integration.services.BillingIntegrationService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.springframework.beans.factory.annotation.Autowired;

public class ReconciliationService {
    private static final Logger LOGGER = Logger.getLogger(ReconciliationService.class);
    public ReceiptHeaderService receiptHeaderService;
    private CollectionsUtil collectionsUtil;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;
    private CollectionCommon collectionCommon;

    public void processSuccessMsg(ReceiptHeader onlinePaymentReceiptHeader, PaymentResponse paymentResponse) {
        BillingIntegrationService billingService = this.collectionsUtil.getBillingService(onlinePaymentReceiptHeader.getService().getCode());
        onlinePaymentReceiptHeader.getReceiptDetails().clear();
        this.receiptHeaderService.persist(onlinePaymentReceiptHeader);
        this.receiptHeaderService.getSession().flush();
        List<ReceiptDetail> receiptDetailList = billingService.reconstructReceiptDetail(onlinePaymentReceiptHeader.getReferencenumber(), onlinePaymentReceiptHeader.getTotalAmount());
        if (receiptDetailList != null) {
            LOGGER.debug((Object)("Reconstructed receiptDetailList : " + receiptDetailList.toString()));
            for (ReceiptDetail receiptDetail : receiptDetailList) {
                receiptDetail.setReceiptHeader(onlinePaymentReceiptHeader);
                onlinePaymentReceiptHeader.addReceiptDetail(receiptDetail);
            }
        }
        onlinePaymentReceiptHeader.addReceiptDetail(this.collectionCommon.addDebitAccountHeadDetails(onlinePaymentReceiptHeader.getTotalAmount(), onlinePaymentReceiptHeader, BigDecimal.ZERO, onlinePaymentReceiptHeader.getTotalAmount(), "online"));
        this.createSuccessPayment(onlinePaymentReceiptHeader, paymentResponse.getTxnDate(), paymentResponse.getTxnReferenceNo(), paymentResponse.getAuthStatus(), null);
        LOGGER.debug((Object)"Persisted receipt after receiving success message from the payment gateway");
        boolean updateToSystems = true;
        try {
            this.receiptHeaderService.createVoucherForReceipt(onlinePaymentReceiptHeader, Boolean.FALSE);
            LOGGER.debug((Object)"Updated financial systems and created voucher.");
        }
        catch (ApplicationRuntimeException ex) {
            updateToSystems = false;
            onlinePaymentReceiptHeader.getOnlinePayment().setRemarks("Update to financial systems failed");
            LOGGER.error((Object)"Update to financial systems failed");
        }
        try {
            if (!this.updateBillingSystem(onlinePaymentReceiptHeader.getService().getCode(), new BillReceiptInfoImpl(onlinePaymentReceiptHeader), billingService).booleanValue()) {
                updateToSystems = false;
            }
        }
        catch (ApplicationRuntimeException ex) {
            onlinePaymentReceiptHeader.getOnlinePayment().setRemarks("update to billing system failed.");
        }
        if (updateToSystems) {
            onlinePaymentReceiptHeader.setIsReconciled(true);
            this.receiptHeaderService.persist(onlinePaymentReceiptHeader);
            this.receiptHeaderService.getSession().flush();
            LOGGER.debug((Object)("Updated billing system : " + onlinePaymentReceiptHeader.getService().getName()));
        } else {
            LOGGER.debug((Object)"Rolling back receipt creation transaction as update to billing system/financials failed.");
        }
    }

    private void createSuccessPayment(ReceiptHeader receipt, Date transactionDate, String transactionId, String authStatusCode, String remarks) {
        EgwStatus receiptStatus = this.collectionsUtil.getReceiptStatusForCode("APPROVED");
        receipt.setStatus(receiptStatus);
        receipt.setReceiptInstrument(this.receiptHeaderService.createOnlineInstrument(transactionDate, transactionId, receipt.getTotalAmount()));
        this.receiptHeaderService.setReceiptNumber(receipt);
        receipt.setIsReconciled(Boolean.FALSE);
        receipt.getOnlinePayment().setAuthorisationStatusCode(authStatusCode);
        receipt.getOnlinePayment().setTransactionNumber(transactionId);
        receipt.getOnlinePayment().setTransactionDate(transactionDate);
        receipt.getOnlinePayment().setRemarks(remarks);
        receipt.getOnlinePayment().setStatus(this.collectionsUtil.getEgwStatusForModuleAndCode("OnlinePayment", "ONLINE_STATUS_SUCCESS"));
        this.receiptHeaderService.persist(receipt);
    }

    public void processFailureMsg(ReceiptHeader onlinePaymentReceiptHeader, PaymentResponse paymentResponse) {
        EgwStatus receiptStatus = this.collectionsUtil.getReceiptStatusForCode("CANCELLED");
        onlinePaymentReceiptHeader.setStatus(receiptStatus);
        EgwStatus paymentStatus = "3".equals(paymentResponse.getAuthStatus()) ? this.egwStatusDAO.getStatusByModuleAndCode("OnlinePayment", "ONLINE_STATUS_ABORTED") : this.egwStatusDAO.getStatusByModuleAndCode("OnlinePayment", "ONLINE_STATUS_FAILURE");
        onlinePaymentReceiptHeader.getOnlinePayment().setStatus(paymentStatus);
        onlinePaymentReceiptHeader.getOnlinePayment().setAuthorisationStatusCode(paymentResponse.getAuthStatus());
        this.receiptHeaderService.persist(onlinePaymentReceiptHeader);
        LOGGER.debug((Object)"Cancelled receipt after receiving failure message from the payment gateway");
    }

    public Boolean updateBillingSystem(String serviceCode, BillReceiptInfo billReceipt, BillingIntegrationService billingService) {
        if (billingService == null) {
            return false;
        }
        try {
            HashSet<BillReceiptInfo> billReceipts = new HashSet<BillReceiptInfo>();
            billReceipts.add(billReceipt);
            LOGGER.info((Object)("$$$$$$ Update Billing System for BillReceiptInfo:" + billReceipt.toString()));
            billingService.updateReceiptDetails(billReceipts);
            return true;
        }
        catch (Exception e) {
            String errMsg = "Exception while updating billing system [" + serviceCode + "] with receipt details!";
            LOGGER.debug((Object)errMsg);
            LOGGER.error((Object)errMsg, (Throwable)e);
            throw new ApplicationRuntimeException(errMsg, (Throwable)e);
        }
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }
}

