/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.util.HashSet;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.instrument.InstrumentHeader;
import org.egov.services.instrument.FinancialIntegrationService;
import org.springframework.beans.factory.annotation.Autowired;

public class DishonorChequeService
implements FinancialIntegrationService {
    private static final Logger LOGGER = Logger.getLogger(DishonorChequeService.class);
    private CollectionsUtil collectionsUtil;
    private PersistenceService persistenceService;
    private ReceiptHeaderService receiptHeaderService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusDAO;

    public void updateCollectionsOnInstrumentDishonor(Long instrumentHeaderId) {
        LOGGER.debug((Object)("Update Collection and Billing system for dishonored instrument id: " + instrumentHeaderId));
        EgwStatus receiptInstrumentBounceStatus = this.collectionsUtil.getReceiptStatusForCode("INSTR_BOUNCED");
        EgwStatus receiptCancellationStatus = this.collectionsUtil.getReceiptStatusForCode("CANCELLED");
        ReceiptHeader receiptHeader = (ReceiptHeader)((Object)this.persistenceService.find("select DISTINCT (receipt) from ReceiptHeader receipt join receipt.receiptInstrument as instruments where instruments.id=? and instruments.statusId.code not in (?,?)", new Object[]{(long)instrumentHeaderId, receiptInstrumentBounceStatus.getCode(), receiptCancellationStatus.getCode()}));
        InstrumentHeader instHeader = (InstrumentHeader)this.persistenceService.findByNamedQuery("INSTRUMENTHEADERBYID", new Object[]{instrumentHeaderId});
        instHeader.setStatusId(this.getDishonoredStatus());
        this.persistenceService.persist((Object)instHeader);
        this.updateReceiptHeaderStatus(receiptHeader, receiptInstrumentBounceStatus, false);
        LOGGER.debug((Object)("Updated receipt status to " + receiptInstrumentBounceStatus.getCode() + " set reconcilation to false"));
        if (!this.updateDetailsToBillingSystem(receiptHeader).booleanValue()) {
            String errorMsg = "Billing system have not been updated successfully for receipt number: " + receiptHeader.getReceiptnumber() + receiptHeader.getConsumerCode() != null ? "and consumer code : " + receiptHeader.getConsumerCode() : "";
            LOGGER.debug((Object)errorMsg);
            throw new ApplicationRuntimeException(errorMsg);
        }
        LOGGER.debug((Object)"Billing system have been updated successfully");
    }

    private void updateReceiptHeaderStatus(ReceiptHeader receiptHeader, EgwStatus status, boolean isReconciled) {
        if (status != null) {
            receiptHeader.setStatus(status);
        }
        receiptHeader.setIsReconciled(isReconciled);
        this.receiptHeaderService.update((Object)receiptHeader);
    }

    private EgwStatus getDishonoredStatus() {
        return this.egwStatusDAO.getStatusByModuleAndCode("Instrument", "Dishonored");
    }

    private Boolean updateDetailsToBillingSystem(ReceiptHeader receiptHeader) {
        Boolean flag = true;
        BillReceiptInfoImpl billReceipt = new BillReceiptInfoImpl(receiptHeader);
        HashSet<BillReceiptInfo> billReceiptInfo = new HashSet<BillReceiptInfo>();
        billReceiptInfo.add(billReceipt);
        String serviceCode = receiptHeader.getService().getCode();
        try {
            this.receiptHeaderService.updateBillingSystem(serviceCode, billReceiptInfo);
            this.updateReceiptHeaderStatus(receiptHeader, null, true);
            LOGGER.debug((Object)("Updated reconcilation status of receipts to true for the  billing system " + serviceCode + " and receipt number " + receiptHeader.getReceiptnumber()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception in update to billing system " + serviceCode + " successful." + e.getMessage()));
            flag = false;
        }
        return flag;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void updateSourceInstrumentVoucher(String event, Long instrumentHeaderId) {
    }
}

