/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.services;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptVoucher;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.BillReceiptInfoImpl;
import org.egov.collection.integration.models.PaymentInfo;
import org.egov.collection.integration.models.PaymentInfoBank;
import org.egov.collection.integration.models.PaymentInfoCash;
import org.egov.collection.integration.models.PaymentInfoChequeDD;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.collection.service.ReceiptHeaderService;
import org.egov.collection.utils.CollectionCommon;
import org.egov.collection.utils.CollectionsUtil;
import org.egov.commons.CVoucherHeader;
import org.egov.commons.Fund;
import org.egov.commons.service.CommonsServiceImpl;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.EgovThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infstr.services.PersistenceService;
import org.egov.lib.security.terminal.model.Location;
import org.egov.model.instrument.InstrumentHeader;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectionIntegrationServiceImpl
extends PersistenceService<ReceiptHeader, Long>
implements CollectionIntegrationService {
    private static final Logger LOGGER = Logger.getLogger(CollectionIntegrationServiceImpl.class);
    @Autowired
    private CommonsServiceImpl commonsServiceImpl;
    private PersistenceService persistenceService;
    @Autowired
    private CollectionsUtil collectionsUtil;
    @Autowired
    private ReceiptHeaderService receiptHeaderService;
    List<ValidationError> errors = new ArrayList<ValidationError>();
    private CollectionCommon collectionCommon;

    public void setReceiptHeaderService(ReceiptHeaderService receiptHeaderService) {
        this.receiptHeaderService = receiptHeaderService;
    }

    public void setCollectionsUtil(CollectionsUtil collectionsUtil) {
        this.collectionsUtil = collectionsUtil;
    }

    public void setCollectionCommon(CollectionCommon collectionCommon) {
        this.collectionCommon = collectionCommon;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    public List<BillReceiptInfo> getBillReceiptInfo(String serviceCode, String refNum) {
        ArrayList<BillReceiptInfo> receipts = new ArrayList<BillReceiptInfo>();
        List receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_REFNUM_AND_SERVICECODE", new Object[]{refNum, serviceCode});
        if (receiptHeaders == null || receiptHeaders.isEmpty()) {
            return null;
        }
        for (ReceiptHeader receiptHeader : receiptHeaders) {
            receipts.add(new BillReceiptInfoImpl(receiptHeader));
        }
        return receipts;
    }

    @Override
    public Map<String, List<BillReceiptInfo>> getBillReceiptInfo(String serviceCode, Set<String> refNums) {
        HashMap<String, List<BillReceiptInfo>> receipts = new HashMap<String, List<BillReceiptInfo>>();
        for (String refNum : refNums) {
            receipts.put(refNum, this.getBillReceiptInfo(serviceCode, refNum));
        }
        return receipts;
    }

    @Override
    public List<BillReceiptInfo> getInstrumentReceiptInfo(String serviceCode, String instrumentNum) {
        ArrayList<BillReceiptInfo> receipts = new ArrayList<BillReceiptInfo>();
        List receiptHeaders = this.findAllByNamedQuery("RECEIPTS_BY_INSTRUMENTNO_AND_SERVICECODE", new Object[]{instrumentNum, serviceCode});
        if (receiptHeaders == null || receiptHeaders.isEmpty()) {
            return null;
        }
        for (ReceiptHeader receiptHeader : receiptHeaders) {
            receipts.add(new BillReceiptInfoImpl(receiptHeader));
        }
        return receipts;
    }

    @Override
    public Map<String, List<BillReceiptInfo>> getInstrumentReceiptInfo(String serviceCode, Set<String> instrumentNums) {
        HashMap<String, List<BillReceiptInfo>> receipts = new HashMap<String, List<BillReceiptInfo>>();
        for (String instrumentNum : instrumentNums) {
            receipts.put(instrumentNum, this.getInstrumentReceiptInfo(serviceCode, instrumentNum));
        }
        return receipts;
    }

    @Override
    public BillReceiptInfo getReceiptInfo(String serviceCode, String receiptNum) {
        ReceiptHeader receiptHeader = (ReceiptHeader)((Object)this.findByNamedQuery("RECEIPTS_BY_RECEIPTNUM_AND_SERVICECODE", new Object[]{serviceCode, receiptNum, receiptNum}));
        if (receiptHeader == null) {
            return null;
        }
        BillReceiptInfoImpl receiptInfo = new BillReceiptInfoImpl(receiptHeader);
        return receiptInfo;
    }

    @Override
    public Map<String, BillReceiptInfo> getReceiptInfo(String serviceCode, Set<String> receiptNums) {
        HashMap<String, BillReceiptInfo> receipts = new HashMap<String, BillReceiptInfo>();
        for (String receiptNum : receiptNums) {
            receipts.put(receiptNum, this.getReceiptInfo(serviceCode, receiptNum));
        }
        return receipts;
    }

    @Override
    public BillReceiptInfo createReceipt(BillInfo bill, List<PaymentInfo> paymentInfoList) {
        LOGGER.info((Object)"Logs For HandHeldDevice Permance Test : Receipt Creation Started....");
        Fund fund = this.commonsServiceImpl.fundByCode(bill.getFundCode());
        if (fund == null) {
            throw new ApplicationRuntimeException("Fund not present for the fund code [" + bill.getFundCode() + "].");
        }
        Department dept = (Department)this.persistenceService.findByNamedQuery("getDepartmentByCode", new Object[]{bill.getDepartmentCode()});
        if (dept == null) {
            throw new ApplicationRuntimeException("Department not present for the department code [" + bill.getDepartmentCode() + "].");
        }
        ReceiptHeader receiptHeader = this.collectionCommon.initialiseReceiptModelWithBillInfo(bill, fund, dept);
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setReceiptdate(new Date());
        receiptHeader.setReceipttype('B');
        receiptHeader.setIsModifiable(Boolean.TRUE);
        receiptHeader.setIsReconciled(Boolean.FALSE);
        receiptHeader.setCollectiontype(Character.valueOf('F'));
        receiptHeader.setStatus(this.collectionsUtil.getEgwStatusForModuleAndCode("ReceiptHeader", "APPROVED"));
        receiptHeader.setPaidBy(bill.getPaidBy());
        if (EgovThreadLocals.getUserId() != null) {
            User user = this.collectionsUtil.getUserById(EgovThreadLocals.getUserId());
            receiptHeader.setCreatedBy(user);
            receiptHeader.setLastModifiedBy(user);
            Location location = this.collectionsUtil.getLocationByUser(EgovThreadLocals.getUserId());
            if (location != null) {
                receiptHeader.setLocation(location);
            }
        }
        BigDecimal chequeDDInstrumenttotal = BigDecimal.ZERO;
        BigDecimal otherInstrumenttotal = BigDecimal.ZERO;
        ArrayList<InstrumentHeader> instrumentHeaderList = new ArrayList<InstrumentHeader>();
        for (PaymentInfo paytInfo : paymentInfoList) {
            String instrType = paytInfo.getInstrumentType().toString();
            if ("cash".equals(instrType)) {
                PaymentInfoCash paytInfoCash = (PaymentInfoCash)paytInfo;
                instrumentHeaderList.add(this.collectionCommon.validateAndConstructCashInstrument(paytInfoCash));
                otherInstrumenttotal = paytInfo.getInstrumentAmount();
            }
            if ("bankchallan".equals(instrType)) {
                PaymentInfoBank paytInfoBank = (PaymentInfoBank)paytInfo;
                instrumentHeaderList.add(this.collectionCommon.validateAndConstructBankInstrument(paytInfoBank));
                otherInstrumenttotal = paytInfoBank.getInstrumentAmount();
            }
            if (!"cheque".equals(instrType) && !"dd".equals(instrType)) continue;
            PaymentInfoChequeDD paytInfoChequeDD = (PaymentInfoChequeDD)paytInfo;
            instrumentHeaderList.add(this.collectionCommon.validateAndConstructChequeDDInstrument(paytInfoChequeDD));
            chequeDDInstrumenttotal = chequeDDInstrumenttotal.add(paytInfoChequeDD.getInstrumentAmount());
        }
        HashSet<InstrumentHeader> instHeaderSet = new HashSet<InstrumentHeader>(this.receiptHeaderService.createInstrument(instrumentHeaderList));
        LOGGER.info((Object)"\tInstrument List created\t");
        receiptHeader.setReceiptInstrument(instHeaderSet);
        BigDecimal debitAmount = BigDecimal.ZERO;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            debitAmount = debitAmount.add(receiptDetail.getCramount());
            debitAmount = debitAmount.subtract(receiptDetail.getDramount());
        }
        receiptHeader.addReceiptDetail(this.collectionCommon.addDebitAccountHeadDetails(debitAmount, receiptHeader, chequeDDInstrumenttotal, otherInstrumenttotal, paymentInfoList.get(0).getInstrumentType().toString()));
        this.receiptHeaderService.persist(receiptHeader);
        this.receiptHeaderService.getSession().flush();
        LOGGER.info((Object)("Receipt Created with receipt number: " + receiptHeader.getReceiptnumber()));
        this.collectionCommon.updateBillingSystemWithReceiptInfo(receiptHeader);
        LOGGER.info((Object)"Billing system updated with receipt info");
        LOGGER.info((Object)"Logs For HandHeldDevice Permance Test : Receipt Creation Finished....");
        return new BillReceiptInfoImpl(receiptHeader);
    }

    @Override
    public List<BillReceiptInfo> getOnlinePendingReceipts(String serviceCode, String consumerCode) {
        ArrayList<BillReceiptInfo> receipts = new ArrayList<BillReceiptInfo>();
        List receiptHeaders = this.findAllByNamedQuery("QUERY_ONLINE_PENDING_RECEIPTS_BY_CONSUMERCODE_AND_SERVICECODE", new Object[]{serviceCode, consumerCode, "ONLINE_STATUS_PENDING"});
        if (receiptHeaders == null || receiptHeaders.isEmpty()) {
            return null;
        }
        for (ReceiptHeader receiptHeader : receiptHeaders) {
            receipts.add(new BillReceiptInfoImpl(receiptHeader));
        }
        return receipts;
    }

    @Override
    public BillReceiptInfo createMiscellaneousReceipt(BillInfo bill, List<PaymentInfo> paymentInfoList) {
        LOGGER.info((Object)"Logs For Miscellaneous Receipt : Receipt Creation Started....");
        Fund fund = this.commonsServiceImpl.fundByCode(bill.getFundCode());
        if (fund == null) {
            throw new ApplicationRuntimeException("Fund not present for the fund code [" + bill.getFundCode() + "].");
        }
        Department dept = (Department)this.persistenceService.findByNamedQuery("getDepartmentByCode", new Object[]{bill.getDepartmentCode()});
        if (dept == null) {
            throw new ApplicationRuntimeException("Department not present for the department code [" + bill.getDepartmentCode() + "].");
        }
        ReceiptHeader receiptHeader = this.collectionCommon.initialiseReceiptModelWithBillInfo(bill, fund, dept);
        receiptHeader.setCreatedDate(new Date());
        receiptHeader.setReceipttype('A');
        receiptHeader.setIsModifiable(Boolean.TRUE);
        receiptHeader.setIsReconciled(Boolean.TRUE);
        receiptHeader.setCollectiontype(Character.valueOf('C'));
        receiptHeader.setStatus(this.collectionsUtil.getEgwStatusForModuleAndCode("ReceiptHeader", "APPROVED"));
        receiptHeader.setPaidBy(bill.getPaidBy());
        if (EgovThreadLocals.getUserId() != null) {
            receiptHeader.setCreatedBy(this.collectionsUtil.getUserById(EgovThreadLocals.getUserId()));
            Location location = this.collectionsUtil.getLocationByUser(EgovThreadLocals.getUserId());
            if (location != null) {
                receiptHeader.setLocation(location);
            }
        }
        BigDecimal chequeDDInstrumenttotal = BigDecimal.ZERO;
        BigDecimal otherInstrumenttotal = BigDecimal.ZERO;
        BigDecimal debitAmount = BigDecimal.ZERO;
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            debitAmount = debitAmount.add(receiptDetail.getCramount());
            debitAmount = debitAmount.subtract(receiptDetail.getDramount());
        }
        receiptHeader.addReceiptDetail(this.collectionCommon.addDebitAccountHeadDetails(debitAmount, receiptHeader, chequeDDInstrumenttotal, otherInstrumenttotal, paymentInfoList.get(0).getInstrumentType().toString()));
        this.receiptHeaderService.persist(receiptHeader);
        this.receiptHeaderService.getSession().flush();
        LOGGER.info((Object)("Miscellaneous Receipt Created with receipt number: " + receiptHeader.getReceiptnumber()));
        try {
            this.receiptHeaderService.createVoucherForReceipt(receiptHeader, Boolean.FALSE);
            LOGGER.debug((Object)"Updated financial systems and created voucher.");
        }
        catch (ApplicationRuntimeException ex) {
            this.errors.add(new ValidationError("Miscellaneous Receipt creation transaction rolled back as update to financial system failed.", "Miscellaneous Receipt creation transaction rolled back as update to financial system failed."));
            LOGGER.error((Object)"Update to financial systems failed");
        }
        ArrayList<CVoucherHeader> voucherHeaderList = new ArrayList<CVoucherHeader>();
        LOGGER.info((Object)("Receipt Voucher created with vouchernumber:\t" + receiptHeader.getVoucherNum()));
        for (ReceiptVoucher receiptVoucher : receiptHeader.getReceiptVoucher()) {
            voucherHeaderList.add(receiptVoucher.getVoucherheader());
        }
        LOGGER.info((Object)"Logs For HandHeldDevice Permance Test : Receipt Creation Finished....");
        return new BillReceiptInfoImpl(receiptHeader);
    }
}

