/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.pgi;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.integration.pgi.DefaultPaymentRequest;
import org.egov.collection.integration.pgi.DefaultPaymentResponse;
import org.egov.collection.integration.pgi.PaymentGatewayAdaptor;
import org.egov.collection.integration.pgi.PaymentRequest;
import org.egov.collection.integration.pgi.PaymentResponse;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.models.ServiceDetails;
import org.egov.infstr.utils.EGovConfig;

public class BillDeskAdaptor
implements PaymentGatewayAdaptor {
    private static final Logger LOGGER = Logger.getLogger(BillDeskAdaptor.class);

    @Override
    public PaymentRequest createPaymentRequest(ServiceDetails paymentServiceDetails, ReceiptHeader receiptHeader) {
        DefaultPaymentRequest paymentRequest = new DefaultPaymentRequest();
        StringBuffer paymentReqMsg = new StringBuffer(20);
        paymentReqMsg.append("TESTMUNC").append("|").append(receiptHeader.getReferencenumber()).append("|").append("NA").append("|").append(receiptHeader.getTotalAmount().setScale(2, 0)).append("|").append("NA").append("|").append("NA").append("|").append("NA").append("|").append("INR").append("|").append("NA").append("|").append('R').append("|").append("testmunc").append("|").append("NA").append("|").append("NA").append("|").append('F').append("|").append(receiptHeader.getId()).append("|").append(receiptHeader.getTotalAmount().setScale(2, 0)).append("|").append(EGovConfig.getMessage((String)"custom.properties", (String)("billdesk.revenuehead." + receiptHeader.getService().getCode()))).append("|").append(paymentServiceDetails.getCode()).append("|").append(receiptHeader.getService().getCode()).append("|").append("NA").append("|").append("NA").append("|").append(paymentServiceDetails.getCallBackurl() + "?serviceCode=").append(paymentServiceDetails.getCode());
        String checkSumValue = null;
        paymentReqMsg.append("|").append(checkSumValue);
        paymentRequest.setParameter("paymentReqMsg", paymentReqMsg.toString());
        paymentRequest.setParameter("paymentGatewayURL", paymentServiceDetails.getServiceUrl());
        LOGGER.info((Object)("paymentRequest: " + paymentRequest.toString()));
        return paymentRequest;
    }

    @Override
    public PaymentResponse parsePaymentResponse(String response) {
        String[] messages = response.split("\\|", -1);
        String errorKeyPrefix = messages[20] + ".pgi." + messages[19];
        if (!this.isValidChecksum(response.substring(0, response.lastIndexOf(124)), messages[25])) {
            LOGGER.error((Object)"Error occured due to check sum mismatch");
            throw new ApplicationRuntimeException(errorKeyPrefix + ".checksum.mismatch");
        }
        DefaultPaymentResponse billDeskResponse = new DefaultPaymentResponse();
        billDeskResponse.setCustomerId(messages[1]);
        billDeskResponse.setTxnReferenceNo(messages[2]);
        billDeskResponse.setTxnAmount(new BigDecimal(messages[4]));
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy", Locale.getDefault());
        Date transactionDate = null;
        try {
            transactionDate = sdf.parse(messages[13]);
        }
        catch (ParseException e) {
            LOGGER.error((Object)("Error occured in parsing the transaction date [" + messages[13] + "]"), (Throwable)e);
            throw new ApplicationRuntimeException(errorKeyPrefix + ".transactiondate.parse.error", (Throwable)e);
        }
        billDeskResponse.setTxnDate(transactionDate);
        billDeskResponse.setAuthStatus(messages[14]);
        billDeskResponse.setReceiptId(messages[16]);
        billDeskResponse.setChecksum(messages[25]);
        return billDeskResponse;
    }

    public boolean isValidChecksum(String testString, String testChecksum) {
        String actualChecksum = null;
        return actualChecksum.equals(testChecksum);
    }
}

