/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.integration.models;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.egov.collection.entity.ChallanInfo;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAccountInfoImpl;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfoImpl;
import org.egov.commons.EgwStatus;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.User;
import org.egov.lib.security.terminal.model.Location;
import org.egov.model.instrument.InstrumentHeader;

public class BillReceiptInfoImpl
implements BillReceiptInfo {
    private final ReceiptHeader receiptHeader;
    private String event;
    private final Set<ReceiptAccountInfo> accountDetails = new HashSet<ReceiptAccountInfo>(0);
    private final Set<ReceiptInstrumentInfo> instrumentDetails = new HashSet<ReceiptInstrumentInfo>();
    private final Set<ReceiptInstrumentInfo> bouncedInstruments = new HashSet<ReceiptInstrumentInfo>();
    private final Set<ChallanInfo> challanDetails = new HashSet<ChallanInfo>();
    private ChallanInfo challan = null;
    private final String receiptURL;

    public BillReceiptInfoImpl(ReceiptHeader receiptHeader) {
        this.receiptHeader = receiptHeader;
        this.receiptURL = "/collection/receipts/receipt-viewReceipts.action?selectedReceipts=" + receiptHeader.getId();
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            this.accountDetails.add(new ReceiptAccountInfoImpl(receiptDetail));
        }
        for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
            this.instrumentDetails.add(new ReceiptInstrumentInfoImpl(instrumentHeader));
        }
        String receiptStatus = receiptHeader.getStatus().getCode();
        if ("INSTR_BOUNCED".equals(receiptStatus)) {
            this.event = "INSTRUMENT_BOUNCED";
            this.findBouncedInstruments();
        } else if ("TO_BE_SUBMITTED".equals(receiptStatus) || "APPROVED".equals(receiptStatus) || "SUBMITTED".equals(receiptStatus)) {
            this.event = "RECEIPT_CREATED";
        } else if ("CANCELLED".equals(receiptStatus)) {
            this.event = "RECEIPT_CANCELLED";
        }
    }

    public BillReceiptInfoImpl(ReceiptHeader receiptHeader, EgovCommon egovCommon, ReceiptHeader receiptHeaderRefObj) {
        this.receiptHeader = receiptHeader;
        this.receiptURL = "/collection/receipts/receipt-viewReceipts.action?selectedReceipts=" + receiptHeader.getId();
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            this.accountDetails.add(new ReceiptAccountInfoImpl(receiptDetail));
        }
        for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
            this.instrumentDetails.add(new ReceiptInstrumentInfoImpl(instrumentHeader));
        }
        if (receiptHeader.getReceipttype() == 'C') {
            this.challan = new ChallanInfo(receiptHeader, egovCommon, receiptHeaderRefObj);
            this.challanDetails.add(this.challan);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReceiptNum()).append(" ").append(this.getAccountDetails());
        return sb.toString();
    }

    @Override
    public String getBillReferenceNum() {
        return this.receiptHeader.getReferencenumber();
    }

    @Override
    public String getEvent() {
        return this.event;
    }

    @Override
    public String getReceiptNum() {
        return this.receiptHeader.getReceiptnumber();
    }

    @Override
    public Date getReceiptDate() {
        return this.receiptHeader.getReceiptdate();
    }

    @Override
    public Location getReceiptLocation() {
        return this.receiptHeader.getLocation();
    }

    @Override
    public EgwStatus getReceiptStatus() {
        return this.receiptHeader.getStatus();
    }

    @Override
    public String getPayeeName() {
        return StringEscapeUtils.unescapeJavaScript((String)this.receiptHeader.getPayeeName());
    }

    @Override
    public String getPayeeAddress() {
        return this.receiptHeader.getPayeeAddress();
    }

    @Override
    public Set<ReceiptAccountInfo> getAccountDetails() {
        return this.accountDetails;
    }

    @Override
    public Set<ReceiptInstrumentInfo> getInstrumentDetails() {
        return this.instrumentDetails;
    }

    @Override
    public Set<ReceiptInstrumentInfo> getBouncedInstruments() {
        return this.bouncedInstruments;
    }

    @Override
    public String getServiceName() {
        return this.receiptHeader.getService().getName();
    }

    @Override
    public String getPaidBy() {
        return this.receiptHeader.getPaidBy();
    }

    @Override
    public String getDescription() {
        return this.receiptHeader.getReferenceDesc();
    }

    @Override
    public BigDecimal getTotalAmount() {
        return this.receiptHeader.getAmount();
    }

    @Override
    public User getCreatedBy() {
        return this.receiptHeader.getCreatedBy();
    }

    @Override
    public User getModifiedBy() {
        return this.receiptHeader.getLastModifiedBy();
    }

    private void findBouncedInstruments() {
        for (ReceiptInstrumentInfo instrumentInfo : this.instrumentDetails) {
            if (!instrumentInfo.isBounced()) continue;
            this.bouncedInstruments.add(instrumentInfo);
        }
    }

    public ReceiptMisc getReceiptMisc() {
        return this.receiptHeader.getReceiptMisc();
    }

    public Set<ChallanInfo> getChallanDetails() {
        return this.challanDetails;
    }

    public ChallanInfo getChallan() {
        return this.challan;
    }

    @Override
    public String getReceiptURL() {
        return this.receiptURL;
    }

    @Override
    public String getCollectionType() {
        return this.receiptHeader.getCollectiontype().toString();
    }

    public String getConsumerCode() {
        return this.receiptHeader.getConsumerCode();
    }
}

