/*
 * Decompiled with CFR 0.152.
 */
package org.egov.collection.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.egov.collection.entity.AccountPayeeDetail;
import org.egov.collection.entity.AccountPayeeDetailInfo;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.entity.ReceiptHeader;
import org.egov.collection.entity.ReceiptMisc;
import org.egov.collection.integration.models.ReceiptAccountInfo;
import org.egov.collection.integration.models.ReceiptAccountInfoImpl;
import org.egov.collection.integration.models.ReceiptInstrumentInfo;
import org.egov.collection.integration.models.ReceiptInstrumentInfoImpl;
import org.egov.commons.EgwStatus;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.User;
import org.egov.model.instrument.InstrumentHeader;

public class ChallanInfo {
    private ReceiptHeader receiptHeader = null;
    private final Set<ReceiptAccountInfo> accountDetails = new HashSet<ReceiptAccountInfo>();
    private final Set<AccountPayeeDetailInfo> accountPayeeDetails = new HashSet<AccountPayeeDetailInfo>();
    private final Set<ReceiptInstrumentInfo> instrumentDetails = new HashSet<ReceiptInstrumentInfo>();
    private ReceiptHeader receipHeaderReferenceObj = new ReceiptHeader();

    public ChallanInfo(ReceiptHeader receiptHeader, EgovCommon egovCommon, ReceiptHeader receiptHeaderRefObj) {
        this.receiptHeader = receiptHeader;
        if (receiptHeaderRefObj != null && receiptHeaderRefObj.getChallan() != null) {
            this.receipHeaderReferenceObj = receiptHeaderRefObj;
        }
        for (ReceiptDetail receiptDetail : receiptHeader.getReceiptDetails()) {
            this.accountDetails.add(new ReceiptAccountInfoImpl(receiptDetail));
            for (AccountPayeeDetail accountPayeeDetail : receiptDetail.getAccountPayeeDetails()) {
                this.accountPayeeDetails.add(new AccountPayeeDetailInfo(accountPayeeDetail, egovCommon));
            }
        }
        for (InstrumentHeader instrumentHeader : receiptHeader.getReceiptInstrument()) {
            this.instrumentDetails.add(new ReceiptInstrumentInfoImpl(instrumentHeader));
        }
    }

    public String getChallanNumber() {
        String challanNumberStr = "";
        challanNumberStr = this.receiptHeader.getChallan() == null ? this.receipHeaderReferenceObj.getChallan().getChallanNumber() : this.receiptHeader.getChallan().getChallanNumber();
        return challanNumberStr;
    }

    public Date getChallanDate() {
        if (this.receiptHeader.getChallan() == null) {
            return this.receipHeaderReferenceObj.getChallan().getChallanDate();
        }
        return this.receiptHeader.getChallan().getChallanDate();
    }

    public EgwStatus getChallanStatus() {
        if (this.receiptHeader.getChallan() == null) {
            return this.receipHeaderReferenceObj.getChallan().getStatus();
        }
        return this.receiptHeader.getChallan().getStatus();
    }

    public String getBillReferenceNum() {
        return this.receiptHeader.getReferencenumber();
    }

    public String getPayeeName() {
        return this.receiptHeader.getPayeeName();
    }

    public String getDescription() {
        return this.receiptHeader.getReferenceDesc();
    }

    public String getPayeeAddress() {
        return this.receiptHeader.getPayeeAddress();
    }

    public Set<ReceiptAccountInfo> getAccountDetails() {
        return this.accountDetails;
    }

    public ReceiptMisc getReceiptMisc() {
        return this.receiptHeader.getReceiptMisc();
    }

    public User getCreatedBy() {
        if (this.receiptHeader.getChallan() == null) {
            return this.receipHeaderReferenceObj.getChallan().getCreatedBy();
        }
        return this.receiptHeader.getChallan().getCreatedBy();
    }

    public BigDecimal getTotalAmount() {
        return this.receiptHeader.getTotalAmount();
    }

    public String getServiceName() {
        return this.receiptHeader.getService().getName();
    }

    public String getFunctionName() {
        String functionName = null;
        for (ReceiptDetail rDetails : this.receiptHeader.getReceiptDetails()) {
            if (rDetails.getFunction() == null) continue;
            functionName = rDetails.getFunction().getName();
        }
        return functionName;
    }

    public Set<AccountPayeeDetailInfo> getAccountPayeeDetails() {
        return this.accountPayeeDetails;
    }

    public Set<ReceiptInstrumentInfo> getInstrumentDetails() {
        return this.instrumentDetails;
    }

    public String getChallanVoucherNum() {
        if (this.receiptHeader.getChallan() == null) {
            return this.receipHeaderReferenceObj.getChallan().getVoucherHeader() == null ? null : this.receipHeaderReferenceObj.getChallan().getVoucherHeader().getVoucherNumber();
        }
        return this.receiptHeader.getChallan().getVoucherHeader() == null ? null : this.receiptHeader.getChallan().getVoucherHeader().getVoucherNumber();
    }

    public String getChallanServiceName() {
        if (this.receiptHeader.getChallan() == null) {
            return this.receipHeaderReferenceObj.getChallan().getService() == null ? null : this.receipHeaderReferenceObj.getChallan().getService().getName();
        }
        return this.receiptHeader.getChallan().getService() == null ? null : this.receiptHeader.getChallan().getService().getName();
    }
}

