/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.reports;

import com.google.gson.GsonBuilder;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.search.contract.HoardingSearch;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.AdvertisementReportService;
import org.egov.adtax.web.controller.GenericController;
import org.egov.infra.config.properties.ApplicationProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class DcbReportController
extends GenericController {
    @Autowired
    private AdvertisementReportService hoardingReportService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;

    @RequestMapping(value={"search-for-dcbreport"}, method={RequestMethod.GET})
    public String searchHoardingForm(@ModelAttribute HoardingSearch hoardingSearch) {
        return "report-dcb";
    }

    @RequestMapping(value={"search-for-dcbreport"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchHoarding(@ModelAttribute HoardingSearch hoardingSearch) {
        return "{ \"data\":" + new GsonBuilder().setDateFormat(this.applicationProperties.defaultDatePattern()).create().toJson((Object)this.advertisementPermitDetailService.getAdvertisementSearchResult(hoardingSearch, null)) + "}";
    }

    @RequestMapping(value={"getHoardingDcb/{id}"})
    public String viewHoarding(@PathVariable Long id, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(id);
        if (advertisementPermitDetail != null) {
            Advertisement hoarding = advertisementPermitDetail.getAdvertisement();
            model.addAttribute("hoarding", (Object)hoarding);
            model.addAttribute("dcbResult", (Object)this.hoardingReportService.getHoardingWiseDCBResult(hoarding));
        }
        return "report-dcbview";
    }
}

