/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.ratesClass;

import java.util.List;
import javax.validation.Valid;
import org.egov.adtax.entity.RatesClass;
import org.egov.adtax.service.RatesClassService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/ratesclass"})
public class RatesClassController {
    private final RatesClassService rateClassService;

    @Autowired
    public RatesClassController(RatesClassService rateClassService) {
        this.rateClassService = rateClassService;
    }

    @ModelAttribute
    public RatesClass ratesClass() {
        return new RatesClass();
    }

    @ModelAttribute(value="rateClasses")
    public List<RatesClass> getAllRatesClasses() {
        return this.rateClassService.findAll();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.GET})
    public String create() {
        return "ratesClass-form";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search() {
        return "ratesClass-search";
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute RatesClass ratesClass, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "ratesClass-form";
        }
        this.rateClassService.createRatesClass(ratesClass);
        redirectAttrs.addFlashAttribute("ratesClass", (Object)ratesClass);
        redirectAttrs.addFlashAttribute("message", (Object)"message.ratesClass.create");
        return "redirect:/ratesclass/success/" + ratesClass.getId();
    }

    @RequestMapping(value={"/success/{description}"}, method={RequestMethod.GET})
    public ModelAndView successView(@PathVariable(value="description") Long description, @ModelAttribute RatesClass ratesClass) {
        return new ModelAndView("ratesClass/ratesClass-success", "ratesClass", (Object)this.rateClassService.getRateClassById(description));
    }
}

