/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.hoarding;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.enums.AdvertisementStatus;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.web.controller.common.HoardingControllerSupport;
import org.egov.demand.model.EgDemandDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class UpdateLegacyAdvertisementController
extends HoardingControllerSupport {
    @Autowired
    private ResourceBundleMessageSource messageSource;

    @ModelAttribute(value="advertisementPermitDetail")
    public AdvertisementPermitDetail advertisementPermitDetail(@PathVariable String id) {
        return this.advertisementPermitDetailService.findBy(Long.valueOf(id));
    }

    @RequestMapping(value={"/updateLegacy/{id}"}, method={RequestMethod.GET})
    public String updateHoarding(@PathVariable String id, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findBy(Long.valueOf(id));
        Advertisement advertisement = advertisementPermitDetail.getAdvertisement();
        if (advertisement == null) {
            model.addAttribute("message", (Object)"msg.collection.updateRecordNotAllowed");
            return "collectAdvtax-error";
        }
        Boolean taxAlreadyCollectedForDemandInAnyYear = this.checkTaxAlreadyCollectedForAdvertisement(advertisement);
        if (advertisement != null && !advertisement.getStatus().equals((Object)AdvertisementStatus.ACTIVE)) {
            model.addAttribute("message", (Object)"msg.collection.updateRecordNotAllowed");
            return "collectAdvtax-error";
        }
        if (taxAlreadyCollectedForDemandInAnyYear.booleanValue()) {
            model.addAttribute("message", (Object)"msg.collection.taxAlreadyCollected");
            return "collectAdvtax-error";
        }
        if (advertisement != null && advertisement.getDemandId() != null) {
            for (EgDemandDetails egDemandDetail : advertisement.getDemandId().getEgDemandDetails()) {
                if (egDemandDetail.getAmount() == null || egDemandDetail.getAmtCollected() == null || egDemandDetail.getAmtCollected().compareTo(BigDecimal.ZERO) <= 0) continue;
                advertisement.setTaxPaidForCurrentYear(Boolean.valueOf(true));
                break;
            }
        }
        model.addAttribute("advertisementPermitDetail", (Object)advertisement.getActiveAdvertisementPermit());
        model.addAttribute("advertisementDocuments", (Object)advertisement.getDocuments());
        return "hoarding-updateLegacy";
    }

    @RequestMapping(value={"/updateLegacy/{id}"}, method={RequestMethod.POST})
    public String updateHoarding(@Valid @ModelAttribute AdvertisementPermitDetail advertisementPermitDetail, BindingResult resultBinder, RedirectAttributes redirAttrib, HttpServletRequest request, Model model) {
        this.validateHoardingDocsOnUpdate(advertisementPermitDetail, resultBinder, redirAttrib);
        if (resultBinder.hasErrors()) {
            return "hoarding-updateLegacy";
        }
        try {
            this.updateHoardingDocuments(advertisementPermitDetail);
            this.advertisementPermitDetailService.updateAdvertisementPermitDetailForLegacy(advertisementPermitDetail);
            String message = this.messageSource.getMessage("hoarding.update.success", (Object[])new String[]{advertisementPermitDetail.getApplicationNumber()}, null);
            redirAttrib.addFlashAttribute("message", (Object)message);
            return "redirect:/hoarding/success/" + advertisementPermitDetail.getId();
        }
        catch (HoardingValidationError e) {
            resultBinder.rejectValue(e.fieldName(), e.errorCode());
            return "hoarding-updateLegacy";
        }
    }
}

