/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.web.controller.collection;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import org.egov.adtax.entity.Advertisement;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.entity.AgencyWiseCollection;
import org.egov.adtax.entity.AgencyWiseCollectionSearch;
import org.egov.adtax.service.AdvertisementDemandService;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.adtax.service.AdvertisementService;
import org.egov.adtax.service.AgencyService;
import org.egov.adtax.service.AgencyWiseCollectionService;
import org.egov.adtax.service.collection.AdvertisementBillServiceImpl;
import org.egov.adtax.service.collection.AdvertisementBillable;
import org.egov.adtax.service.collection.AgencyWiseBillServiceImpl;
import org.egov.adtax.service.collection.AgencyWiseBillable;
import org.egov.demand.interfaces.Billable;
import org.egov.infra.persistence.utils.SequenceNumberGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/hoarding"})
public class AdvertisementBillGeneratorController {
    @Autowired
    private AdvertisementBillServiceImpl advertisementBillServiceImpl;
    @Autowired
    private AdvertisementService advertisementService;
    @Autowired
    private AdvertisementBillable advertisementBillable;
    @Autowired
    private AgencyWiseBillable agencyWiseBillable;
    @Autowired
    private AgencyWiseBillServiceImpl agencyWiseBillServiceImpl;
    @Autowired
    private SequenceNumberGenerator sequenceNumberGenerator;
    @Autowired
    private AdvertisementDemandService advertisementDemandService;
    @Autowired
    private AgencyWiseCollectionService agencyWiseCollectionService;
    @Autowired
    private AgencyService agencyService;
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;
    private String ADVERTISEMENT_BILLNUMBER = "SEQ_advertisementbill_NUMBER";

    @RequestMapping(value={"/collectTaxByAgency"}, method={RequestMethod.POST})
    public String collectFeeByAgencytest(Model model, String hoardingIds, String agencyName, BigDecimal total) {
        if (hoardingIds != null && agencyName != null) {
            String[] hoardingList = hoardingIds.split("~");
            if (hoardingList != null && hoardingList.length > 0 && hoardingList[0] != null && hoardingList[0] != "") {
                List agencyWiseCollectionList = this.agencyWiseCollectionService.buildAgencyWiseCollectionSearch(hoardingList);
                if (agencyWiseCollectionList != null && agencyWiseCollectionList.size() > 0) {
                    AgencyWiseCollectionSearch agencyWiseCollectionSearch = new AgencyWiseCollectionSearch();
                    agencyWiseCollectionSearch.setAgencyName(agencyName);
                    agencyWiseCollectionSearch.setAgencyWiseCollectionList(agencyWiseCollectionList);
                    model.addAttribute("agencyWiseCollectionSearch", (Object)agencyWiseCollectionSearch);
                    return "agencyWiseTaxCollect";
                }
                model.addAttribute("message", (Object)"msg.collection.noPendingTax");
                return "collectAdvtax-error";
            }
            model.addAttribute("message", (Object)"msg.collection.noPendingTax");
            return "collectAdvtax-error";
        }
        model.addAttribute("message", (Object)"msg.collection.noPendingTax");
        return "collectAdvtax-error";
    }

    @RequestMapping(value={"/collectTaxByAgency/{agencyName}"}, method={RequestMethod.POST})
    public String successView(@PathVariable(value="agencyName") String agencyName, Model model, @ModelAttribute AgencyWiseCollectionSearch agencyWiseCollectionSearch) {
        StringBuffer hoardings = new StringBuffer();
        if (agencyWiseCollectionSearch != null && agencyWiseCollectionSearch.getAgencyWiseCollectionList() != null && agencyWiseCollectionSearch.getAgencyWiseCollectionList().size() > 0) {
            for (AgencyWiseCollectionSearch searchResult : agencyWiseCollectionSearch.getAgencyWiseCollectionList()) {
                if (!searchResult.isSelectedForCollection()) continue;
                hoardings.append(searchResult.getAdvertisementPermitId()).append("~");
            }
            String[] hoardingList = hoardings.toString().split("~");
            if (hoardingList != null && hoardingList.length > 0 && hoardingList[0] != null && hoardingList[0] != "") {
                Serializable referenceNumber = this.sequenceNumberGenerator.getNextSequence(this.ADVERTISEMENT_BILLNUMBER);
                AgencyWiseCollection agencyWiseCollection = this.agencyWiseCollectionService.buildAgencyWiseObjectByHoardings(hoardingList);
                agencyWiseCollection.setAgency(this.agencyService.findByName(agencyName));
                agencyWiseCollection.setBillNumber("ADTAX".concat(String.format("%s%06d", "", referenceNumber)));
                this.agencyWiseCollectionService.createAgencyWiseCollection(agencyWiseCollection);
                this.agencyWiseBillable.setReferenceNumber("ADTAX".concat(String.format("%s%06d", "", referenceNumber)));
                this.agencyWiseBillable.setAgencyWiseCollection(agencyWiseCollection);
                model.addAttribute("collectxml", (Object)this.agencyWiseBillServiceImpl.getBillXML((Billable)this.agencyWiseBillable));
                return "collectAdvtax-redirection";
            }
        } else {
            model.addAttribute("message", (Object)"msg.collection.noPendingTax");
            return "collectAdvtax-error";
        }
        return "collectAdvtax-redirection";
    }

    @RequestMapping(value={"/getPendingTaxByAgency/{agencyName}"}, method={RequestMethod.GET})
    public String getAgencyWiseDetail(Model model, @PathVariable String agencyName) {
        if (agencyName != null) {
            model.addAttribute("agency", (Object)this.agencyService.findByName(agencyName));
        }
        return null;
    }

    @RequestMapping(value={"/generatebill/{collectionType}/{id}"}, method={RequestMethod.GET})
    public String showCollectFeeForm(Model model, @PathVariable String collectionType, @PathVariable String id) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findById(Long.valueOf(id));
        if (advertisementPermitDetail != null) {
            Advertisement advertisement = advertisementPermitDetail.getAdvertisement();
            if (advertisement != null && advertisement.getDemandId() != null) {
                if (!this.advertisementDemandService.checkAnyTaxIsPendingToCollect(advertisement).booleanValue()) {
                    model.addAttribute("message", (Object)"msg.collection.noPendingTax");
                    return "collectAdvtax-error";
                }
                this.advertisementBillable.setCollectionType("Advertisement");
                if (collectionType != null && !"".equals(collectionType)) {
                    if (collectionType.equalsIgnoreCase("hoarding")) {
                        this.advertisementBillable.setCollectionType("Advertisement");
                    } else {
                        this.advertisementBillable.setCollectionType(collectionType);
                    }
                }
                this.advertisementBillable.setAdvertisement(advertisement);
                Serializable referenceNumber = this.sequenceNumberGenerator.getNextSequence(this.ADVERTISEMENT_BILLNUMBER);
                this.advertisementBillable.setReferenceNumber("ADTAX".concat(String.format("%s%06d", "", referenceNumber)));
                model.addAttribute("collectxml", (Object)this.advertisementBillServiceImpl.getBillXML((Billable)this.advertisementBillable));
                return "collectAdvtax-redirection";
            }
            model.addAttribute("message", (Object)"msg.collection.noPendingTax");
            return "collectAdvtax-error";
        }
        model.addAttribute("message", (Object)"msg.invalied.request");
        return "collectAdvtax-error";
    }

    @RequestMapping(value={"/generatebill/{id}"}, method={RequestMethod.POST})
    public String payTax(@ModelAttribute Advertisement advertisement, @PathVariable String collectionType, RedirectAttributes redirectAttributes, @PathVariable String id, Model model) {
        AdvertisementPermitDetail advertisementPermitDetail = this.advertisementPermitDetailService.findById(Long.valueOf(id));
        if (advertisementPermitDetail != null) {
            advertisement = advertisementPermitDetail.getAdvertisement();
        }
        this.advertisementBillable.setCollectionType("Advertisement");
        if (this.advertisementBillable != null && collectionType != null) {
            this.advertisementBillable.setCollectionType(collectionType);
        }
        this.advertisementBillable.setAdvertisement(advertisement);
        model.addAttribute("collectxml", (Object)this.advertisementBillServiceImpl.getBillXML((Billable)this.advertisementBillable));
        return "collecttax-redirection";
    }
}

