/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service.penalty;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.adtax.entity.AdvertisementAdditionalTaxRate;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.adtax.exception.HoardingValidationError;
import org.egov.adtax.service.AdvertisementAdditinalTaxRateService;
import org.egov.adtax.service.AdvertisementPenaltyRatesService;
import org.egov.adtax.service.penalty.AdvertisementAdditionalTaxCalculator;
import org.egov.adtax.service.penalty.AdvertisementPenaltyCalculator;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AdvertisementPenaltyCalculatorImpl
implements AdvertisementPenaltyCalculator {
    @Autowired
    private AdvertisementPenaltyRatesService advertisementPenaltyRatesService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private AdvertisementAdditionalTaxCalculator advertisementAdditionalTaxCalculator;
    @Autowired
    private AdvertisementAdditinalTaxRateService advertisementAdditinalTaxRateService;

    @Override
    public BigDecimal calculatePenalty(AdvertisementPermitDetail advPermitDetail) throws HoardingValidationError {
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        BigDecimal additinalTax = BigDecimal.ZERO;
        if (this.penaltyCalculationRequired().booleanValue()) {
            List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
            if (advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
                for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                    additinalTax = this.getAdditionalFeeAmountByPassingDemandDetail(demandDtl, additionalTaxRates);
                    penaltyAmt = penaltyAmt.add(this.getPenaltyAmount(advPermitDetail, demandDtl, additinalTax)).setScale(0, 4);
                }
            }
        }
        return penaltyAmt.setScale(0, 4);
    }

    private BigDecimal getPenaltyAmount(AdvertisementPermitDetail advPermitDetail, EgDemandDetails demandDtl, BigDecimal additionalTax) {
        double percentage = 0.0;
        int days = 0;
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (demandDtl.getBalance().compareTo(BigDecimal.ZERO) > 0) {
            days = this.calculateNumberOfDaysForPenaltyCalculation(advPermitDetail, demandDtl);
            totalAmount = demandDtl.getBalance();
            if (additionalTax != null && additionalTax.compareTo(BigDecimal.ZERO) > 0) {
                totalAmount = totalAmount.add(additionalTax);
            }
            if ((percentage = this.advertisementPenaltyRatesService.findPenaltyRatesByNumberOfDays(Long.valueOf(days)).doubleValue()) > 0.0) {
                penaltyAmt = totalAmount.multiply(BigDecimal.valueOf(percentage)).divide(BigDecimal.valueOf(100L).setScale(3, 4));
            }
        }
        return penaltyAmt;
    }

    private int calculateNumberOfDaysForPenaltyCalculation(AdvertisementPermitDetail advPermitDetail, EgDemandDetails demandDtl) {
        int days = 0;
        if (demandDtl.getInstallmentStartDate().after(new Date())) {
            days = Days.daysBetween((ReadableInstant)new DateTime((Object)demandDtl.getInstallmentStartDate()), (ReadableInstant)new DateTime((Object)new Date())).getDays();
        } else if (demandDtl.getInstallmentStartDate().before(new Date())) {
            days = advPermitDetail.getAdvertisement().getPenaltyCalculationDate() != null && demandDtl.getInstallmentStartDate().before(advPermitDetail.getAdvertisement().getPenaltyCalculationDate()) && (demandDtl.getInstallmentEndDate().equals(advPermitDetail.getAdvertisement().getPenaltyCalculationDate()) || demandDtl.getInstallmentEndDate().after(advPermitDetail.getAdvertisement().getPenaltyCalculationDate())) ? Days.daysBetween((ReadableInstant)new DateTime((Object)advPermitDetail.getAdvertisement().getPenaltyCalculationDate()), (ReadableInstant)new DateTime((Object)new Date())).getDays() : Days.daysBetween((ReadableInstant)new DateTime((Object)demandDtl.getInstallmentStartDate()), (ReadableInstant)new DateTime((Object)new Date())).getDays();
        }
        return days;
    }

    @Override
    public Map<Installment, BigDecimal> getPenaltyByInstallment(AdvertisementPermitDetail advPermitDetail) {
        HashMap<Installment, BigDecimal> penaltyReasons = new HashMap<Installment, BigDecimal>();
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        BigDecimal additinalTax = BigDecimal.ZERO;
        if (this.penaltyCalculationRequired().booleanValue()) {
            List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
            if (advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
                for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                    additinalTax = this.getAdditionalFeeAmountByPassingDemandDetail(demandDtl, additionalTaxRates);
                    penaltyAmt = this.getPenaltyAmount(advPermitDetail, demandDtl, additinalTax);
                    if (penaltyReasons.get(demandDtl.getEgDemandReason().getEgInstallmentMaster()) == null) {
                        penaltyReasons.put(demandDtl.getEgDemandReason().getEgInstallmentMaster(), penaltyAmt);
                        continue;
                    }
                    penaltyReasons.put(demandDtl.getEgDemandReason().getEgInstallmentMaster(), ((BigDecimal)penaltyReasons.get(demandDtl.getEgDemandReason().getEgInstallmentMaster())).add(penaltyAmt));
                }
            }
        }
        if (penaltyReasons != null && penaltyReasons.size() > 0) {
            for (Map.Entry entry : penaltyReasons.entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).setScale(0, 4));
            }
        }
        return penaltyReasons;
    }

    @Override
    public Map<Installment, BigDecimal> getPenaltyOnAdditionalTaxByInstallment(AdvertisementPermitDetail advPermitDetail) {
        HashMap<Installment, BigDecimal> penaltyReasons = new HashMap<Installment, BigDecimal>();
        BigDecimal penaltyAmt = BigDecimal.ZERO;
        BigDecimal additinalTax = BigDecimal.ZERO;
        if (this.penaltyCalculationRequired().booleanValue()) {
            List<AdvertisementAdditionalTaxRate> additionalTaxRates = this.advertisementAdditinalTaxRateService.getAllActiveAdditinalTaxRates();
            if (advPermitDetail != null && advPermitDetail.getAdvertisement() != null && advPermitDetail.getAdvertisement().getDemandId() != null) {
                for (EgDemandDetails demandDtl : advPermitDetail.getAdvertisement().getDemandId().getEgDemandDetails()) {
                    additinalTax = this.getAdditionalFeeAmountByPassingDemandDetail(demandDtl, additionalTaxRates);
                    penaltyAmt = this.getPenaltyAmount(advPermitDetail, demandDtl, additinalTax);
                    if (penaltyReasons.get(demandDtl.getEgDemandReason().getEgInstallmentMaster()) == null) {
                        penaltyReasons.put(demandDtl.getEgDemandReason().getEgInstallmentMaster(), penaltyAmt);
                        continue;
                    }
                    penaltyReasons.put(demandDtl.getEgDemandReason().getEgInstallmentMaster(), ((BigDecimal)penaltyReasons.get(demandDtl.getEgDemandReason().getEgInstallmentMaster())).add(penaltyAmt));
                }
            }
        }
        if (penaltyReasons != null && penaltyReasons.size() > 0) {
            for (Map.Entry entry : penaltyReasons.entrySet()) {
                entry.setValue(((BigDecimal)entry.getValue()).setScale(0, 4));
            }
        }
        return penaltyReasons;
    }

    private BigDecimal getAdditionalFeeAmountByPassingDemandDetail(EgDemandDetails demandDtl, List<AdvertisementAdditionalTaxRate> additionalTaxRates) {
        BigDecimal additinalTax = BigDecimal.ZERO;
        if (!additionalTaxRates.isEmpty()) {
            additinalTax = this.advertisementAdditionalTaxCalculator.getAdditionalTaxAmountByPassingDemandDetailAndAdditionalTaxes(demandDtl, additionalTaxRates);
        }
        return additinalTax;
    }

    private Boolean penaltyCalculationRequired() throws HoardingValidationError {
        AppConfigValues ispenaltyCalculationRequired = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Advertisement Tax", "Penalty Calculation required").get(0);
        if (ispenaltyCalculationRequired == null) {
            throw new HoardingValidationError("taxAmount", "ADTAX.004");
        }
        if (ispenaltyCalculationRequired != null && "YES".equalsIgnoreCase(ispenaltyCalculationRequired.getValue())) {
            return true;
        }
        return false;
    }
}

