/*
 * Decompiled with CFR 0.152.
 */
package org.egov.adtax.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.adtax.elasticSearch.service.AdvertisementIndexService;
import org.egov.adtax.entity.AdvertisementPermitDetail;
import org.egov.commons.entity.Source;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.search.elastic.entity.ApplicationIndex;
import org.egov.infra.search.elastic.entity.ApplicationIndexBuilder;
import org.egov.infra.search.elastic.entity.enums.ApprovalStatus;
import org.egov.infra.search.elastic.entity.enums.ClosureStatus;
import org.egov.infra.search.elastic.service.ApplicationIndexService;
import org.egov.infra.security.utils.SecurityUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdvertisementPermitDetailUpdateIndexService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ApplicationIndexService applicationIndexService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private AdvertisementIndexService advertisementIndexService;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void updateAdvertisementPermitDetailIndexes(AdvertisementPermitDetail advertisementPermitDetail) {
        Assignment assignment = null;
        User user = null;
        List<Object> asignList = null;
        if (advertisementPermitDetail.getState() != null && advertisementPermitDetail.getState().getOwnerPosition() != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(advertisementPermitDetail.getState().getOwnerPosition().getId(), new Date());
            if (assignment != null) {
                asignList = new ArrayList<Assignment>();
                asignList.add(assignment);
            } else if (assignment == null) {
                asignList = this.assignmentService.getAssignmentsForPosition(advertisementPermitDetail.getState().getOwnerPosition().getId(), new Date());
            }
            if (!asignList.isEmpty()) {
                user = this.userService.getUserById(((Assignment)asignList.get(0)).getEmployee().getId());
            }
        } else {
            user = this.securityUtils.getCurrentUser();
        }
        if (advertisementPermitDetail.getAdvertisement().getLegacy().booleanValue() && (null == advertisementPermitDetail.getId() || null != advertisementPermitDetail.getId() && advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXPERMITGENERATED"))) {
            this.advertisementIndexService.createAdvertisementIndex(advertisementPermitDetail);
            return;
        }
        ApplicationIndex applicationIndex = this.applicationIndexService.findByApplicationNumber(advertisementPermitDetail.getApplicationNumber());
        if (applicationIndex != null && null != advertisementPermitDetail.getId() && advertisementPermitDetail.getStatus() != null && !advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("CREATED")) {
            if (advertisementPermitDetail.getStatus() != null && (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("APPROVED") || advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXAMTPAYMENTPAID") || advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXPERMITGENERATED") || advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("CANCELLED"))) {
                applicationIndex.setStatus(advertisementPermitDetail.getStatus().getDescription());
                applicationIndex.setOwnername(user != null ? user.getUsername() + "::" + user.getName() : "");
                if (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("APPROVED")) {
                    String applicantName = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : advertisementPermitDetail.getOwnerDetail();
                    String address = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getAddress() : advertisementPermitDetail.getOwnerDetail();
                    applicationIndex.setApplicantName(applicantName);
                    applicationIndex.setApplicantAddress(address);
                    applicationIndex.setMobileNumber(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getMobileNumber() : "");
                }
                if (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("ADTAXPERMITGENERATED")) {
                    applicationIndex.setApproved(ApprovalStatus.APPROVED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
                if (advertisementPermitDetail.getStatus().getCode().equalsIgnoreCase("CANCELLED") || advertisementPermitDetail.getAdvertisement().getStatus().name().equalsIgnoreCase("INACTIVE")) {
                    applicationIndex.setApproved(ApprovalStatus.REJECTED);
                    applicationIndex.setClosed(ClosureStatus.YES);
                }
                if (advertisementPermitDetail.getPermissionNumber() != null) {
                    applicationIndex.setConsumerCode(advertisementPermitDetail.getPermissionNumber());
                }
                this.applicationIndexService.updateApplicationIndex(applicationIndex);
            }
            this.advertisementIndexService.createAdvertisementIndex(advertisementPermitDetail);
        } else {
            String strQuery = "select md from EgModules md where md.name=:name";
            Query hql = this.getCurrentSession().createQuery("select md from EgModules md where md.name=:name");
            hql.setParameter("name", (Object)"Advertisement Tax");
            if (advertisementPermitDetail.getApplicationDate() == null) {
                advertisementPermitDetail.setApplicationDate(new Date());
            }
            if (advertisementPermitDetail.getApplicationNumber() == null) {
                advertisementPermitDetail.setApplicationNumber(advertisementPermitDetail.getApplicationNumber());
            }
            if (applicationIndex == null) {
                String url = "/adtax/hoarding/view/" + advertisementPermitDetail.getId();
                String applicantName = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getName() : advertisementPermitDetail.getOwnerDetail();
                String address = advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getAddress() : advertisementPermitDetail.getOwnerDetail();
                ApplicationIndexBuilder applicationIndexBuilder = new ApplicationIndexBuilder("Advertisement Tax", advertisementPermitDetail.getApplicationNumber(), advertisementPermitDetail.getApplicationDate(), advertisementPermitDetail.getState().getNatureOfTask(), applicantName, advertisementPermitDetail.getStatus().getDescription(), url, address, user.getUsername() + "::" + user.getName(), Source.SYSTEM.toString());
                applicationIndexBuilder.mobileNumber(advertisementPermitDetail.getAgency() != null ? advertisementPermitDetail.getAgency().getMobileNumber() : "");
                applicationIndexBuilder.aadharNumber(null);
                applicationIndexBuilder.approved(ApprovalStatus.INPROGRESS);
                applicationIndexBuilder.closed(ClosureStatus.NO);
                applicationIndex = applicationIndexBuilder.build();
                this.applicationIndexService.createApplicationIndex(applicationIndex);
            }
        }
    }
}

