/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.stock.Stock;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Stock")
    @NotNull
    @Valid
    private List<Stock> stock = new ArrayList<Stock>();
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;

    public StockBulkResponse addStockItem(Stock stockItem) {
        this.stock.add(stockItem);
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static StockBulkResponseBuilder builder() {
        return new StockBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Stock> getStock() {
        return this.stock;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Stock")
    public void setStock(List<Stock> stock) {
        this.stock = stock;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockBulkResponse)) {
            return false;
        }
        StockBulkResponse other = (StockBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Stock> this$stock = this.getStock();
        List<Stock> other$stock = other.getStock();
        return !(this$stock == null ? other$stock != null : !((Object)this$stock).equals(other$stock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Stock> $stock = this.getStock();
        result = result * 59 + ($stock == null ? 43 : ((Object)$stock).hashCode());
        return result;
    }

    public String toString() {
        return "StockBulkResponse(responseInfo=" + this.getResponseInfo() + ", stock=" + this.getStock() + ", totalCount=" + this.getTotalCount() + ")";
    }

    public StockBulkResponse() {
        this.totalCount = StockBulkResponse.$default$totalCount();
    }

    public StockBulkResponse(ResponseInfo responseInfo, List<Stock> stock, Long totalCount) {
        this.responseInfo = responseInfo;
        this.stock = stock;
        this.totalCount = totalCount;
    }

    public static class StockBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Stock> stock;
        private boolean totalCount$set;
        private Long totalCount$value;

        StockBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public StockBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Stock")
        public StockBulkResponseBuilder stock(List<Stock> stock) {
            this.stock = stock;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public StockBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        public StockBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = StockBulkResponse.$default$totalCount();
            }
            return new StockBulkResponse(this.responseInfo, this.stock, totalCount$value);
        }

        public String toString() {
            return "StockBulkResponse.StockBulkResponseBuilder(responseInfo=" + this.responseInfo + ", stock=" + this.stock + ", totalCount$value=" + this.totalCount$value + ")";
        }
    }
}

