/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import org.egov.common.models.core.EgovOfflineModel;
import org.egov.common.models.household.Address;
import org.egov.common.models.household.HouseHoldType;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Household
extends EgovOfflineModel {
    @JsonProperty(value="memberCount")
    @NotNull
    private Integer memberCount = null;
    @JsonProperty(value="address")
    @Valid
    private Address address = null;
    @JsonProperty(value="householdType")
    private HouseHoldType householdType = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;

    protected Household(HouseholdBuilder<?, ?> b) {
        super((EgovOfflineModel.EgovOfflineModelBuilder<?, ?>)b);
        this.memberCount = b.memberCount;
        this.address = b.address;
        this.householdType = b.householdType;
        this.isDeleted = b.isDeleted;
    }

    public static HouseholdBuilder<?, ?> builder() {
        return new HouseholdBuilderImpl();
    }

    public Integer getMemberCount() {
        return this.memberCount;
    }

    public Address getAddress() {
        return this.address;
    }

    public HouseHoldType getHouseholdType() {
        return this.householdType;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="memberCount")
    public void setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="householdType")
    public void setHouseholdType(HouseHoldType householdType) {
        this.householdType = householdType;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Household)) {
            return false;
        }
        Household other = (Household)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        HouseHoldType this$householdType = this.getHouseholdType();
        HouseHoldType other$householdType = other.getHouseholdType();
        return !(this$householdType == null ? other$householdType != null : !((Object)((Object)this$householdType)).equals((Object)other$householdType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Household;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        HouseHoldType $householdType = this.getHouseholdType();
        result = result * 59 + ($householdType == null ? 43 : ((Object)((Object)$householdType)).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Household(memberCount=" + this.getMemberCount() + ", address=" + this.getAddress() + ", householdType=" + this.getHouseholdType() + ", isDeleted=" + this.getIsDeleted() + ")";
    }

    public Household() {
    }

    public Household(Integer memberCount, Address address, HouseHoldType householdType, Boolean isDeleted) {
        this.memberCount = memberCount;
        this.address = address;
        this.householdType = householdType;
        this.isDeleted = isDeleted;
    }

    public static abstract class HouseholdBuilder<C extends Household, B extends HouseholdBuilder<C, B>>
    extends EgovOfflineModel.EgovOfflineModelBuilder<C, B> {
        private Integer memberCount;
        private Address address;
        private HouseHoldType householdType;
        private Boolean isDeleted;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="memberCount")
        public B memberCount(Integer memberCount) {
            this.memberCount = memberCount;
            return (B)this.self();
        }

        @JsonProperty(value="address")
        public B address(Address address) {
            this.address = address;
            return (B)this.self();
        }

        @JsonProperty(value="householdType")
        public B householdType(HouseHoldType householdType) {
            this.householdType = householdType;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Household.HouseholdBuilder(super=" + super.toString() + ", memberCount=" + this.memberCount + ", address=" + this.address + ", householdType=" + this.householdType + ", isDeleted=" + this.isDeleted + ")";
        }
    }

    private static final class HouseholdBuilderImpl
    extends HouseholdBuilder<Household, HouseholdBuilderImpl> {
        private HouseholdBuilderImpl() {
        }

        @Override
        protected HouseholdBuilderImpl self() {
            return this;
        }

        @Override
        public Household build() {
            return new Household(this);
        }
    }
}

