/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.core.Pagination;
import org.egov.common.models.service.Service;
import org.springframework.validation.annotation.Validated;

@Validated
public class ServiceResponse {
    @JsonProperty(value="ResponseInfo")
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Services")
    @Valid
    private List<Service> services = null;
    @JsonProperty(value="Pagination")
    @Valid
    private Pagination pagination = null;

    public ServiceResponse addServiceItem(Service serviceItem) {
        if (this.services == null) {
            this.services = new ArrayList<Service>();
        }
        this.services.add(serviceItem);
        return this;
    }

    public static ServiceResponseBuilder builder() {
        return new ServiceResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Service> getServices() {
        return this.services;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Services")
    public void setServices(List<Service> services) {
        this.services = services;
    }

    @JsonProperty(value="Pagination")
    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceResponse)) {
            return false;
        }
        ServiceResponse other = (ServiceResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Service> this$services = this.getServices();
        List<Service> other$services = other.getServices();
        if (this$services == null ? other$services != null : !((Object)this$services).equals(other$services)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        return !(this$pagination == null ? other$pagination != null : !((Object)this$pagination).equals(other$pagination));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Service> $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : ((Object)$pagination).hashCode());
        return result;
    }

    public String toString() {
        return "ServiceResponse(responseInfo=" + this.getResponseInfo() + ", services=" + this.getServices() + ", pagination=" + this.getPagination() + ")";
    }

    public ServiceResponse(ResponseInfo responseInfo, List<Service> services, Pagination pagination) {
        this.responseInfo = responseInfo;
        this.services = services;
        this.pagination = pagination;
    }

    public ServiceResponse() {
    }

    public static class ServiceResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Service> services;
        private Pagination pagination;

        ServiceResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ServiceResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Services")
        public ServiceResponseBuilder services(List<Service> services) {
            this.services = services;
            return this;
        }

        @JsonProperty(value="Pagination")
        public ServiceResponseBuilder pagination(Pagination pagination) {
            this.pagination = pagination;
            return this;
        }

        public ServiceResponse build() {
            return new ServiceResponse(this.responseInfo, this.services, this.pagination);
        }

        public String toString() {
            return "ServiceResponse.ServiceResponseBuilder(responseInfo=" + this.responseInfo + ", services=" + this.services + ", pagination=" + this.pagination + ")";
        }
    }
}

