/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovModel;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of an ABHA transaction for an Individual.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class AbhaTransaction
extends EgovModel {
    @JsonProperty(value="individualId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String individualId = null;
    @JsonProperty(value="transactionId")
    @Size(max=255)
    private @Size(max=255) String transactionId = null;
    @JsonProperty(value="abhaNumber")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String abhaNumber = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;

    protected AbhaTransaction(AbhaTransactionBuilder<?, ?> b) {
        super(b);
        this.individualId = b.individualId;
        this.transactionId = b.transactionId;
        this.abhaNumber = b.abhaNumber;
        this.additionalDetails = b.additionalDetails;
        this.isDeleted = b.isDeleted;
    }

    public static AbhaTransactionBuilder<?, ?> builder() {
        return new AbhaTransactionBuilderImpl();
    }

    public String getIndividualId() {
        return this.individualId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getAbhaNumber() {
        return this.abhaNumber;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="individualId")
    public void setIndividualId(String individualId) {
        this.individualId = individualId;
    }

    @JsonProperty(value="transactionId")
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    @JsonProperty(value="abhaNumber")
    public void setAbhaNumber(String abhaNumber) {
        this.abhaNumber = abhaNumber;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbhaTransaction)) {
            return false;
        }
        AbhaTransaction other = (AbhaTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$individualId = this.getIndividualId();
        String other$individualId = other.getIndividualId();
        if (this$individualId == null ? other$individualId != null : !this$individualId.equals(other$individualId)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$abhaNumber = this.getAbhaNumber();
        String other$abhaNumber = other.getAbhaNumber();
        if (this$abhaNumber == null ? other$abhaNumber != null : !this$abhaNumber.equals(other$abhaNumber)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        return !(this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbhaTransaction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $individualId = this.getIndividualId();
        result = result * 59 + ($individualId == null ? 43 : $individualId.hashCode());
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $abhaNumber = this.getAbhaNumber();
        result = result * 59 + ($abhaNumber == null ? 43 : $abhaNumber.hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AbhaTransaction(individualId=" + this.getIndividualId() + ", transactionId=" + this.getTransactionId() + ", abhaNumber=" + this.getAbhaNumber() + ", additionalDetails=" + this.getAdditionalDetails() + ", isDeleted=" + this.getIsDeleted() + ")";
    }

    public AbhaTransaction() {
    }

    public AbhaTransaction(String individualId, String transactionId, String abhaNumber, Object additionalDetails, Boolean isDeleted) {
        this.individualId = individualId;
        this.transactionId = transactionId;
        this.abhaNumber = abhaNumber;
        this.additionalDetails = additionalDetails;
        this.isDeleted = isDeleted;
    }

    public static abstract class AbhaTransactionBuilder<C extends AbhaTransaction, B extends AbhaTransactionBuilder<C, B>>
    extends EgovModel.EgovModelBuilder<C, B> {
        private String individualId;
        private String transactionId;
        private String abhaNumber;
        private Object additionalDetails;
        private Boolean isDeleted;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="individualId")
        public B individualId(String individualId) {
            this.individualId = individualId;
            return (B)this.self();
        }

        @JsonProperty(value="transactionId")
        public B transactionId(String transactionId) {
            this.transactionId = transactionId;
            return (B)this.self();
        }

        @JsonProperty(value="abhaNumber")
        public B abhaNumber(String abhaNumber) {
            this.abhaNumber = abhaNumber;
            return (B)this.self();
        }

        @JsonProperty(value="additionalDetails")
        public B additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "AbhaTransaction.AbhaTransactionBuilder(super=" + super.toString() + ", individualId=" + this.individualId + ", transactionId=" + this.transactionId + ", abhaNumber=" + this.abhaNumber + ", additionalDetails=" + this.additionalDetails + ", isDeleted=" + this.isDeleted + ")";
        }
    }

    private static final class AbhaTransactionBuilderImpl
    extends AbhaTransactionBuilder<AbhaTransaction, AbhaTransactionBuilderImpl> {
        private AbhaTransactionBuilderImpl() {
        }

        @Override
        protected AbhaTransactionBuilderImpl self() {
            return this;
        }

        @Override
        public AbhaTransaction build() {
            return new AbhaTransaction(this);
        }
    }
}

