/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import org.egov.common.contract.request.RequestInfo;

public class AbhaCardFetchRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull(message="RequestInfo cannot be null")
    private @NotNull(message="RequestInfo cannot be null") RequestInfo requestInfo;
    @JsonProperty(value="abhaNumber")
    @NotBlank(message="abhaNumber cannot be blank")
    private @NotBlank(message="abhaNumber cannot be blank") String abhaNumber;
    @JsonProperty(value="cardType")
    @NotBlank(message="cardType is mandatory")
    @Pattern(regexp="getCard|getSvgCard|getPngCard", message="cardType must be one of: getCard, getSvgCard, getPngCard")
    private @NotBlank(message="cardType is mandatory") @Pattern(regexp="getCard|getSvgCard|getPngCard", message="cardType must be one of: getCard, getSvgCard, getPngCard") String cardType;

    public static AbhaCardFetchRequestBuilder builder() {
        return new AbhaCardFetchRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public String getAbhaNumber() {
        return this.abhaNumber;
    }

    public String getCardType() {
        return this.cardType;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="abhaNumber")
    public void setAbhaNumber(String abhaNumber) {
        this.abhaNumber = abhaNumber;
    }

    @JsonProperty(value="cardType")
    public void setCardType(String cardType) {
        this.cardType = cardType;
    }

    public AbhaCardFetchRequest() {
    }

    public AbhaCardFetchRequest(RequestInfo requestInfo, String abhaNumber, String cardType) {
        this.requestInfo = requestInfo;
        this.abhaNumber = abhaNumber;
        this.cardType = cardType;
    }

    public static class AbhaCardFetchRequestBuilder {
        private RequestInfo requestInfo;
        private String abhaNumber;
        private String cardType;

        AbhaCardFetchRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public AbhaCardFetchRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="abhaNumber")
        public AbhaCardFetchRequestBuilder abhaNumber(String abhaNumber) {
            this.abhaNumber = abhaNumber;
            return this;
        }

        @JsonProperty(value="cardType")
        public AbhaCardFetchRequestBuilder cardType(String cardType) {
            this.cardType = cardType;
            return this;
        }

        public AbhaCardFetchRequest build() {
            return new AbhaCardFetchRequest(this.requestInfo, this.abhaNumber, this.cardType);
        }

        public String toString() {
            return "AbhaCardFetchRequest.AbhaCardFetchRequestBuilder(requestInfo=" + this.requestInfo + ", abhaNumber=" + this.abhaNumber + ", cardType=" + this.cardType + ")";
        }
    }
}

