/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.stock;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.stock.Stock;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class StockBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Stock")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<Stock> stock = new ArrayList<Stock>();

    public StockBulkRequest addStockItem(Stock stockItem) {
        this.stock.add(stockItem);
        return this;
    }

    public static StockBulkRequestBuilder builder() {
        return new StockBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Stock> getStock() {
        return this.stock;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Stock")
    public void setStock(List<Stock> stock) {
        this.stock = stock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StockBulkRequest)) {
            return false;
        }
        StockBulkRequest other = (StockBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Stock> this$stock = this.getStock();
        List<Stock> other$stock = other.getStock();
        return !(this$stock == null ? other$stock != null : !((Object)this$stock).equals(other$stock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StockBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Stock> $stock = this.getStock();
        result = result * 59 + ($stock == null ? 43 : ((Object)$stock).hashCode());
        return result;
    }

    public String toString() {
        return "StockBulkRequest(requestInfo=" + this.getRequestInfo() + ", stock=" + this.getStock() + ")";
    }

    public StockBulkRequest() {
    }

    public StockBulkRequest(RequestInfo requestInfo, List<Stock> stock) {
        this.requestInfo = requestInfo;
        this.stock = stock;
    }

    public static class StockBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<Stock> stock;

        StockBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public StockBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Stock")
        public StockBulkRequestBuilder stock(List<Stock> stock) {
            this.stock = stock;
            return this;
        }

        public StockBulkRequest build() {
            return new StockBulkRequest(this.requestInfo, this.stock);
        }

        public String toString() {
            return "StockBulkRequest.StockBulkRequestBuilder(requestInfo=" + this.requestInfo + ", stock=" + this.stock + ")";
        }
    }
}

