/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.models.AuditDetails;
import org.egov.common.models.service.AttributeValue;
import org.springframework.validation.annotation.Validated;

@Validated
public class Service {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String tenantId = null;
    @JsonProperty(value="serviceDefId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String serviceDefId = null;
    @JsonProperty(value="referenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String referenceId = null;
    @JsonProperty(value="attributes")
    @NotNull
    @Valid
    private List<AttributeValue> attributes = new ArrayList<AttributeValue>();
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonProperty(value="additionalFields")
    private Object additionalDetails = null;
    @JsonProperty(value="accountId")
    @NotNull
    @Size(max=64)
    private @NotNull @Size(max=64) String accountId = null;
    @JsonProperty(value="clientId")
    @Size(max=64)
    private @Size(max=64) String clientId = null;

    public Service addAttributesItem(AttributeValue attributesItem) {
        this.attributes.add(attributesItem);
        return this;
    }

    public static ServiceBuilder builder() {
        return new ServiceBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getServiceDefId() {
        return this.serviceDefId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public List<AttributeValue> getAttributes() {
        return this.attributes;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="serviceDefId")
    public void setServiceDefId(String serviceDefId) {
        this.serviceDefId = serviceDefId;
    }

    @JsonProperty(value="referenceId")
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @JsonProperty(value="attributes")
    public void setAttributes(List<AttributeValue> attributes) {
        this.attributes = attributes;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="accountId")
    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    @JsonProperty(value="clientId")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Service)) {
            return false;
        }
        Service other = (Service)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$serviceDefId = this.getServiceDefId();
        String other$serviceDefId = other.getServiceDefId();
        if (this$serviceDefId == null ? other$serviceDefId != null : !this$serviceDefId.equals(other$serviceDefId)) {
            return false;
        }
        String this$referenceId = this.getReferenceId();
        String other$referenceId = other.getReferenceId();
        if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
            return false;
        }
        List<AttributeValue> this$attributes = this.getAttributes();
        List<AttributeValue> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        if (this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails)) {
            return false;
        }
        Object this$additionalDetails = this.getAdditionalDetails();
        Object other$additionalDetails = other.getAdditionalDetails();
        if (this$additionalDetails == null ? other$additionalDetails != null : !this$additionalDetails.equals(other$additionalDetails)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        if (this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        return !(this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Service;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $serviceDefId = this.getServiceDefId();
        result = result * 59 + ($serviceDefId == null ? 43 : $serviceDefId.hashCode());
        String $referenceId = this.getReferenceId();
        result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
        List<AttributeValue> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        Object $additionalDetails = this.getAdditionalDetails();
        result = result * 59 + ($additionalDetails == null ? 43 : $additionalDetails.hashCode());
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        return result;
    }

    public String toString() {
        return "Service(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", serviceDefId=" + this.getServiceDefId() + ", referenceId=" + this.getReferenceId() + ", attributes=" + this.getAttributes() + ", auditDetails=" + this.getAuditDetails() + ", additionalDetails=" + this.getAdditionalDetails() + ", accountId=" + this.getAccountId() + ", clientId=" + this.getClientId() + ")";
    }

    public Service(String id, String tenantId, String serviceDefId, String referenceId, List<AttributeValue> attributes, AuditDetails auditDetails, Object additionalDetails, String accountId, String clientId) {
        this.id = id;
        this.tenantId = tenantId;
        this.serviceDefId = serviceDefId;
        this.referenceId = referenceId;
        this.attributes = attributes;
        this.auditDetails = auditDetails;
        this.additionalDetails = additionalDetails;
        this.accountId = accountId;
        this.clientId = clientId;
    }

    public Service() {
    }

    public static class ServiceBuilder {
        private String id;
        private String tenantId;
        private String serviceDefId;
        private String referenceId;
        private List<AttributeValue> attributes;
        private AuditDetails auditDetails;
        private Object additionalDetails;
        private String accountId;
        private String clientId;

        ServiceBuilder() {
        }

        @JsonProperty(value="id")
        public ServiceBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ServiceBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="serviceDefId")
        public ServiceBuilder serviceDefId(String serviceDefId) {
            this.serviceDefId = serviceDefId;
            return this;
        }

        @JsonProperty(value="referenceId")
        public ServiceBuilder referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this;
        }

        @JsonProperty(value="attributes")
        public ServiceBuilder attributes(List<AttributeValue> attributes) {
            this.attributes = attributes;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public ServiceBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public ServiceBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="accountId")
        public ServiceBuilder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        @JsonProperty(value="clientId")
        public ServiceBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Service build() {
            return new Service(this.id, this.tenantId, this.serviceDefId, this.referenceId, this.attributes, this.auditDetails, this.additionalDetails, this.accountId, this.clientId);
        }

        public String toString() {
            return "Service.ServiceBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", serviceDefId=" + this.serviceDefId + ", referenceId=" + this.referenceId + ", attributes=" + this.attributes + ", auditDetails=" + this.auditDetails + ", additionalDetails=" + this.additionalDetails + ", accountId=" + this.accountId + ", clientId=" + this.clientId + ")";
        }
    }
}

