/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovModel;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="This object defines the mapping of a system staff user to a project for a certain period.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectStaff
extends EgovModel {
    @JsonProperty(value="userId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String userId = null;
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="startDate")
    private Long startDate = null;
    @JsonProperty(value="endDate")
    private Long endDate = null;
    @JsonProperty(value="channel")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String channel = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;

    protected ProjectStaff(ProjectStaffBuilder<?, ?> b) {
        super(b);
        this.userId = b.userId;
        this.projectId = b.projectId;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
        this.channel = b.channel;
        this.isDeleted = b.isDeleted;
    }

    public static ProjectStaffBuilder<?, ?> builder() {
        return new ProjectStaffBuilderImpl();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public String getChannel() {
        return this.channel;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="channel")
    public void setChannel(String channel) {
        this.channel = channel;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectStaff)) {
            return false;
        }
        ProjectStaff other = (ProjectStaff)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startDate = this.getStartDate();
        Long other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Long this$endDate = this.getEndDate();
        Long other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        return !(this$channel == null ? other$channel != null : !this$channel.equals(other$channel));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectStaff;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Long $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectStaff(userId=" + this.getUserId() + ", projectId=" + this.getProjectId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", channel=" + this.getChannel() + ", isDeleted=" + this.getIsDeleted() + ")";
    }

    public ProjectStaff() {
    }

    public ProjectStaff(String userId, String projectId, Long startDate, Long endDate, String channel, Boolean isDeleted) {
        this.userId = userId;
        this.projectId = projectId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.channel = channel;
        this.isDeleted = isDeleted;
    }

    public static abstract class ProjectStaffBuilder<C extends ProjectStaff, B extends ProjectStaffBuilder<C, B>>
    extends EgovModel.EgovModelBuilder<C, B> {
        private String userId;
        private String projectId;
        private Long startDate;
        private Long endDate;
        private String channel;
        private Boolean isDeleted;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="userId")
        public B userId(String userId) {
            this.userId = userId;
            return (B)this.self();
        }

        @JsonProperty(value="projectId")
        public B projectId(String projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        @JsonProperty(value="startDate")
        public B startDate(Long startDate) {
            this.startDate = startDate;
            return (B)this.self();
        }

        @JsonProperty(value="endDate")
        public B endDate(Long endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @JsonProperty(value="channel")
        public B channel(String channel) {
            this.channel = channel;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ProjectStaff.ProjectStaffBuilder(super=" + super.toString() + ", userId=" + this.userId + ", projectId=" + this.projectId + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", channel=" + this.channel + ", isDeleted=" + this.isDeleted + ")";
        }
    }

    private static final class ProjectStaffBuilderImpl
    extends ProjectStaffBuilder<ProjectStaff, ProjectStaffBuilderImpl> {
        private ProjectStaffBuilderImpl() {
        }

        @Override
        protected ProjectStaffBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectStaff build() {
            return new ProjectStaff(this);
        }
    }
}

